/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.param;

import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.regex.Pattern;
import org.eclipse.cdt.codan.core.param.AbstractProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceDescriptor;

public class BasicProblemPreference
extends AbstractProblemPreference {
    protected Object value;
    private IProblemPreferenceDescriptor.PreferenceType type = IProblemPreferenceDescriptor.PreferenceType.TYPE_STRING;

    @Override
    public IProblemPreferenceDescriptor.PreferenceType getType() {
        return this.type;
    }

    public void setType(IProblemPreferenceDescriptor.PreferenceType type) {
        if (type == null) {
            throw new NullPointerException("Type cannot be null");
        }
        this.type = type;
    }

    public BasicProblemPreference(String key, String label, IProblemPreferenceDescriptor.PreferenceType type) {
        this(key, label);
        this.setType(type);
    }

    public BasicProblemPreference(String key, String label) {
        this.setKey(key);
        this.setLabel(label);
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String exportValue() {
        String x;
        Pattern pat = Pattern.compile("^[A-Za-z0-9._-]+$");
        if (!pat.matcher(x = String.valueOf(this.getValue())).find()) {
            return this.escape(x);
        }
        return x;
    }

    @Override
    public void importValue(String str) {
        if (str.startsWith("\"")) {
            str = this.unescape(str);
        }
        switch (this.getType()) {
            case TYPE_STRING: {
                this.setValue(str);
                break;
            }
            case TYPE_INTEGER: {
                this.setValue(Integer.parseInt(str));
                break;
            }
            case TYPE_BOOLEAN: {
                this.setValue(Boolean.valueOf(str));
                break;
            }
            case TYPE_FILE: {
                this.setValue(new File(str));
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)this.getType()) + " is not supported for basic type");
            }
        }
    }

    public String toString() {
        return "(" + (Object)((Object)this.type) + ")" + this.getKey() + (this.value == null ? "" : "=" + this.value);
    }

    @Override
    public void importValue(StreamTokenizer tokenizer) {
        try {
            tokenizer.nextToken();
            String val = tokenizer.sval;
            this.importValue(val);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

