/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model.ui;

import com.jgoodies.forms.layout.ConstantSize;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeConstantInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.UnitDescription;

public final class ConstantSizeComposite
extends Composite {
    private final UnitDescription[] m_units;
    private final Spinner m_valueSpinner;
    private final Combo m_unitsCombo;
    private FormSizeConstantInfo m_currentSize;
    private double m_divider;

    public ConstantSizeComposite(Composite parent, int style, UnitDescription[] units) {
        super(parent, style);
        this.m_units = units;
        GridLayoutFactory.create((Composite)this).columns(2).noMargins();
        this.m_valueSpinner = new Spinner((Composite)this, 2048);
        GridDataFactory.create((Control)this.m_valueSpinner).hintHC(10);
        this.m_valueSpinner.setMinimum(0);
        this.m_valueSpinner.setMaximum(Integer.MAX_VALUE);
        this.m_valueSpinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConstantSizeComposite.this.m_currentSize.setValue((double)ConstantSizeComposite.this.m_valueSpinner.getSelection() / ConstantSizeComposite.this.m_divider);
                ConstantSizeComposite.this.notifySelection();
            }
        });
        this.m_unitsCombo = new Combo((Composite)this, 8);
        GridDataFactory.create((Control)this.m_unitsCombo).hintHC(15);
        this.m_unitsCombo.setVisibleItemCount(this.m_units.length);
        int i = 0;
        while (i < this.m_units.length) {
            UnitDescription description = this.m_units[i];
            this.m_unitsCombo.add(description.getTitle());
            ++i;
        }
        this.m_unitsCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int unitIndex = ConstantSizeComposite.this.m_unitsCombo.getSelectionIndex();
                ConstantSize.Unit unit = ConstantSizeComposite.this.m_units[unitIndex].getUnit();
                try {
                    ConstantSizeComposite.this.m_currentSize.setUnit(unit);
                    ConstantSizeComposite.this.configureSpinnerForUnit();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ConstantSizeComposite.this.notifySelection();
            }
        });
    }

    public FormSizeConstantInfo getConstantSize() {
        return new FormSizeConstantInfo(this.m_currentSize.getValue(), this.m_currentSize.getUnit());
    }

    public void setConstantSize(FormSizeConstantInfo size) {
        if (size != null) {
            this.m_currentSize = new FormSizeConstantInfo(size.getValue(), size.getUnit());
            this.configureSpinnerForUnit();
            int value = (int)(size.getValue() * this.m_divider);
            if (this.m_valueSpinner.getSelection() != value) {
                this.m_valueSpinner.setSelection(value);
            }
            int i = 0;
            while (i < this.m_units.length) {
                UnitDescription description = this.m_units[i];
                if (size.getUnit() == description.getUnit()) {
                    this.m_unitsCombo.select(i);
                }
                ++i;
            }
        } else {
            this.m_valueSpinner.setSelection(0);
            this.m_unitsCombo.select(0);
        }
    }

    private void configureSpinnerForUnit() {
        ConstantSize.Unit unit = this.m_currentSize.getUnit();
        if (unit == ConstantSize.PIXEL || unit == ConstantSize.POINT || unit == ConstantSize.DIALOG_UNITS_X || unit == ConstantSize.DIALOG_UNITS_Y) {
            this.m_valueSpinner.setDigits(0);
            this.m_divider = 1.0;
        } else {
            this.m_valueSpinner.setDigits(1);
            this.m_divider = 10.0;
        }
    }

    private void notifySelection() {
        this.notifyListeners(13, null);
    }
}

