/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.GenericASTVisitorWithLoops;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTArrayDeclaratorNode;
import org.eclipse.photran.internal.core.parser.ASTArraySpecNode;
import org.eclipse.photran.internal.core.parser.ASTAttrSpecSeqNode;
import org.eclipse.photran.internal.core.parser.ASTCharSelectorNode;
import org.eclipse.photran.internal.core.parser.ASTContainsStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDimensionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTListNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTObjectNameNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.parser.IInternalSubprogram;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class ExtractProcedureRefactoring
extends FortranEditorRefactoring {
    private FortranResourceRefactoring.StatementSequence selection = null;
    private List<Definition> localVarsToPassInAsParams = new LinkedList<Definition>();
    private String newName = null;

    @Override
    public String getName() {
        return Messages.ExtractProcedureRefactoring_Name;
    }

    public void setName(String name) {
        assert (name != null);
        this.newName = name;
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        LoopReplacer.replaceAllLoopsIn(this.astOfFileInEditor.getRoot());
        this.selection = ExtractProcedureRefactoring.findEnclosingStatementSequence(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (this.selection == null || this.selection.selectedStmts.isEmpty()) {
            this.fail(Messages.ExtractProcedureRefactoring_PleaseSelectContiguousStatements);
        }
        if (this.selection.enclosingScope == null) {
            this.fail("INTERNAL ERROR: Unable to locate enclosing scope");
        }
        if (!this.selection.enclosingScope.isSubprogram() && !this.selection.enclosingScope.isMainProgram()) {
            this.fail(Messages.ExtractProcedureRefactoring_CanOnlyExtractFromSubprogramOrMainProgram);
        }
        for (IASTNode stmt : this.selection.selectedStmts) {
            if (stmt instanceof IBodyConstruct) continue;
            this.fail(Messages.bind((String)Messages.ExtractProcedureRefactoring_StatementCannotBeExtracted, (Object)stmt.toString().trim()));
        }
        this.checkForLabels(status);
        for (IASTNode stmt : this.selection.selectedStmts) {
            if (stmt instanceof IExecutionPartConstruct) continue;
            this.fail(Messages.bind((String)Messages.ExtractProcedureRefactoring_OnlyExecutableStatementsCanBeExtracted, (Object)stmt.toString().trim()));
        }
        this.determineParameters();
        for (Definition param : this.localVarsToPassInAsParams) {
            if (!param.isPointer()) continue;
            this.fail(Messages.ExtractProcedureRefactoring_ExtractionWouldRequirePointerParameter);
        }
    }

    private void checkForLabels(RefactoringStatus status) {
        Pattern numericLabel = Pattern.compile("[0-9]+");
        for (IASTNode iASTNode : this.selection.enclosingScope.getBody()) {
            if (!numericLabel.matcher(iASTNode.findFirstToken().getText()).matches()) continue;
            status.addWarning(Messages.ExtractProcedureRefactoring_ProcedureContainsLabels, this.createContext(iASTNode.findFirstToken().getTokenRef()));
            return;
        }
    }

    private void determineParameters() {
        this.localVarsToPassInAsParams.addAll(this.localVariablesUsedIn(this.selection.selectedStmts));
        this.localVarsToPassInAsParams.addAll(0, this.localVarsReferencedInDecls());
    }

    private List<Definition> localVarsReferencedInDecls() {
        LinkedList<Definition> result = new LinkedList<Definition>();
        Set<Definition> addlVars = this.addlLocalVariablesReferencedIn(this.localVarsToPassInAsParams);
        while (!addlVars.isEmpty()) {
            result.addAll(0, addlVars);
            addlVars = this.addlLocalVariablesReferencedIn(result);
        }
        return result;
    }

    private Set<Definition> localVariablesUsedIn(List<IASTNode> stmts) {
        TreeSet<Definition> result = new TreeSet<Definition>();
        for (IASTNode stmt : this.selection.selectedStmts) {
            result.addAll(this.localVariablesUsedIn(stmt));
        }
        return result;
    }

    private Set<Definition> localVariablesUsedIn(IASTNode node) {
        final TreeSet<Definition> result = new TreeSet<Definition>();
        node.accept(new GenericASTVisitorWithLoops(){

            @Override
            public void visitToken(Token token) {
                if (token.getTerminal() == Terminal.T_IDENT) {
                    for (Definition def : token.resolveBinding()) {
                        if (!def.isLocalVariable()) continue;
                        result.add(def);
                    }
                }
            }
        });
        return result;
    }

    private Set<Definition> addlLocalVariablesReferencedIn(Collection<Definition> vars) {
        TreeSet<Definition> result = new TreeSet<Definition>();
        for (Definition def : vars) {
            ASTArraySpecNode arraySpec = this.findArraySpec(def);
            if (arraySpec == null) continue;
            result.addAll(this.localVariablesUsedIn(arraySpec));
        }
        return result;
    }

    private ASTArraySpecNode findArraySpec(Definition def) {
        ASTArraySpecNode arraySpec = this.findArraySpecInTypeDecl(def);
        if (arraySpec != null) {
            return arraySpec;
        }
        arraySpec = this.findArraySpecInDimensionStmt(def);
        return arraySpec;
    }

    private ASTArraySpecNode findArraySpecInTypeDecl(Definition def) {
        ASTTypeDeclarationStmtNode typeDecl = this.findTypeDeclaration(def);
        if (typeDecl != null) {
            if (typeDecl.getAttrSpecSeq() != null) {
                for (ASTAttrSpecSeqNode attrSpecSeq : typeDecl.getAttrSpecSeq()) {
                    if (!attrSpecSeq.getAttrSpec().isDimension()) continue;
                    return attrSpecSeq.getAttrSpec().getArraySpec();
                }
            }
            for (ASTEntityDeclNode decl : typeDecl.getEntityDeclList()) {
                if (decl.getArraySpec() == null || !this.matches(decl.getObjectName(), def)) continue;
                return decl.getArraySpec();
            }
        }
        return null;
    }

    private ASTTypeDeclarationStmtNode findTypeDeclaration(Definition def) {
        return def.getTokenRef().findToken().findNearestAncestor(ASTTypeDeclarationStmtNode.class);
    }

    private ASTArraySpecNode findArraySpecInDimensionStmt(Definition def) {
        ScopingNode scope = def.getTokenRef().findToken().findNearestAncestor(ScopingNode.class);
        class Visitor
        extends GenericASTVisitor {
            private ASTArraySpecNode result = null;
            private final /* synthetic */ Definition val$def;

            Visitor(Definition definition) {
                this.val$def = definition;
            }

            @Override
            public void visitASTDimensionStmtNode(ASTDimensionStmtNode node) {
                for (ASTArrayDeclaratorNode arrayDeclarator : node.getArrayDeclaratorList()) {
                    if (!ExtractProcedureRefactoring.this.matches(arrayDeclarator, this.val$def)) continue;
                    this.result = arrayDeclarator.getArraySpec();
                }
            }
        }
        Visitor v = new Visitor(def);
        scope.accept(v);
        return v.result;
    }

    private boolean matches(ASTArrayDeclaratorNode arrayDeclarator, Definition def) {
        String declVar = PhotranVPG.canonicalizeIdentifier(arrayDeclarator.getVariableName().getText());
        String targetVar = def.getCanonicalizedName();
        return declVar.equals(targetVar);
    }

    private boolean matches(ASTObjectNameNode objectName, Definition def) {
        String declVar = PhotranVPG.canonicalizeIdentifier(objectName.getObjectName().getText());
        String targetVar = def.getCanonicalizedName();
        return declVar.equals(targetVar);
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        assert (this.selection != null && (this.selection.enclosingScope.isSubprogram() || this.selection.enclosingScope.isMainProgram()));
        assert (this.newName != null);
        this.checkIfSubprogramNameIsValid();
        this.checkIfSubprogramNameWillConflict(status);
    }

    private void checkIfSubprogramNameIsValid() throws VPGRefactoring.PreconditionFailure {
        if (!ExtractProcedureRefactoring.isValidIdentifier(this.newName)) {
            this.fail(Messages.bind((String)Messages.ExtractProcedureRefactoring_InvalidIdentifier, (Object)this.newName));
        }
    }

    private void checkIfSubprogramNameWillConflict(RefactoringStatus status) {
        ScopingNode enclosingSubprogram = this.selection.enclosingScope;
        ScopingNode outerScope = enclosingSubprogram.findNearestAncestor(ScopingNode.class);
        if (outerScope == null) {
            throw new Error("INTERNAL ERROR: No outer scope");
        }
        Token.FakeToken newSubprogramName = new Token.FakeToken(enclosingSubprogram.getNameToken(), this.newName);
        List<PhotranTokenRef> conflictingDefs = outerScope.manuallyResolveNoImplicits(newSubprogramName);
        if (!conflictingDefs.isEmpty()) {
            PhotranTokenRef conflict = conflictingDefs.get(0);
            Token conflictToken = conflict.findToken();
            status.addError(Messages.bind((String)Messages.ExtractProcedureRefactoring_NameConflicts, (Object[])new Object[]{this.newName, conflictToken.getText(), conflictToken.getLine(), conflict.getFilename()}), this.createContext(conflict));
        }
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        assert (this.selection != null && (this.selection.enclosingScope.isSubprogram() || this.selection.enclosingScope.isMainProgram()));
        assert (this.newName != null);
        try {
            ASTSubroutineSubprogramNode newSubprogram = this.createNewSubprogram();
            this.insertSubroutineCall();
            this.moveStatementsIntoBodyOf(newSubprogram);
            this.addChangeFromModifiedAST(this.fileInEditor, pm);
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private ASTSubroutineSubprogramNode createNewSubprogram() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("subroutine ");
        sb.append(this.newName);
        sb.append(this.parameterList());
        sb.append("\n");
        sb.append(Reindenter.defaultIndentation());
        sb.append("implicit none\n");
        sb.append(this.parameterDeclarations());
        sb.append("end subroutine\n");
        ASTSubroutineSubprogramNode newSubroutine = (ASTSubroutineSubprogramNode)ExtractProcedureRefactoring.parseLiteralProgramUnit(sb.toString());
        return this.insertNewSubprogram(newSubroutine);
    }

    private ASTSubroutineSubprogramNode insertNewSubprogram(ASTSubroutineSubprogramNode newSubroutine) {
        if (this.selection.enclosingScope.isSubprogram()) {
            return this.insertAfterEnclosingSubprogram(newSubroutine);
        }
        if (this.selection.enclosingScope.isMainProgram()) {
            return this.insertAsInternalSubprogramOf((ASTMainProgramNode)this.selection.enclosingScope, newSubroutine);
        }
        throw new IllegalStateException();
    }

    private ASTSubroutineSubprogramNode insertAfterEnclosingSubprogram(ASTSubroutineSubprogramNode newSubroutine) {
        ScopingNode enclosingSubprogram = this.selection.enclosingScope;
        IASTNode parent = enclosingSubprogram.getParent();
        if (!(parent instanceof IASTListNode)) {
            throw new Error("INTERNAL ERROR: Subprogram parent is not IASTListNode");
        }
        ((IASTListNode)parent).insertAfter(enclosingSubprogram, newSubroutine);
        Reindenter.reindent(newSubroutine, this.astOfFileInEditor);
        return newSubroutine;
    }

    private ASTSubroutineSubprogramNode insertAsInternalSubprogramOf(ASTMainProgramNode program, ASTSubroutineSubprogramNode subprogram) {
        if (program.getContainsStmt() == null) {
            ASTContainsStmtNode containsStmt = ExtractProcedureRefactoring.createContainsStmt();
            program.setContainsStmt(containsStmt);
            containsStmt.setParent(program);
        }
        if (program.getInternalSubprograms() == null) {
            ASTListNode<IInternalSubprogram> internals = new ASTListNode<IInternalSubprogram>();
            program.setInternalSubprograms(internals);
            internals.setParent(program);
        }
        program.getInternalSubprograms().add(subprogram);
        subprogram.setParent(program.getInternalSubprograms());
        Reindenter.reindent(subprogram, this.astOfFileInEditor);
        return subprogram;
    }

    private String parameterList() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int i = 0;
        for (Definition var : this.localVarsToPassInAsParams) {
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append(var.getDeclaredName());
        }
        sb.append(")");
        return sb.toString();
    }

    private String parameterDeclarations() {
        StringBuilder sb = new StringBuilder();
        for (Definition var : this.localVarsToPassInAsParams) {
            sb.append(Reindenter.defaultIndentation());
            sb.append(this.declarationOf(var));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String declarationOf(Definition var) {
        StringBuilder sb = new StringBuilder();
        sb.append(var.getType().toString());
        if (var.getType().equals(Type.CHARACTER)) {
            sb.append(this.getCharSelector(var));
        }
        if (var.isAllocatable()) {
            sb.append(", allocatable");
        }
        if (var.isIntentIn() && !var.isIntentOut()) {
            sb.append(", intent(in)");
        }
        if (!var.isIntentIn() && var.isIntentOut()) {
            sb.append(", intent(out)");
        }
        if (var.isPointer()) {
            sb.append(", pointer");
        }
        if (var.isTarget()) {
            sb.append(", target");
        }
        sb.append(" :: ");
        sb.append(var.getDeclaredName());
        if (var.getArraySpec() != null) {
            sb.append(var.getArraySpec());
        }
        return sb.toString();
    }

    private String getCharSelector(Definition var) {
        ASTCharSelectorNode charSelector;
        ASTTypeDeclarationStmtNode typeDeclStmt = var.getTokenRef().findToken().findNearestAncestor(ASTTypeDeclarationStmtNode.class);
        if (typeDeclStmt != null && (charSelector = typeDeclStmt.getTypeSpec().getCharSelector()) != null) {
            return charSelector.toString();
        }
        return "";
    }

    private void insertSubroutineCall() {
        StringBuilder sb = new StringBuilder();
        sb.append("call ");
        sb.append(this.newName);
        sb.append(this.parameterList());
        sb.append("\n");
        IBodyConstruct callStmt = ExtractProcedureRefactoring.parseLiteralStatement(sb.toString());
        this.selection.listContainingStmts.insertBefore(this.selection.firstStmt(), callStmt);
        callStmt.setParent(this.selection.listContainingStmts);
        Reindenter.reindent(callStmt, this.astOfFileInEditor);
    }

    private void moveStatementsIntoBodyOf(ASTSubroutineSubprogramNode newSubprogram) {
        for (IASTNode stmt : this.selection.selectedStmts) {
            assert (stmt instanceof IBodyConstruct);
            stmt.removeFromTree();
            newSubprogram.getBody().add((IBodyConstruct)stmt);
            stmt.setParent(newSubprogram.getBody());
        }
        Reindenter.reindent(this.selection.firstToken(), this.selection.lastToken(), this.astOfFileInEditor);
    }
}

