/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lang.intrinsics.IntrinsicProcDescription;
import org.eclipse.photran.internal.core.lang.intrinsics.Intrinsics;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;

public class Intrinsic
extends Definition {
    private static final long serialVersionUID = 1L;

    public Intrinsic(String declaredName, PhotranTokenRef tokenRef) {
        super(declaredName, tokenRef, Definition.Classification.INTRINSIC, Type.UNKNOWN);
    }

    @Override
    public boolean isExternallyVisibleSubprogramDefinition() {
        return false;
    }

    @Override
    public boolean isSubprogram() {
        return true;
    }

    @Override
    public String describe() {
        String canonicalizedName = PhotranVPG.canonicalizeIdentifier(this.declaredName);
        IntrinsicProcDescription proc = Intrinsics.get((String)canonicalizedName);
        if (proc == null) {
            return "";
        }
        return proc.toString();
    }

    public static Definition resolve(Token identifier) {
        String canonicalizedName = PhotranVPG.canonicalizeIdentifier(identifier.getText());
        for (IntrinsicProcDescription intrinsic : Intrinsics.getAllIntrinsicProcedures()) {
            if (!PhotranVPG.canonicalizeIdentifier(intrinsic.genericName).equals(canonicalizedName)) continue;
            return new Intrinsic(identifier.getText(), identifier.getTokenRef());
        }
        return null;
    }
}

