/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;

public class TmfUiTracer {
    private static String pluginID = "org.eclipse.tracecompass.tmf.ui";
    private static boolean fError = false;
    private static boolean fWarning = false;
    private static boolean fInfo = false;
    private static boolean fIndex = false;
    private static boolean fDisplay = false;
    private static boolean fSorting = false;
    private static final String LOGNAME = "traceUI.log";
    private static BufferedWriter fTraceLog = null;

    private static BufferedWriter openLogFile(String filename) {
        BufferedWriter outfile = null;
        try {
            outfile = new BufferedWriter(new FileWriter(filename));
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error creating log file traceUI.log", e);
        }
        return outfile;
    }

    public static void init() {
        boolean isTracing = false;
        String traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/error"));
        if (traceKey != null) {
            fError = Boolean.parseBoolean(traceKey);
            isTracing |= fError;
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/warning"))) != null) {
            fWarning = Boolean.parseBoolean(traceKey);
            isTracing |= fWarning;
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/info"))) != null) {
            fInfo = Boolean.parseBoolean(traceKey);
            isTracing |= fInfo;
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/updateindex"))) != null) {
            fIndex = Boolean.parseBoolean(traceKey);
            isTracing |= fIndex;
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/display"))) != null) {
            fDisplay = Boolean.parseBoolean(traceKey);
            isTracing |= fDisplay;
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/sorting"))) != null) {
            fSorting = Boolean.parseBoolean(traceKey);
            isTracing |= fSorting;
        }
        if (isTracing) {
            fTraceLog = TmfUiTracer.openLogFile(LOGNAME);
        }
    }

    public static void stop() {
        if (fTraceLog == null) {
            return;
        }
        try {
            fTraceLog.close();
            fTraceLog = null;
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error closing log file traceUI.log", e);
        }
    }

    public static boolean isErrorTraced() {
        return fError;
    }

    public static boolean isIndexTraced() {
        return fIndex;
    }

    public static boolean isDisplayTraced() {
        return fDisplay;
    }

    public static boolean isSortingTraced() {
        return fSorting;
    }

    public static void trace(String msg) {
        if (fTraceLog == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        StringBuilder message = new StringBuilder("[");
        message.append(currentTime / 1000L);
        message.append(".");
        message.append(String.format("%1$03d", currentTime % 1000L));
        message.append("] ");
        message.append(msg);
        System.out.println(message);
        try {
            fTraceLog.write(message.toString());
            fTraceLog.newLine();
            fTraceLog.flush();
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error writing to log file traceUI.log", e);
        }
    }

    public static void traceIndex(String msg) {
        String message = "[INDEX] " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceDisplay(String msg) {
        String message = "[DISPLAY]" + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceSorting(String msg) {
        String message = "[SORT] " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceError(String msg) {
        String message = "[ERR] Thread=" + Thread.currentThread().getId() + " " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceWarning(String msg) {
        String message = "[WARN] Thread=" + Thread.currentThread().getId() + " " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceInfo(String msg) {
        String message = "[INF] Thread=" + Thread.currentThread().getId() + " " + msg;
        TmfUiTracer.trace(message);
    }
}

