/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.model;

import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CallinMethodMappingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementor;

public class ModelElement {
    public AbstractAttribute[] _attributes;

    public void addAttribute(AbstractAttribute attr) {
        if (this._attributes == null) {
            this._attributes = new AbstractAttribute[]{attr};
        } else {
            int len = this._attributes.length;
            AbstractAttribute[] newAttrs = new AbstractAttribute[len + 1];
            System.arraycopy(this._attributes, 0, newAttrs, 0, len);
            newAttrs[len] = attr;
            this._attributes = newAttrs;
        }
    }

    public void addOrMergeAttribute(AbstractAttribute attr) {
        AbstractAttribute existingAttr = null;
        if (this._attributes != null) {
            int i = 0;
            while (i < this._attributes.length) {
                if (this._attributes[i].nameEquals(attr)) {
                    existingAttr = this._attributes[i];
                    break;
                }
                ++i;
            }
        }
        if (existingAttr == null) {
            if (!attr.nameEquals(IOTConstants.CALLIN_METHOD_MAPPINGS)) {
                this.addAttribute(attr);
                return;
            }
            existingAttr = new CallinMethodMappingsAttribute(new CallinMappingDeclaration[0]);
            this.addAttribute(existingAttr);
        }
        existingAttr.merge(this, attr);
        if (attr.nameEquals(IOTConstants.CALLIN_METHOD_MAPPINGS)) {
            CallinImplementor.checkCopyCallinBinding((CallinMethodMappingsAttribute)attr, this);
        }
    }

    public AbstractAttribute getAttribute(char[] name) {
        if (this._attributes == null) {
            return null;
        }
        AbstractAttribute[] abstractAttributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractAttribute attr = abstractAttributeArray[n2];
            if (attr.nameEquals(name)) {
                return attr;
            }
            ++n2;
        }
        return null;
    }

    public void removeAttribute(AbstractAttribute attr) {
        if (this._attributes == null) {
            return;
        }
        int newLength = this._attributes.length - 1;
        AbstractAttribute[] newAttributes = new AbstractAttribute[newLength];
        int i = 0;
        AbstractAttribute[] abstractAttributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractAttribute anAttr = abstractAttributeArray[n2];
            if (anAttr != attr) {
                if (i == newLength) {
                    return;
                }
                newAttributes[i++] = anAttr;
            }
            ++n2;
        }
        this._attributes = newAttributes;
    }

    public static int writeAttributes(ReferenceBinding type, ClassFile file) {
        int count = 0;
        if (type.isTeam()) {
            count += type.getTeamModel().writeAttributes(file);
        }
        if (type.isRole() && type.roleModel != null) {
            count += type.roleModel.writeAttributes(file);
        }
        if (type.model != null) {
            count += type.model.writeAttributes(file);
        }
        return count;
    }

    public int writeAttributes(ClassFile file) {
        if (this._attributes == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < this._attributes.length) {
            if (this._attributes[i].setupForWriting()) {
                this._attributes[i].write(file);
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static void evaluateLateAttributes(ReferenceBinding type, int state) {
        if (type.isTeam()) {
            type.getTeamModel().evaluateLateAttributes(state);
        }
        if (type.isRole() && type.roleModel != null) {
            type.roleModel.evaluateLateAttributes(state);
            type.roleModel.implementMethodBindingsFromSuperinterfaces();
        }
    }
}

