/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.RoleFilesAttribute;

public class RoleFileCache {
    private TypeDeclaration teamDecl;
    private TypeDeclaration _ast = null;
    private List<char[]> knownRoleFiles = new LinkedList<char[]>();
    private ReferenceBinding binaryCache = null;
    public boolean isValid = true;

    public RoleFileCache(TypeDeclaration teamDecl) {
        this.teamDecl = teamDecl;
    }

    public void createTypeAndBinding(Scope scope, LookupEnvironment environment) {
        this._ast = new TypeDeclaration(this.teamDecl.compilationResult);
        this._ast.modifiers = 0x1000000;
        this._ast.isGenerated = true;
        this._ast.bits |= 0x100;
        this._ast.name = IOTConstants.ROFI_CACHE;
        this.teamDecl.scope.addGeneratedType(this._ast);
        this._ast.binding.superInterfaces = Binding.NO_SUPERINTERFACES;
        this._ast.binding.superclass = scope.getJavaLangObject();
        this.readBinary(environment);
    }

    public void addRoleFile(char[] name) {
        if (!this.contains(name)) {
            this.knownRoleFiles.add(name);
        }
    }

    public void generateCode(ClassFile enclosingClassFile) {
        ((LocalTypeBinding)this._ast.binding).setConstantPoolName(CharOperation.concat(this.teamDecl.binding.constantPoolName(), this._ast.name, '$'));
        int len = this.knownRoleFiles.size();
        char[][] names = new char[len][];
        System.arraycopy(this.knownRoleFiles.toArray(), 0, names, 0, len);
        this._ast.getModel().addAttribute(new RoleFilesAttribute(names));
        this._ast.generateCode(enclosingClassFile);
    }

    public char[][] getNames() {
        int len = this.knownRoleFiles.size();
        char[][] names = new char[len][];
        System.arraycopy(this.knownRoleFiles.toArray(), 0, names, 0, len);
        return names;
    }

    private boolean contains(char[] name) {
        for (char[] aName : this.knownRoleFiles) {
            if (!CharOperation.equals(name, aName)) continue;
            return true;
        }
        return false;
    }

    private void readBinary(LookupEnvironment environment) {
        int len = this.teamDecl.binding.compoundName.length;
        char[][] compoundName = new char[len][];
        System.arraycopy(this.teamDecl.binding.compoundName, 0, compoundName, 0, len);
        compoundName[len - 1] = CharOperation.concat(compoundName[len - 1], IOTConstants.ROFI_CACHE, '$');
        try {
            this.binaryCache = environment.askForType(compoundName, this.teamDecl.binding.fPackage.enclosingModule);
            if (this.binaryCache == null) {
                this.isValid = false;
            }
        }
        catch (AbortCompilation abortCompilation) {
            this.isValid = false;
        }
    }

    public void readKnownRoles() {
        char[][] names;
        RoleFilesAttribute attr;
        if (this.binaryCache != null && (attr = this.binaryCache.model._roleFilesAttribute) != null && (names = attr.getNames()) != null) {
            int i = 0;
            while (i < names.length) {
                this.teamDecl.binding.getMemberType(names[i]);
                ++i;
            }
        }
    }

    public static boolean isRoFiCache(ReferenceBinding referenceBinding) {
        return CharOperation.equals(referenceBinding.sourceName, IOTConstants.ROFI_CACHE);
    }
}

