/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.db;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.nd.db.RelatedAddress;

public class IndexException
extends RuntimeException {
    private IStatus status;
    private List<RelatedAddress> relatedAddresses = new ArrayList<RelatedAddress>();
    private long time = -1L;
    private static final long serialVersionUID = -6561893929558916225L;

    public IndexException(IStatus status) {
        this.status = status;
    }

    public IndexException(String message) {
        this((IStatus)new Status(4, "org.eclipse.jdt.core", message));
    }

    public void setTime(long writeNumber) {
        this.time = writeNumber;
    }

    @Override
    public synchronized Throwable getCause() {
        return this.status.getException();
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void addRelatedAddress(RelatedAddress related) {
        for (RelatedAddress next : this.relatedAddresses) {
            if (!next.isSameAddressAs(related)) continue;
            return;
        }
        this.relatedAddresses.add(related);
    }

    @Override
    public String getMessage() {
        StringBuilder result = new StringBuilder();
        if (this.time != -1L) {
            result.append("(time ");
            result.append(this.time);
            result.append(") ");
        }
        result.append(this.status.getMessage());
        if (!this.relatedAddresses.isEmpty()) {
            boolean isFirst = true;
            result.append("\nRelated addresses:\n");
            for (RelatedAddress next : this.relatedAddresses) {
                if (!isFirst) {
                    result.append("\n");
                }
                isFirst = false;
                result.append(next.toString());
            }
        }
        return result.toString();
    }
}

