/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.AbstractElement;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteElementsDialog
extends TitleAreaDialog {
    private final AbstractElement[] elements;
    private Text text;
    private boolean deleteContents = true;

    public DeleteElementsDialog(Shell parentShell, AbstractElement ... elements) {
        super(parentShell);
        this.elements = elements;
        this.setShellStyle(65648);
    }

    public final boolean isDeleteContents() {
        return this.deleteContents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        int size = this.elements.length;
        if (size != 0) {
            boolean repository = this.elements[0] instanceof CDORepository;
            String type = repository ? "Repository" : "Checkout";
            String types = repository ? "Repositories" : "Checkouts";
            String title = "Delete " + (size == 1 ? type : types);
            this.getShell().setText(title);
            this.setTitle(title);
            this.setTitleImage(OM.getImage("icons/wiz/delete_" + type.toLowerCase() + ".gif"));
            this.setMessage("Are you sure you want to delete " + (size == 1 ? "this" : "these") + " " + size + " " + (size == 1 ? type : types).toLowerCase() + "?");
            Composite container = new Composite(area, 0);
            container.setLayoutData((Object)new GridData(1808));
            GridLayout containerGridLayout = new GridLayout();
            containerGridLayout.marginWidth = 10;
            containerGridLayout.marginHeight = 10;
            container.setLayout((Layout)containerGridLayout);
            final Button deleteContentsButton = new Button(container, 32);
            deleteContentsButton.setText("&Delete " + type.toLowerCase() + " contents on disk");
            deleteContentsButton.setSelection(true);
            deleteContentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeleteElementsDialog.this.deleteContents = deleteContentsButton.getSelection();
                }
            });
            new Label(container, 0);
            new Label(container, 0).setText(String.valueOf(type) + " &contents:");
            this.text = new Text(container, 2570);
            this.text.setLayoutData((Object)new GridData(4, 4, true, true));
            ArrayList<String> contents = new ArrayList<String>();
            AbstractElement[] abstractElementArray = this.elements;
            int n = this.elements.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractElement element = abstractElementArray[n2];
                this.collectContents(contents, element.getFolder());
                ++n2;
            }
            if (contents.isEmpty()) {
                deleteContentsButton.setSelection(false);
                deleteContentsButton.setEnabled(false);
                this.text.setEnabled(false);
            } else {
                Collections.sort(contents);
                StringBuilder builder = new StringBuilder();
                for (String path : contents) {
                    if (builder.length() != 0) {
                        builder.append('\n');
                    }
                    builder.append(path);
                }
                this.text.setText(builder.toString());
            }
            deleteContentsButton.setFocus();
        }
        return area;
    }

    private void collectContents(List<String> contents, File folder) {
        File[] children;
        if (folder.isDirectory() && (children = folder.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    this.collectContents(contents, child);
                } else {
                    contents.add(child.getAbsolutePath());
                }
                ++n2;
            }
        }
    }

    protected Point getInitialSize() {
        return new Point(700, 400);
    }
}

