/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.ChartCubeQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartExpressionButtonUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIUtil;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ChartExpressionProvider;
import org.eclipse.birt.chart.reportitem.ui.views.attributes.provider.ChartCubeFilterExpressionProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionButton;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DummyEngineTask;
import org.eclipse.birt.report.designer.internal.ui.data.DataService;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.FilterConditionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ChartCubeFilterConditionBuilder
extends BaseTitleAreaDialog {
    protected static final Logger logger = Logger.getLogger(FilterConditionBuilder.class.getName());
    protected ChartWizardContext context = null;
    private static String CHOICE_SELECT_VALUE = Messages.getString((String)"ExpressionValueCellEditor.selectValueAction");
    protected final String NULL_STRING;
    protected Composite dummy1;
    protected Composite dummy2;
    protected Label label1;
    protected Label label2;
    protected List<String> valueList = new ArrayList<String>();
    protected List selValueList = new ArrayList();
    protected static final String[][] OPERATOR;
    private ParamBindingHandle[] bindingParams = null;
    protected ReportElementHandle currentItem = null;
    protected static final String[] EMPTY_ARRAY;
    protected List<String> columnList;
    protected List<String> measureList = new ArrayList<String>();
    protected int valueVisible;
    protected Table table;
    protected TableViewer tableViewer;
    protected static final String[] EMPTY;
    private Map<String, String> fExprMap = new LinkedHashMap<String, String>();
    protected String title;
    protected String message;
    protected IChoiceSet choiceSet;
    protected IExpressionButton expButton;
    protected DataRequestSession session = null;
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
    protected FilterConditionElementHandle inputHandle;
    protected Combo expression;
    protected Combo operator;
    protected Button addBtn;
    protected Button editBtn;
    protected Button delBtn;
    protected Button delAllBtn;
    protected CCombo expressionValue1;
    protected CCombo expressionValue2;
    protected CCombo addExpressionValue;
    protected Composite valueListComposite;
    protected Label andLable;
    protected DesignElementHandle designHandle;
    protected static final String VALUE_OF_THIS_DATA_ITEM;
    private String fCurrentExpr = "";
    protected Listener expValueVerifyListener = new Listener(){

        public void handleEvent(Event event) {
            CCombo thisCombo = (CCombo)event.widget;
            String text = event.text;
            event.doit = text == null || thisCombo.indexOf(text) < 0;
        }
    };
    private Listener expValueSelectionListener = new Listener(){

        public void handleEvent(Event event) {
            String express;
            CCombo thisCombo = (CCombo)event.widget;
            int selectionIndex = thisCombo.getSelectionIndex();
            if (selectionIndex < 0) {
                return;
            }
            String value = thisCombo.getItem(selectionIndex);
            boolean isAddClick = false;
            if (ChartCubeFilterConditionBuilder.this.tableViewer != null && ChartCubeFilterConditionBuilder.this.addBtn != null && !ChartCubeFilterConditionBuilder.this.addBtn.isDisposed()) {
                isAddClick = true;
            }
            if ((express = ChartCubeFilterConditionBuilder.this.expButton.getExpression()) != null) {
                express = express.trim();
            }
            ChartCubeFilterConditionBuilder.this.exprCodec.decode(express);
            String bindingName = ChartCubeFilterConditionBuilder.this.exprCodec.getBindingName();
            boolean returnValue = false;
            if (value != null) {
                String[] newValues = new String[1];
                if (CHOICE_SELECT_VALUE.equals(value)) {
                    if (bindingName != null) {
                        if (ChartCubeFilterConditionBuilder.this.designHandle instanceof ReportItemHandle && ((ReportItemHandle)ChartCubeFilterConditionBuilder.this.designHandle).getCube() != null) {
                            List selectValueList = ChartCubeFilterConditionBuilder.this.getSelectValueList();
                            if (selectValueList == null || selectValueList.size() == 0) {
                                MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)org.eclipse.birt.chart.reportitem.ui.i18n.Messages.getString("ChartCubeFilterConditionBuilder.SelectValueDialog.messages.info.selectVauleUnavailable")));
                            } else {
                                SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                                if (isAddClick) {
                                    dialog.setMultipleSelection(true);
                                }
                                dialog.setSelectedValueList((Collection)selectValueList);
                                if (ChartCubeFilterConditionBuilder.this.bindingParams != null) {
                                    dialog.setBindingParams(ChartCubeFilterConditionBuilder.this.bindingParams);
                                }
                                if (dialog.open() == 0) {
                                    returnValue = true;
                                    newValues = dialog.getSelectedExprValues();
                                }
                            }
                        } else {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)org.eclipse.birt.chart.reportitem.ui.i18n.Messages.getString("ChartCubeFilterConditionBuilder.SelectValueDialog.messages.info.selectVauleUnavailable")));
                        }
                    } else {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)org.eclipse.birt.chart.reportitem.ui.i18n.Messages.getString("ChartCubeFilterConditionBuilder.SelectValueDialog.messages.info.illegalVauleExpr"));
                    }
                }
                if (returnValue) {
                    if (ChartCubeFilterConditionBuilder.this.addExpressionValue == thisCombo) {
                        thisCombo.setText("");
                        ChartCubeFilterConditionBuilder.this.addBtn.setEnabled(false);
                    } else if (newValues.length == 1) {
                        thisCombo.setText(DEUtil.resolveNull((String)newValues[0]));
                    }
                    if (isAddClick) {
                        boolean change = false;
                        int i = 0;
                        while (i < newValues.length) {
                            if (ChartCubeFilterConditionBuilder.this.valueList.indexOf(DEUtil.resolveNull((String)newValues[i])) < 0) {
                                ChartCubeFilterConditionBuilder.this.valueList.add(DEUtil.resolveNull((String)newValues[i]));
                                change = true;
                            }
                            ++i;
                        }
                        if (change) {
                            ChartCubeFilterConditionBuilder.this.tableViewer.refresh();
                            ChartCubeFilterConditionBuilder.this.updateButtons();
                            ChartCubeFilterConditionBuilder.this.addExpressionValue.setFocus();
                        }
                    }
                }
            }
        }
    };
    protected ITableLabelProvider tableLableProvier = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return (String)element;
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    protected IStructuredContentProvider tableContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }
    };
    protected SelectionListener operatorSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            String value = ChartCubeFilterConditionBuilder.getValueForOperator(ChartCubeFilterConditionBuilder.this.operator.getText());
            ChartCubeFilterConditionBuilder.this.valueVisible = ChartCubeFilterConditionBuilder.determineValueVisible(value);
            if (ChartCubeFilterConditionBuilder.this.valueVisible == 3) {
                int ret = ChartCubeFilterConditionBuilder.this.createValueListComposite(ChartCubeFilterConditionBuilder.this.operator.getParent());
                if (ret != 0) {
                    if (ChartCubeFilterConditionBuilder.this.inputHandle != null) {
                        ChartCubeFilterConditionBuilder.this.valueList = new ArrayList<String>(ChartCubeFilterConditionBuilder.this.inputHandle.getValue1List());
                    }
                    ChartCubeFilterConditionBuilder.this.tableViewer.setInput(ChartCubeFilterConditionBuilder.this.valueList);
                }
            } else {
                int ret = ChartCubeFilterConditionBuilder.this.create2ValueComposite(ChartCubeFilterConditionBuilder.this.operator.getParent());
                if (ret != 0 && ChartCubeFilterConditionBuilder.this.inputHandle != null) {
                    ChartCubeFilterConditionBuilder.this.expressionValue1.setText(DEUtil.resolveNull((String)ChartCubeFilterConditionBuilder.this.inputHandle.getValue1()));
                    ChartCubeFilterConditionBuilder.this.expressionValue2.setText(DEUtil.resolveNull((String)ChartCubeFilterConditionBuilder.this.inputHandle.getValue2()));
                }
            }
            if (ChartCubeFilterConditionBuilder.this.valueVisible == 0) {
                ChartCubeFilterConditionBuilder.this.expressionValue1.setVisible(false);
                ExpressionButtonUtil.getExpressionButton((Control)ChartCubeFilterConditionBuilder.this.expressionValue1).getControl().setVisible(false);
                ChartCubeFilterConditionBuilder.this.expressionValue2.setVisible(false);
                ExpressionButtonUtil.getExpressionButton((Control)ChartCubeFilterConditionBuilder.this.expressionValue2).getControl().setVisible(false);
                ChartCubeFilterConditionBuilder.this.andLable.setVisible(false);
            } else if (ChartCubeFilterConditionBuilder.this.valueVisible == 1) {
                ChartCubeFilterConditionBuilder.this.expressionValue1.setVisible(true);
                ExpressionButtonUtil.getExpressionButton((Control)ChartCubeFilterConditionBuilder.this.expressionValue1).getControl().setVisible(true);
                ChartCubeFilterConditionBuilder.this.expressionValue2.setVisible(false);
                ExpressionButtonUtil.getExpressionButton((Control)ChartCubeFilterConditionBuilder.this.expressionValue2).getControl().setVisible(false);
                ChartCubeFilterConditionBuilder.this.andLable.setVisible(false);
            } else if (ChartCubeFilterConditionBuilder.this.valueVisible == 2) {
                ChartCubeFilterConditionBuilder.this.expressionValue1.setVisible(true);
                ExpressionButtonUtil.getExpressionButton((Control)ChartCubeFilterConditionBuilder.this.expressionValue1).getControl().setVisible(true);
                ChartCubeFilterConditionBuilder.this.expressionValue2.setVisible(true);
                ExpressionButtonUtil.getExpressionButton((Control)ChartCubeFilterConditionBuilder.this.expressionValue2).getControl().setVisible(true);
                ChartCubeFilterConditionBuilder.this.andLable.setVisible(true);
                ChartCubeFilterConditionBuilder.this.andLable.setEnabled(true);
            }
            ChartCubeFilterConditionBuilder.this.updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    protected Listener comboModifyListener = new Listener(){

        public void handleEvent(Event e) {
            Assert.isLegal((boolean)(e.widget instanceof Combo));
            Combo combo = (Combo)e.widget;
            String newValue = combo.getText();
            String value = DEUtil.getExpression((Object)ChartCubeFilterConditionBuilder.this.getResultSetColumn(newValue));
            if (value != null) {
                newValue = value;
            }
            combo.setText(newValue);
            ChartCubeFilterConditionBuilder.this.updateButtons();
        }
    };
    protected IExpressionProvider expressionProvider;
    private transient boolean needRefreshList = true;

    static {
        EMPTY_ARRAY = new String[0];
        EMPTY = new String[0];
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet((String)"FilterCondition", (String)"operator");
        IChoice[] chs = chset.getChoices((Comparator)new AlphabeticallyComparator());
        OPERATOR = new String[chs.length][2];
        int i = 0;
        while (i < chs.length) {
            ChartCubeFilterConditionBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            ChartCubeFilterConditionBuilder.OPERATOR[i][1] = chs[i].getName();
            ++i;
        }
        VALUE_OF_THIS_DATA_ITEM = Messages.getString((String)"FilterConditionBuilder.choice.ValueOfThisDataItem");
    }

    public ChartCubeFilterConditionBuilder(String title, String message) {
        this(UIUtil.getDefaultShell(), title, message);
    }

    public ChartCubeFilterConditionBuilder(Shell parentShell, String title, String message) {
        super(parentShell);
        this.NULL_STRING = null;
        this.title = title;
        this.message = message;
    }

    private void setContext(ChartWizardContext context) {
        this.context = context;
    }

    protected synchronized DataRequestSession getDteSession() {
        if (this.session == null) {
            try {
                this.session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            }
            catch (BirtException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.session;
    }

    protected synchronized void shutDownDteSession() {
        if (this.session != null) {
            this.session.shutdown();
        }
    }

    protected void setColumnList(DesignElementHandle handle) {
        if (handle instanceof ExtendedItemHandle) {
            try {
                this.fExprMap = this.getValidFilterExpressions((ExtendedItemHandle)handle);
                this.columnList = new ArrayList<String>(this.fExprMap.keySet());
                return;
            }
            catch (ExtendedElementException e) {
                e.printStackTrace();
            }
        }
        this.columnList = new ArrayList<String>();
    }

    protected String adaptExpr(ChartExpressionUtil.ExpressionCodec exprCodec) {
        Expression expr = new Expression((Object)exprCodec.getExpression(), exprCodec.getType());
        IModelAdapter adapter = this.getDteSession().getModelAdaptor();
        return adapter.adaptExpression(expr, IModelAdapter.ExpressionLocation.CUBE).getText();
    }

    protected Map<String, String> getValidFilterExpressions(ExtendedItemHandle handle) throws ExtendedElementException {
        String expr;
        LinkedHashMap<String, String> exprMap = new LinkedHashMap<String, String>();
        this.measureList = new ArrayList<String>();
        for (LevelHandle lh : ChartCubeUtil.getAllLevels((CubeHandle)handle.getCube())) {
            this.exprCodec.setBindingName(ChartCubeUtil.createLevelBindingName((LevelHandle)lh), true);
            expr = this.adaptExpr(this.exprCodec);
            exprMap.put(this.exprCodec.getBindingName(), expr);
        }
        for (MeasureHandle mh : ChartCubeUtil.getAllMeasures((CubeHandle)handle.getCube())) {
            this.exprCodec.setBindingName(ChartCubeUtil.createMeasureBindingName((MeasureHandle)mh), true);
            expr = this.adaptExpr(this.exprCodec);
            exprMap.put(this.exprCodec.getBindingName(), expr);
            this.measureList.add(this.exprCodec.getBindingName());
        }
        return exprMap;
    }

    protected String[] getDataSetColumns() {
        if (this.columnList.isEmpty()) {
            return EMPTY;
        }
        String[] values = new String[this.columnList.size()];
        int i = 0;
        while (i < this.columnList.size()) {
            values[i] = this.columnList.get(i);
            ++i;
        }
        return values;
    }

    protected Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.columnList.size()) {
            if (this.columnList.get(i).equals(name)) {
                return this.columnList.get(i);
            }
            ++i;
        }
        return null;
    }

    protected String getColumnName(Object obj) {
        return (String)obj;
    }

    protected void okPressed() {
        try {
            if (this.inputHandle == null) {
                FilterConditionElementHandle filter = DesignElementFactory.getInstance((ModuleHandle)this.currentItem.getModuleHandle()).newFilterConditionElement();
                filter.setProperty("operator", (Object)DEUtil.resolveNull((String)ChartCubeFilterConditionBuilder.getValueForOperator(this.operator.getText())));
                Expression expression = new Expression((Object)this.expButton.getDisplayExpression(), this.expButton.getExpressionType());
                filter.setExpressionProperty("expr", expression);
                if (this.valueVisible == 3) {
                    filter.setValue1(this.valueList);
                    filter.setValue2("");
                } else {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        ArrayList<Expression> valueList = new ArrayList<Expression>();
                        valueList.add(ExpressionButtonUtil.getExpression((Control)this.expressionValue1));
                        filter.setValue1(valueList);
                    } else {
                        filter.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionValue2, (Object)filter, (String)"value2");
                    } else {
                        filter.setValue2(this.NULL_STRING);
                    }
                }
                PropertyHandle propertyHandle = this.designHandle.getPropertyHandle("cubeFilter");
                propertyHandle.add((DesignElementHandle)filter);
            } else {
                this.inputHandle.setOperator(DEUtil.resolveNull((String)ChartCubeFilterConditionBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible == 3) {
                    this.inputHandle.setValue1(this.valueList);
                    this.inputHandle.setValue2(this.NULL_STRING);
                } else {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        ArrayList<Expression> valueList = new ArrayList<Expression>();
                        valueList.add(ExpressionButtonUtil.getExpression((Control)this.expressionValue1));
                        this.inputHandle.setValue1(valueList);
                    } else {
                        this.inputHandle.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionValue2, (Object)this.inputHandle, (String)"value2");
                    } else {
                        this.inputHandle.setValue2(this.NULL_STRING);
                    }
                }
                Expression expression = new Expression((Object)this.expButton.getDisplayExpression(), this.expButton.getExpressionType());
                this.inputHandle.setExpressionProperty("expr", expression);
            }
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
        super.okPressed();
    }

    public void setReportElement(ReportElementHandle reportItem) {
        this.currentItem = reportItem;
    }

    public void setBindingParams(ParamBindingHandle[] params) {
        this.bindingParams = params;
    }

    public static String getValueForOperator(String name) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][0].equals(name)) {
                return OPERATOR[i][1];
            }
            ++i;
        }
        return null;
    }

    public static int determineValueVisible(String operatorValue) {
        if ("any".equals(operatorValue) || "is-false".equals(operatorValue) || "is-true".equals(operatorValue) || "is-null".equals(operatorValue) || "is-not-null".equals(operatorValue)) {
            return 0;
        }
        if ("lt".equals(operatorValue) || "le".equals(operatorValue) || "eq".equals(operatorValue) || "ne".equals(operatorValue) || "ge".equals(operatorValue) || "gt".equals(operatorValue) || "like".equals(operatorValue)) {
            return 1;
        }
        if ("between".equals(operatorValue) || "not-between".equals(operatorValue)) {
            return 2;
        }
        if ("in".equals(operatorValue) || "not-in".equals(operatorValue)) {
            return 3;
        }
        return 1;
    }

    public static String getNameForOperator(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return OPERATOR[i][0];
            }
            ++i;
        }
        return "";
    }

    protected static int getIndexForOperatorValue(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.AddEditFilterCondition_ID");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setLayout((Layout)new GridLayout());
        this.setTitle(this.title);
        this.setMessage(this.message);
        this.getShell().setText(this.title);
        ChartCubeFilterConditionBuilder.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        this.createFilterConditionContent(contents);
        return area;
    }

    protected void createFilterConditionContent(Composite innerParent) {
        Composite anotherParent = new Composite(innerParent, 0);
        GridData gd = new GridData(768);
        anotherParent.setLayoutData((Object)gd);
        GridLayout glayout = new GridLayout(4, false);
        anotherParent.setLayout((Layout)glayout);
        Label lb = new Label(anotherParent, 0);
        lb.setText(Messages.getString((String)"FilterConditionBuilder.text.Condition"));
        Label lb2 = new Label(anotherParent, 0);
        lb2.setLayoutData((Object)new GridData(768));
        new Label(anotherParent, 0);
        Composite condition = new Composite(innerParent, 0);
        gd = new GridData(1808);
        gd.heightHint = 180;
        condition.setLayoutData((Object)gd);
        glayout = new GridLayout(5, false);
        condition.setLayout((Layout)glayout);
        this.expression = new Combo(condition, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 100;
        this.expression.setLayoutData((Object)gdata);
        this.expression.addListener(13, this.comboModifyListener);
        if (this.expression.getItemCount() == 0) {
            this.expression.add(DEUtil.resolveNull(null));
        }
        this.expression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ChartCubeFilterConditionBuilder.this.expression.getText().equals(VALUE_OF_THIS_DATA_ITEM) && ChartCubeFilterConditionBuilder.this.designHandle instanceof DataItemHandle) {
                    ChartCubeFilterConditionBuilder.this.expression.setText(DEUtil.getColumnExpression((String)((DataItemHandle)ChartCubeFilterConditionBuilder.this.designHandle).getResultSetColumn()));
                }
                ChartCubeFilterConditionBuilder.this.updateButtons();
            }
        });
        ChartExpressionProvider ep = new ChartExpressionProvider(this.designHandle, this.context, ChartReportItemUIUtil.getExpressionBuilderStyle(1));
        this.expressionProvider = ep;
        this.expButton = ChartExpressionButtonUtil.createExpressionButton(condition, (Control)this.expression, (ExtendedItemHandle)this.designHandle, (IExpressionProvider)ep);
        this.expButton.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (event.data instanceof String[]) {
                    ChartCubeFilterConditionBuilder.this.updateButtons();
                    if (!ChartCubeFilterConditionBuilder.this.expButton.getExpression().equals(ChartCubeFilterConditionBuilder.this.fCurrentExpr)) {
                        ChartCubeFilterConditionBuilder.this.needRefreshList = true;
                        ChartCubeFilterConditionBuilder.this.fCurrentExpr = ChartCubeFilterConditionBuilder.this.expButton.getExpression();
                    }
                }
            }
        });
        this.expButton.setPredefinedQuery((Object[])this.getDataSetColumns());
        this.operator = new Combo(condition, 8);
        int i = 0;
        while (i < OPERATOR.length) {
            this.operator.add(OPERATOR[i][0]);
            ++i;
        }
        this.operator.setVisibleItemCount(30);
        this.operator.addSelectionListener(this.operatorSelectionListener);
        if (this.operator.getItemCount() > 0 && this.operator.getSelectionIndex() == -1) {
            this.operator.select(ChartCubeFilterConditionBuilder.getIndexForOperatorValue("eq"));
        }
        this.create2ValueComposite(condition);
        if (this.inputHandle != null) {
            this.syncViewProperties();
        }
        lb = new Label(innerParent, 258);
        lb.setLayoutData((Object)new GridData(768));
    }

    private int create2ValueComposite(Composite condition) {
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            return 0;
        }
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            this.valueListComposite.dispose();
            this.valueListComposite = null;
        }
        GridData expgd = new GridData();
        expgd.widthHint = 100;
        this.expressionValue1 = this.createExpressionValue(condition);
        this.expressionValue1.setLayoutData((Object)expgd);
        this.dummy1 = this.createDummy(condition, 3);
        this.andLable = new Label(condition, 0);
        this.andLable.setText(Messages.getString((String)"FilterConditionBuilder.text.AND"));
        this.andLable.setEnabled(false);
        this.andLable.setVisible(false);
        this.dummy2 = this.createDummy(condition, 3);
        this.expressionValue2 = this.createExpressionValue(condition);
        this.expressionValue2.setLayoutData((Object)expgd);
        this.expressionValue2.setVisible(false);
        ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
        condition.getParent().layout(true, true);
        return 1;
    }

    private CCombo createExpressionValue(Composite parent) {
        final CCombo expressionValue = new CCombo(parent, 2048);
        expressionValue.add(CHOICE_SELECT_VALUE);
        expressionValue.addListener(25, this.expValueVerifyListener);
        expressionValue.addListener(13, this.expValueSelectionListener);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ChartCubeFilterConditionBuilder.this.updateButtons();
            }
        };
        expressionValue.addListener(24, listener);
        expressionValue.addListener(3, new Listener(){

            public void handleEvent(Event arg0) {
                if (ChartCubeFilterConditionBuilder.this.isMeasureSelected()) {
                    if (expressionValue.getItemCount() > 0) {
                        expressionValue.remove(0);
                    }
                    expressionValue.setVisibleItemCount(0);
                } else {
                    if (expressionValue.getItemCount() == 0) {
                        expressionValue.add(CHOICE_SELECT_VALUE);
                    }
                    expressionValue.setVisibleItemCount(1);
                }
            }
        });
        IExpressionButton ceb = ChartExpressionButtonUtil.createExpressionButton(parent, (Control)expressionValue, (ExtendedItemHandle)this.designHandle, this.expressionProvider);
        ceb.addListener(listener);
        return expressionValue;
    }

    private int createValueListComposite(Composite parent) {
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            return 0;
        }
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().dispose();
            this.expressionValue1.dispose();
            this.expressionValue1 = null;
            this.dummy1.dispose();
            this.dummy1 = null;
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().dispose();
            this.expressionValue2.dispose();
            this.expressionValue2 = null;
            this.dummy2.dispose();
            this.dummy2 = null;
            this.andLable.dispose();
            this.andLable = null;
        }
        this.valueListComposite = new Composite(parent, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 4;
        this.valueListComposite.setLayoutData((Object)gdata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.valueListComposite.setLayout((Layout)layout);
        Group group = new Group(this.valueListComposite, 0);
        GridData data = new GridData(768);
        data.heightHint = 118;
        data.horizontalSpan = 3;
        data.horizontalIndent = 0;
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 5;
        group.setLayout((Layout)layout);
        new Label((Composite)group, 0).setText(Messages.getString((String)"FilterConditionBuilder.label.value"));
        GridData expgd = new GridData();
        expgd.widthHint = 100;
        this.addExpressionValue = this.createExpressionValue((Composite)group);
        this.addExpressionValue.setLayoutData((Object)expgd);
        this.addBtn = new Button((Composite)group, 8);
        this.addBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.add"));
        this.addBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.add.tooltip"));
        this.setButtonLayoutData(this.addBtn);
        this.addBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String value = ChartCubeFilterConditionBuilder.this.addExpressionValue.getText().trim();
                if (ChartCubeFilterConditionBuilder.this.valueList.indexOf(value) < 0) {
                    ChartCubeFilterConditionBuilder.this.valueList.add(value);
                    ChartCubeFilterConditionBuilder.this.tableViewer.refresh();
                    ChartCubeFilterConditionBuilder.this.updateButtons();
                    ChartCubeFilterConditionBuilder.this.addExpressionValue.setFocus();
                    ChartCubeFilterConditionBuilder.this.addExpressionValue.setText("");
                } else {
                    ChartCubeFilterConditionBuilder.this.addBtn.setEnabled(false);
                }
            }
        });
        new Label((Composite)group, 0);
        int tableStyle = 68356;
        this.table = new Table((Composite)group, tableStyle);
        data = new GridData(1040);
        data.horizontalSpan = 4;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        String[] columNames = new String[]{Messages.getString((String)"FilterConditionBuilder.list.item1")};
        int[] columLength = new int[]{288};
        int i = 0;
        while (i < columNames.length) {
            TableColumn column = new TableColumn(this.table, 0, i);
            column.setText(columNames[i]);
            column.setWidth(columLength[i]);
            ++i;
        }
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ChartCubeFilterConditionBuilder.this.checkEditDelButtonStatus();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    int index = ChartCubeFilterConditionBuilder.this.table.getSelectionIndex();
                    if (index > -1) {
                        ChartCubeFilterConditionBuilder.this.valueList.remove(index);
                        ChartCubeFilterConditionBuilder.this.tableViewer.refresh();
                        if (ChartCubeFilterConditionBuilder.this.valueList.size() > 0) {
                            if (ChartCubeFilterConditionBuilder.this.valueList.size() <= index) {
                                --index;
                            }
                            ChartCubeFilterConditionBuilder.this.table.select(index);
                        }
                        ChartCubeFilterConditionBuilder.this.updateButtons();
                    } else {
                        ChartCubeFilterConditionBuilder.this.delBtn.setEnabled(false);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChartCubeFilterConditionBuilder.this.tableViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof String) {
                    String initValue = (String)selection.getFirstElement();
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(ChartCubeFilterConditionBuilder.this.getShell(), initValue);
                    if (ChartCubeFilterConditionBuilder.this.designHandle != null) {
                        if (ChartCubeFilterConditionBuilder.this.expressionProvider == null) {
                            expressionBuilder.setExpressionProvider((IExpressionProvider)new ExpressionProvider(ChartCubeFilterConditionBuilder.this.designHandle));
                        } else {
                            expressionBuilder.setExpressionProvider(ChartCubeFilterConditionBuilder.this.expressionProvider);
                        }
                    }
                    if (expressionBuilder.open() == 0) {
                        String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
                        int index = ChartCubeFilterConditionBuilder.this.table.getSelectionIndex();
                        ChartCubeFilterConditionBuilder.this.valueList.remove(index);
                        ChartCubeFilterConditionBuilder.this.valueList.add(index, result);
                        ChartCubeFilterConditionBuilder.this.tableViewer.refresh();
                        ChartCubeFilterConditionBuilder.this.table.select(index);
                    }
                    ChartCubeFilterConditionBuilder.this.updateButtons();
                } else {
                    ChartCubeFilterConditionBuilder.this.editBtn.setEnabled(false);
                }
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columNames);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLableProvier);
        this.tableViewer.setContentProvider((IContentProvider)this.tableContentProvider);
        Composite rightPart = new Composite(this.valueListComposite, 0);
        data = new GridData(1816);
        rightPart.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        rightPart.setLayout((Layout)layout);
        this.editBtn = new Button(rightPart, 8);
        this.editBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.edit"));
        this.editBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.edit.tooltip"));
        this.setButtonLayoutData(this.editBtn);
        this.editBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChartCubeFilterConditionBuilder.this.tableViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof String) {
                    String initValue = (String)selection.getFirstElement();
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(ChartCubeFilterConditionBuilder.this.getShell(), initValue);
                    if (ChartCubeFilterConditionBuilder.this.designHandle != null) {
                        if (ChartCubeFilterConditionBuilder.this.expressionProvider == null) {
                            expressionBuilder.setExpressionProvier((IExpressionProvider)new ExpressionProvider(ChartCubeFilterConditionBuilder.this.designHandle));
                        } else {
                            expressionBuilder.setExpressionProvier(ChartCubeFilterConditionBuilder.this.expressionProvider);
                        }
                    }
                    if (expressionBuilder.open() == 0) {
                        String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
                        int index = ChartCubeFilterConditionBuilder.this.table.getSelectionIndex();
                        ChartCubeFilterConditionBuilder.this.valueList.remove(index);
                        ChartCubeFilterConditionBuilder.this.valueList.add(index, result);
                        ChartCubeFilterConditionBuilder.this.tableViewer.refresh();
                        ChartCubeFilterConditionBuilder.this.table.select(index);
                    }
                    ChartCubeFilterConditionBuilder.this.updateButtons();
                } else {
                    ChartCubeFilterConditionBuilder.this.editBtn.setEnabled(false);
                }
            }
        });
        this.delBtn = new Button(rightPart, 8);
        this.delBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.delete"));
        this.delBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.delete.tooltip"));
        this.setButtonLayoutData(this.delBtn);
        this.delBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = ChartCubeFilterConditionBuilder.this.table.getSelectionIndex();
                if (index > -1) {
                    ChartCubeFilterConditionBuilder.this.valueList.remove(index);
                    ChartCubeFilterConditionBuilder.this.tableViewer.refresh();
                    if (ChartCubeFilterConditionBuilder.this.valueList.size() > 0) {
                        if (ChartCubeFilterConditionBuilder.this.valueList.size() <= index) {
                            --index;
                        }
                        ChartCubeFilterConditionBuilder.this.table.select(index);
                    }
                    ChartCubeFilterConditionBuilder.this.updateButtons();
                } else {
                    ChartCubeFilterConditionBuilder.this.delBtn.setEnabled(false);
                }
            }
        });
        this.delAllBtn = new Button(rightPart, 8);
        this.delAllBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.deleteall"));
        this.delAllBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.deleteall.tooltip"));
        this.setButtonLayoutData(this.delAllBtn);
        this.delAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int count = ChartCubeFilterConditionBuilder.this.valueList.size();
                if (count > 0) {
                    ChartCubeFilterConditionBuilder.this.valueList.clear();
                    ChartCubeFilterConditionBuilder.this.tableViewer.refresh();
                    ChartCubeFilterConditionBuilder.this.updateButtons();
                } else {
                    ChartCubeFilterConditionBuilder.this.delAllBtn.setEnabled(false);
                }
            }
        });
        this.addExpressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChartCubeFilterConditionBuilder.this.checkAddButtonStatus();
                ChartCubeFilterConditionBuilder.this.updateButtons();
            }
        });
        parent.getParent().layout(true, true);
        return 1;
    }

    protected Composite createDummy(Composite parent, int colSpan) {
        Composite dummy = new Composite(parent, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.horizontalSpan = colSpan;
        gdata.heightHint = 10;
        dummy.setLayoutData((Object)gdata);
        return dummy;
    }

    public void updateHandle(FilterConditionElementHandle handle, int handleCount) {
        this.inputHandle = handle;
    }

    private void setDesignHandle(DesignElementHandle handle) {
        this.designHandle = handle;
        this.setColumnList(this.designHandle);
    }

    public void setDesignHandle(DesignElementHandle handle, ChartWizardContext context) {
        this.setContext(context);
        this.setDesignHandle(handle);
    }

    public void setDesignHandle(DesignElementHandle handle, IExpressionProvider provider) {
        this.setDesignHandle(handle);
        this.expressionProvider = provider;
        this.setColumnList(this.designHandle);
    }

    public FilterConditionElementHandle getInputHandle() {
        return this.inputHandle;
    }

    protected void updateButtons() {
        this.enableInput(this.isExpressionOK());
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.isConditionOK());
        }
    }

    protected void enableInput(boolean val) {
        this.operator.setEnabled(val);
        if (this.valueVisible != 3) {
            if (this.expressionValue1 != null) {
                this.expressionValue1.setEnabled(val);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setEnabled(val);
            }
            if (this.expressionValue2 != null) {
                this.expressionValue2.setEnabled(val);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setEnabled(val);
            }
            if (this.andLable != null) {
                this.andLable.setEnabled(val);
            }
        } else {
            this.setControlEnable((Control)this.valueListComposite, val);
            if (val) {
                this.checkAddButtonStatus();
                this.checkEditDelButtonStatus();
            }
        }
    }

    protected void setControlEnable(Control control, boolean bool) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(bool);
        Composite tmp = null;
        if (control instanceof Composite) {
            tmp = (Composite)control;
        }
        if (tmp != null && tmp.getChildren() != null) {
            int i = 0;
            while (i < tmp.getChildren().length) {
                this.setControlEnable(tmp.getChildren()[i], bool);
                ++i;
            }
        }
    }

    protected boolean isExpressionOK() {
        if (this.expression == null) {
            return false;
        }
        return this.expression.getText() != null && this.expression.getText().length() != 0;
    }

    protected boolean isConditionOK() {
        if (this.expression == null) {
            return false;
        }
        if (!this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    protected boolean checkValues() {
        if (this.valueVisible == 3) {
            return this.valueList.size() > 0;
        }
        if (this.expressionValue1 != null && this.expressionValue2 != null) {
            assert (!this.expressionValue1.isDisposed());
            assert (!this.expressionValue2.isDisposed());
            if (this.expressionValue1.getVisible() && (this.expressionValue1.getText() == null || this.expressionValue1.getText().trim().length() == 0)) {
                return false;
            }
            if (this.expressionValue2.getVisible() && (this.expressionValue2.getText() == null || this.expressionValue2.getText().trim().length() == 0)) {
                return false;
            }
        }
        return true;
    }

    protected void checkAddButtonStatus() {
        if (this.addExpressionValue != null && !this.addExpressionValue.isDisposed()) {
            String value = this.addExpressionValue.getText();
            if (value == null || value.length() == 0 || value.trim().length() == 0) {
                this.addBtn.setEnabled(false);
                return;
            }
            if (value != null) {
                value = value.trim();
            }
            if (this.valueList.indexOf(value) < 0) {
                this.addBtn.setEnabled(true);
            } else {
                this.addBtn.setEnabled(false);
            }
        }
    }

    protected void checkEditDelButtonStatus() {
        StructuredSelection selection;
        boolean enabled;
        if (this.tableViewer == null || this.table.isDisposed()) {
            return;
        }
        boolean bl = enabled = this.tableViewer.getSelection() != null;
        if (enabled && this.tableViewer.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)this.tableViewer.getSelection()).toList().size() <= 0) {
            enabled = false;
        }
        this.editBtn.setEnabled(enabled);
        this.delBtn.setEnabled(enabled);
        enabled = this.table.getItemCount() > 0;
        this.delAllBtn.setEnabled(enabled);
    }

    protected void syncViewProperties() {
        ChartItemUtil.loadExpression((ChartExpressionUtil.ExpressionCodec)this.exprCodec, (FilterConditionElementHandle)this.inputHandle);
        this.expButton.setExpression(this.exprCodec.encode());
        this.operator.select(ChartCubeFilterConditionBuilder.getIndexForOperatorValue(this.inputHandle.getOperator()));
        this.valueVisible = ChartCubeFilterConditionBuilder.determineValueVisible(this.inputHandle.getOperator());
        if (this.valueVisible == 3) {
            this.createValueListComposite(this.operator.getParent());
            this.valueList = new ArrayList<String>(this.inputHandle.getValue1List());
            this.tableViewer.setInput(this.valueList);
        } else {
            this.create2ValueComposite(this.operator.getParent());
            if (this.inputHandle != null) {
                if (this.inputHandle.getValue1ExpressionList().getListValue() != null && this.inputHandle.getValue1ExpressionList().getListValue().size() > 0) {
                    ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue1, (Expression)((Expression)this.inputHandle.getValue1ExpressionList().getListValue().get(0)));
                }
                ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue2, (Object)this.inputHandle, (String)"value2");
            }
        }
        if (this.valueVisible == 0) {
            this.expressionValue1.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(false);
            this.expressionValue2.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 1) {
            this.expressionValue1.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
            this.expressionValue2.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 2) {
            this.expressionValue1.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
            this.expressionValue2.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(true);
            this.andLable.setVisible(true);
            this.andLable.setEnabled(true);
        } else if (this.valueVisible == 3) {
            if (this.expression.getText().length() == 0) {
                this.valueListComposite.setEnabled(false);
            } else {
                this.valueListComposite.setEnabled(true);
            }
        }
    }

    protected void editValue(Control control) {
        String initValue = null;
        if (control instanceof Text) {
            initValue = ((Text)control).getText();
        } else if (control instanceof Combo) {
            initValue = ((Combo)control).getText();
        } else if (control instanceof CCombo) {
            initValue = ((CCombo)control).getText();
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
        if (this.designHandle != null) {
            if (this.expressionProvider == null) {
                ChartCubeFilterExpressionProvider exprProvider = new ChartCubeFilterExpressionProvider(this.designHandle, this.fExprMap.values().toArray(new String[0]));
                expressionBuilder.setExpressionProvider((IExpressionProvider)exprProvider);
            } else {
                expressionBuilder.setExpressionProvider(this.expressionProvider);
            }
        }
        if (expressionBuilder.open() == 0) {
            String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
            if (control instanceof Text) {
                ((Text)control).setText(result);
            } else if (control instanceof Combo) {
                ((Combo)control).setText(result);
            } else if (control instanceof CCombo) {
                ((CCombo)control).setText(result);
            }
        }
        this.updateButtons();
    }

    public void setInput(Object inputHandle) {
        this.inputHandle = inputHandle instanceof FilterConditionElementHandle ? (FilterConditionElementHandle)inputHandle : null;
    }

    private List getSelectValueList() {
        if (!this.needRefreshList) {
            return this.selValueList;
        }
        CubeHandle cube = null;
        if (this.designHandle instanceof ExtendedItemHandle) {
            cube = ((ExtendedItemHandle)this.designHandle).getCube();
        }
        if (cube == null || this.expression.getText().length() == 0) {
            return new ArrayList();
        }
        Iterator iter = null;
        IBaseCubeQueryDefinition cubeQueryDefn = null;
        try {
            ModuleHandle moduleHandle = this.designHandle.getModuleHandle();
            EngineConfig config = new EngineConfig();
            config.setProperty("PARENT_CLASSLOADER", (Object)DataSetProvider.getCustomScriptClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader(), (ModuleHandle)moduleHandle));
            ReportEngine engine = (ReportEngine)new ReportEngineFactory().createReportEngine(config);
            DummyEngineTask engineTask = new DummyEngineTask(engine, ChartItemUtil.openReportDesign((ReportEngine)engine, (ModuleHandle)moduleHandle), moduleHandle);
            this.session = engineTask.getDataSession();
            engineTask.run();
            DataService.getInstance().registerSession(cube, this.session);
            IReportItem item = ((ExtendedItemHandle)this.designHandle).getReportItem();
            Chart cm = this.getChartModel(item);
            ChartCubeQueryHelper ccqh = new ChartCubeQueryHelper((ExtendedItemHandle)this.designHandle, cm, this.session.getModelAdaptor());
            String expr = this.expButton.getExpression();
            cubeQueryDefn = expr != null && expr.equals(this.expButton.getExpression()) ? ccqh.createCubeQuery(null, new String[]{expr}) : ccqh.createCubeQuery(null);
            String bindingName = this.exprCodec.getBindingName(expr);
            this.exprCodec.setBindingName(bindingName, true, "javascript");
            iter = this.session.getCubeQueryUtil().getMemberValueIterator(cube, this.exprCodec.getExpression(), (ICubeQueryDefinition)cubeQueryDefn);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.selValueList = new ArrayList();
        while (iter != null && iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null || this.selValueList.indexOf(obj) >= 0) continue;
            this.selValueList.add(obj);
        }
        this.needRefreshList = false;
        return this.selValueList;
    }

    protected Chart getChartModel(IReportItem item) {
        Chart cm = this.context != null && this.context.getModel() != null ? this.context.getModel() : (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
        return cm;
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        this.updateButtons();
        return super.open();
    }

    protected void updateMessage(String s, int type) {
        super.setMessage(s, type);
    }

    public boolean close() {
        this.shutDownDteSession();
        return super.close();
    }

    private boolean isMeasureSelected() {
        this.exprCodec.setExpression(this.expression.getText());
        this.exprCodec.setType(this.expButton.getExpressionType());
        String bindingName = this.exprCodec.getBindingName();
        return this.measureList.contains(bindingName);
    }
}

