/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.properties.dialogs.attributes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.i18n.Messages;
import org.eclipse.jubula.client.teststyle.properties.dialogs.DlgUtils;
import org.eclipse.jubula.client.teststyle.properties.dialogs.attributes.provider.AttrCellModifier;
import org.eclipse.jubula.client.teststyle.properties.dialogs.attributes.provider.AttrContentProvider;
import org.eclipse.jubula.client.teststyle.properties.dialogs.attributes.provider.AttrLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class EditAttributeDialog
extends TrayDialog {
    public static final int TABLE_STYLE = 67588;
    public static final int COLUMN_WIDTH = 95;
    public static final String VALUE_COLUMN = Messages.EditAttributeColumnValue;
    public static final String DESCRIPTION_COLUMN = Messages.EditAttributeColumnDescription;
    public static final String TITLE = Messages.EditAttributeDialogTitle;
    private static final String TESTSTYLE_PROPERTY_PAGE_EDIT_ATTRIBUTE = "org.eclipse.jubula.client.ua.help.testStylePropertyPageEditAttributeContextId";
    private BaseCheck m_chk;
    private Map<String, String> m_attributes;
    private Map<String, String> m_descriptions;
    private TableViewer m_tView;

    public EditAttributeDialog(Shell parentShell, BaseCheck check) {
        super(parentShell);
        this.setShellStyle(67696);
        this.m_chk = check;
        this.m_attributes = new HashMap<String, String>(check.getAttributes());
        this.m_descriptions = new HashMap<String, String>(check.getDescriptions());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = DlgUtils.createFillComposite(parent);
        this.createTable(composite);
        this.getShell().setText(TITLE);
        this.setHelpAvailable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), TESTSTYLE_PROPERTY_PAGE_EDIT_ATTRIBUTE);
        return super.createDialogArea(parent);
    }

    private void createTable(Composite parent) {
        this.m_tView = new TableViewer(parent, 67588);
        this.m_tView.setColumnProperties(new String[]{DESCRIPTION_COLUMN, VALUE_COLUMN});
        Table table = this.m_tView.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn descriptionColumn = new TableColumn(table, 0);
        descriptionColumn.setWidth(95);
        descriptionColumn.setText(DESCRIPTION_COLUMN);
        TableColumn valueColumn = new TableColumn(table, 0);
        valueColumn.setWidth(95);
        valueColumn.setText(VALUE_COLUMN);
        this.m_tView.setContentProvider((IContentProvider)new AttrContentProvider());
        this.m_tView.setLabelProvider((IBaseLabelProvider)new AttrLabelProvider(this.m_attributes, this.m_descriptions));
        this.m_tView.setCellModifier((ICellModifier)new AttrCellModifier(this.m_attributes, this.m_tView));
        this.m_tView.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.m_tView.getTable()), new TextCellEditor((Composite)this.m_tView.getTable()), new TextCellEditor((Composite)this.m_tView.getTable())});
        this.m_tView.setInput(this.m_attributes);
        descriptionColumn.pack();
        descriptionColumn.setWidth(descriptionColumn.getWidth() + 5);
    }

    protected void okPressed() {
        super.okPressed();
        this.m_chk.setAttributes(this.m_attributes);
    }
}

