/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.ui;

import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.print.IPrintPreferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DoubleFieldWithDropDown
extends Composite
implements ModifyListener,
SelectionListener {
    public static final String decimalNumberFormat = "###0.00";
    private IPrintPreferences _preferences;
    private int _index;
    private Combo _text;
    private boolean _internalModify = false;
    private boolean _initialUpdate = true;

    public DoubleFieldWithDropDown(Composite parent, int style, IPrintPreferences prefs, int index, double[] defaults) {
        super(parent, style);
        this._preferences = prefs;
        this._index = index;
        FillLayout fill = new FillLayout();
        this.setLayout((Layout)fill);
        this._text = new Combo((Composite)this, 2052);
        int i = 0;
        while (i < defaults.length) {
            this._text.add(Double.toString(defaults[i]));
            ++i;
        }
        this.updateControl();
        this._text.addModifyListener((ModifyListener)this);
        GridData gridData = new GridData(32);
        gridData.widthHint = 50;
    }

    public void setEnabled(boolean en) {
        this._text.setEnabled(en);
    }

    public void updateControl() {
        block9: {
            this._internalModify = true;
            double newValue = this._preferences.getDoublePreference(this._index);
            try {
                try {
                    if (this._text.getText().length() != 0) {
                        double oldValue = Double.valueOf(this._text.getText());
                        if (newValue != oldValue) {
                            this._text.setText(Double.toString(newValue));
                        }
                    } else if (this._initialUpdate) {
                        this._text.setText(Double.toString(newValue));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this._text.setText(Double.toString(newValue));
                    this._internalModify = false;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this._internalModify = false;
                throw throwable;
            }
            this._internalModify = false;
        }
        this._initialUpdate = false;
    }

    public Object getText() {
        return this._text;
    }

    public void addModifyListener(ModifyListener listener) {
        this._text.addModifyListener(listener);
    }

    public void modifyText(ModifyEvent e) {
        if (this._internalModify) {
            return;
        }
        try {
            double value;
            String text = this._text.getText();
            if (text.length() == 0) {
                value = new Double(0.0);
            } else {
                value = new Double(text);
                if (value < 0.0) {
                    throw new NumberFormatException(String.valueOf(Messages.DoubleFieldWithDropDown_0) + value);
                }
            }
            this._preferences.setDoublePreference(this._index, value);
        }
        catch (NumberFormatException numberFormatException) {
            this.updateControl();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this._internalModify) {
            return;
        }
        try {
            String text = this._text.getItem(this._text.getSelectionIndex());
            double value = new Double(text);
            this._preferences.setDoublePreference(this._index, value);
        }
        catch (NumberFormatException numberFormatException) {
            this.updateControl();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

