/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CorrosionPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.corrosion";
    private static CorrosionPlugin plugin;

    private static synchronized void setSharedInstance(CorrosionPlugin newValue) {
        plugin = newValue;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CorrosionPlugin.setSharedInstance(this);
    }

    public void stop(BundleContext context) throws Exception {
        CorrosionPlugin.setSharedInstance(null);
        super.stop(context);
    }

    public static CorrosionPlugin getDefault() {
        return plugin;
    }

    public static void logError(Throwable t) {
        CorrosionPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static void showError(String title, String message, Exception exception) {
        CorrosionPlugin.showError(title, String.valueOf(message) + '\n' + exception.getLocalizedMessage());
    }

    public static void showError(String title, String message) {
        Display.getDefault().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, message, 1, 0, new String[]{IDialogConstants.OK_LABEL});
            dialog.setBlockOnOpen(false);
            dialog.open();
        });
    }

    public static boolean validateCommandVersion(String commandPath, Pattern matchPattern) {
        return matchPattern.matcher(CorrosionPlugin.getOutputFromCommand(String.valueOf(commandPath) + " --version")).matches();
    }

    public static Process getProcessForCommand(String ... commandStrings) throws IOException {
        String[] command = new String[3];
        if (Platform.getOS().equals("win32")) {
            command[0] = "cmd";
            command[1] = "/c";
        } else {
            command[0] = "/bin/bash";
            command[1] = "-c";
        }
        command[2] = String.join((CharSequence)" ", commandStrings);
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(CorrosionPlugin.getWorkingDirectoryFromPreferences());
        return builder.start();
    }

    private static File getWorkingDirectoryFromPreferences() {
        String wdString = CorrosionPlugin.getDefault().getPreferenceStore().getString("corrosion.workingDirectory");
        if (wdString == null) {
            return null;
        }
        File wdFile = new File(wdString);
        if (wdFile.exists() && wdFile.isDirectory()) {
            return wdFile;
        }
        return null;
    }

    public static String getOutputFromCommand(String ... commandStrings) {
        try {
            Process process = CorrosionPlugin.getProcessForCommand(commandStrings);
            if (process.waitFor() == 0) {
                Throwable throwable = null;
                Object var3_6 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    return in.readLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }
}

