/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core;

import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.core.runtime.Platform;

public class AutotoolsEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable path = VerboseEnvironmentVariable.create();
        return new IBuildEnvironmentVariable[]{path};
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (VerboseEnvironmentVariable.isVar(variableName)) {
            return VerboseEnvironmentVariable.create();
        }
        return null;
    }

    private static class VerboseEnvironmentVariable
    extends EnvironmentVariable
    implements IBuildEnvironmentVariable {
        private static final String VERBOSE_VAR_NAME = "V";
        private static final String VERBOSE_VAR_VALUE = "1";

        private VerboseEnvironmentVariable(String name, String value, int op, String delimiter) {
            super(name, value, op, delimiter);
        }

        private static boolean isVar(String name) {
            return Platform.getOS().equals("win32") ? name.equalsIgnoreCase(VERBOSE_VAR_NAME) : name.equals(VERBOSE_VAR_NAME);
        }

        private static IBuildEnvironmentVariable create() {
            return new VerboseEnvironmentVariable(VERBOSE_VAR_NAME, VERBOSE_VAR_VALUE, 3, null);
        }
    }
}

