/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.edit.editor;

import net.sourceforge.nattable.edit.editor.AbstractCellEditor;
import net.sourceforge.nattable.edit.editor.EditorSelectionEnum;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.style.CellStyleAttributes;
import net.sourceforge.nattable.style.HorizontalAlignmentEnum;
import net.sourceforge.nattable.style.IStyle;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextCellEditor
extends AbstractCellEditor {
    private EditorSelectionEnum selectionMode = EditorSelectionEnum.ALL;
    private Text text = null;
    private boolean editable = true;

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public final void setSelectionMode(EditorSelectionEnum selectionMode) {
        this.selectionMode = selectionMode;
    }

    public final EditorSelectionEnum getSelectionMode() {
        return this.selectionMode;
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue, Character initialEditValue) {
        this.text = this.createTextControl(parent);
        if (initialEditValue != null) {
            this.selectionMode = EditorSelectionEnum.END;
            this.text.setText(initialEditValue.toString());
            this.selectText();
        } else {
            this.setCanonicalValue(originalCanonicalValue);
        }
        if (!this.isEditable()) {
            this.text.setEditable(false);
        }
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    TextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE);
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    TextCellEditor.this.close();
                }
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                boolean committed = false;
                if (event.keyCode == 9 && event.stateMask == 131072) {
                    committed = TextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.LEFT);
                } else if (event.keyCode == 9 && event.stateMask == 0) {
                    committed = TextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.RIGHT);
                }
                if (!committed) {
                    event.doit = false;
                }
            }
        });
        this.text.forceFocus();
        return this.text;
    }

    private void selectText() {
        int textLength = this.text.getText().length();
        if (textLength > 0) {
            EditorSelectionEnum selectionMode = this.getSelectionMode();
            if (selectionMode == EditorSelectionEnum.ALL) {
                this.text.setSelection(0, textLength);
            } else if (selectionMode == EditorSelectionEnum.END) {
                this.text.setSelection(textLength, textLength);
            }
        }
    }

    protected Text createTextControl(Composite parent) {
        IStyle cellStyle = this.getCellStyle();
        final Text textControl = new Text(parent, HorizontalAlignmentEnum.getSWTStyle(cellStyle));
        textControl.setBackground(cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        textControl.setForeground(cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        textControl.setFont(cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        textControl.addKeyListener((KeyListener)new KeyAdapter(){
            private final Color originalColor;
            {
                this.originalColor = text.getForeground();
            }

            public void keyReleased(KeyEvent e) {
                if (!TextCellEditor.this.validateCanonicalValue()) {
                    textControl.setForeground(GUIHelper.COLOR_RED);
                } else {
                    textControl.setForeground(this.originalColor);
                }
            }
        });
        return textControl;
    }

    public Object getCanonicalValue() {
        return this.getDataTypeConverter().displayToCanonicalValue(this.text.getText());
    }

    public void setCanonicalValue(Object canonicalValue) {
        String displayValue = (String)this.getDataTypeConverter().canonicalToDisplayValue(canonicalValue);
        this.text.setText(displayValue != null && displayValue.length() > 0 ? displayValue.toString() : "");
        this.selectText();
    }

    public void close() {
        super.close();
        if (this.text != null && !this.text.isDisposed()) {
            this.text.dispose();
        }
    }
}

