/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrExists;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrFilter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrTripleLike;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrValues;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class FuseUnionOfNpsBranchesTransform
extends BaseTransform {
    private FuseUnionOfNpsBranchesTransform() {
    }

    public static IrBGP apply(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            IrBGP inner;
            IrNode n;
            IrNode m = n = iterator.next();
            if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                inner = FuseUnionOfNpsBranchesTransform.apply(g.getWhere(), r);
                inner = FuseUnionOfNpsBranchesTransform.fuseUnionsInBGP(inner);
                m = new IrGraph(g.getGraph(), inner, g.isNewScope());
            } else if (n instanceof IrOptional) {
                IrOptional o = (IrOptional)n;
                IrOptional no = new IrOptional(FuseUnionOfNpsBranchesTransform.apply(o.getWhere(), r), o.isNewScope());
                no.setNewScope(o.isNewScope());
                m = no;
            } else if (n instanceof IrMinus) {
                IrMinus mi = (IrMinus)n;
                m = new IrMinus(FuseUnionOfNpsBranchesTransform.apply(mi.getWhere(), r), mi.isNewScope());
            } else if (n instanceof IrService) {
                IrService s = (IrService)n;
                inner = FuseUnionOfNpsBranchesTransform.apply(s.getWhere(), r);
                inner = FuseUnionOfNpsBranchesTransform.fuseUnionsInBGP(inner);
                m = new IrService(s.getServiceRefText(), s.isSilent(), inner, s.isNewScope());
            } else if (!(n instanceof IrSubSelect)) {
                if (n instanceof IrFilter) {
                    IrFilter f = (IrFilter)n;
                    IrNode body = f.getBody();
                    if (body instanceof IrExists) {
                        IrExists ex = (IrExists)body;
                        IrFilter nf = new IrFilter(new IrExists(FuseUnionOfNpsBranchesTransform.applyInsideExists(ex.getWhere(), r), ex.isNewScope()), f.isNewScope());
                        m = nf;
                    } else {
                        m = n.transformChildren(child -> {
                            if (child instanceof IrBGP) {
                                return FuseUnionOfNpsBranchesTransform.apply((IrBGP)child, r);
                            }
                            return child;
                        });
                    }
                } else if (n instanceof IrUnion) {
                    IrUnion u = (IrUnion)n;
                    IrUnion u2 = new IrUnion(u.isNewScope());
                    boolean parentHasValues = FuseUnionOfNpsBranchesTransform.branchHasTopLevelValues(bgp);
                    for (IrBGP b : u.getBranches()) {
                        if (parentHasValues || FuseUnionOfNpsBranchesTransform.branchHasTopLevelValues(b)) {
                            IrBGP nb = new IrBGP(b.isNewScope());
                            for (IrNode ln2 : b.getLines()) {
                                if (ln2 instanceof IrGraph) {
                                    IrGraph g2 = (IrGraph)ln2;
                                    IrBGP inner2 = FuseUnionOfNpsBranchesTransform.apply(g2.getWhere(), r);
                                    nb.add(new IrGraph(g2.getGraph(), inner2, g2.isNewScope()));
                                    continue;
                                }
                                if (ln2 instanceof IrBGP) {
                                    nb.add(FuseUnionOfNpsBranchesTransform.apply((IrBGP)ln2, r));
                                    continue;
                                }
                                nb.add(ln2.transformChildren(child -> {
                                    if (child instanceof IrBGP) {
                                        return FuseUnionOfNpsBranchesTransform.apply((IrBGP)child, r);
                                    }
                                    return child;
                                }));
                            }
                            u2.addBranch(nb);
                            continue;
                        }
                        u2.addBranch(FuseUnionOfNpsBranchesTransform.apply(b, r));
                    }
                    m = u2;
                } else {
                    m = n.transformChildren(child -> {
                        if (child instanceof IrBGP) {
                            return FuseUnionOfNpsBranchesTransform.apply((IrBGP)child, r);
                        }
                        return child;
                    });
                }
            }
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static IrBGP fuseUnionsInBGP(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        boolean containsValues = false;
        for (IrNode ln0 : bgp.getLines()) {
            if (!(ln0 instanceof IrValues)) continue;
            containsValues = true;
            break;
        }
        for (IrNode ln : bgp.getLines()) {
            if (!containsValues && ln instanceof IrUnion) {
                List<IrNode> ls;
                IrBGP grp;
                IrUnion u = (IrUnion)ln;
                IrNode fused = FuseUnionOfNpsBranchesTransform.tryFuseUnion(u);
                if (fused instanceof IrBGP && !(grp = (IrBGP)fused).isNewScope() && (ls = grp.getLines()) != null && ls.size() == 1) {
                    fused = ls.get(0);
                }
                out.add(fused);
                continue;
            }
            if (ln instanceof IrGraph) {
                IrGraph g = (IrGraph)ln;
                out.add(new IrGraph(g.getGraph(), FuseUnionOfNpsBranchesTransform.fuseUnionsInBGP(g.getWhere()), g.isNewScope()));
                continue;
            }
            if (ln instanceof IrOptional) {
                IrOptional o = (IrOptional)ln;
                IrOptional no = new IrOptional(FuseUnionOfNpsBranchesTransform.fuseUnionsInBGP(o.getWhere()), o.isNewScope());
                no.setNewScope(o.isNewScope());
                out.add(no);
                continue;
            }
            if (ln instanceof IrMinus) {
                IrMinus mi = (IrMinus)ln;
                out.add(new IrMinus(FuseUnionOfNpsBranchesTransform.fuseUnionsInBGP(mi.getWhere()), mi.isNewScope()));
                continue;
            }
            if (ln instanceof IrService) {
                IrService s = (IrService)ln;
                out.add(new IrService(s.getServiceRefText(), s.isSilent(), FuseUnionOfNpsBranchesTransform.fuseUnionsInBGP(s.getWhere()), s.isNewScope()));
                continue;
            }
            if (ln instanceof IrBGP) {
                out.add(FuseUnionOfNpsBranchesTransform.fuseUnionsInBGP((IrBGP)ln));
                continue;
            }
            out.add(ln);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static boolean branchHasTopLevelValues(IrBGP b) {
        if (b == null) {
            return false;
        }
        for (IrNode ln : b.getLines()) {
            if (!(ln instanceof IrValues)) continue;
            return true;
        }
        return false;
    }

    private static IrNode tryFuseUnion(IrUnion u) {
        if (u == null || u.getBranches().size() < 2) {
            return u;
        }
        if (BaseTransform.unionIsExplicitAndAllBranchesScoped(u)) {
            return u;
        }
        boolean wasNewScope = u.isNewScope();
        Var graphRef = null;
        boolean graphRefNewScope = false;
        boolean innerBgpNewScope = false;
        Var sCanon = null;
        Var oCanon = null;
        IrTripleLike firstPt = null;
        ArrayList<String> members = new ArrayList<String>();
        int fusedCount = 0;
        ArrayList<Set<String>> anonPerBranch = new ArrayList<Set<String>>();
        for (IrBGP b : u.getBranches()) {
            IrPathTriple pt;
            IrNode inner;
            Var g = null;
            boolean gNewScope = false;
            boolean whereNewScope = false;
            IrNode node = FuseUnionOfNpsBranchesTransform.singleChild(b);
            while (node instanceof IrBGP && (inner = FuseUnionOfNpsBranchesTransform.singleChild((IrBGP)node)) != null) {
                node = inner;
            }
            if (node instanceof IrGraph) {
                IrNode inner2;
                IrGraph gb = (IrGraph)node;
                g = gb.getGraph();
                gNewScope = gb.isNewScope();
                whereNewScope = gb.getWhere() != null && gb.getWhere().isNewScope();
                node = FuseUnionOfNpsBranchesTransform.singleChild(gb.getWhere());
                while (node instanceof IrBGP && (inner2 = FuseUnionOfNpsBranchesTransform.singleChild((IrBGP)node)) != null) {
                    node = inner2;
                }
            }
            if (node instanceof IrBGP) {
                node = FuseUnionOfNpsBranchesTransform.singleChild((IrBGP)node);
            }
            IrPathTriple irPathTriple = pt = node instanceof IrPathTriple ? (IrPathTriple)node : null;
            if (pt == null) {
                return u;
            }
            String rawPath = pt.getPathText() == null ? null : pt.getPathText().trim();
            String path = BaseTransform.normalizeCompactNps(rawPath);
            if (path == null || !path.startsWith("!(") || !path.endsWith(")") || path.indexOf(47) >= 0 || path.endsWith("?") || path.endsWith("+") || path.endsWith("*")) {
                return u;
            }
            if (sCanon == null && oCanon == null) {
                sCanon = pt.getSubject();
                oCanon = pt.getObject();
                firstPt = pt;
                graphRef = g;
                graphRefNewScope = gNewScope;
                innerBgpNewScope = whereNewScope;
                FuseUnionOfNpsBranchesTransform.addMembers(path, members);
                anonPerBranch.add(FuseUnionOfNpsBranchesTransform.collectAnonNamesFromPathTriple(pt));
                ++fusedCount;
                continue;
            }
            if (graphRef == null && g != null || graphRef != null && g == null || graphRef != null && !FuseUnionOfNpsBranchesTransform.sameVarOrValue(graphRef, g)) {
                return u;
            }
            String toAdd = path;
            if (FuseUnionOfNpsBranchesTransform.sameVarOrValue(sCanon, pt.getObject()) && FuseUnionOfNpsBranchesTransform.sameVarOrValue(oCanon, pt.getSubject())) {
                String inv = FuseUnionOfNpsBranchesTransform.invertNegatedPropertySet(path);
                if (inv == null) {
                    return u;
                }
                toAdd = inv;
            } else if (!FuseUnionOfNpsBranchesTransform.sameVarOrValue(sCanon, pt.getSubject()) || !FuseUnionOfNpsBranchesTransform.sameVarOrValue(oCanon, pt.getObject())) {
                return u;
            }
            FuseUnionOfNpsBranchesTransform.addMembers(toAdd, members);
            anonPerBranch.add(FuseUnionOfNpsBranchesTransform.collectAnonNamesFromPathTriple(pt));
            ++fusedCount;
        }
        if (fusedCount >= 2 && !members.isEmpty()) {
            IrNode fused;
            if (wasNewScope) {
                boolean allowedByCommonAnon = FuseUnionOfNpsBranchesTransform.unionBranchesShareAnonPathVarWithAllowedRoleMapping(u);
                if (!allowedByCommonAnon) {
                    FuseUnionOfNpsBranchesTransform.unionBranchesShareAnonPathVarWithAllowedRoleMapping(u);
                    return u;
                }
            } else {
                boolean allHaveAnon = FuseUnionOfNpsBranchesTransform.unionBranchesAllHaveAnonPathBridge(u);
                if (!allHaveAnon) {
                    return u;
                }
            }
            if (!FuseUnionOfNpsBranchesTransform.branchesShareSpecificAnon(anonPerBranch)) {
                return u;
            }
            String merged = "!(" + String.join((CharSequence)"|", members) + ")";
            IrPathTriple mergedPt = new IrPathTriple(sCanon, firstPt.getSubjectOverride(), merged, oCanon, firstPt.getObjectOverride(), ((IrPathTriple)firstPt).getPathVars(), false);
            if (graphRef != null) {
                IrBGP inner = new IrBGP(innerBgpNewScope);
                inner.add(mergedPt);
                fused = new IrGraph(graphRef, inner, graphRefNewScope);
            } else {
                fused = mergedPt;
            }
            if (wasNewScope) {
                IrBGP grp = new IrBGP(false);
                grp.add(fused);
                return grp;
            }
            return fused;
        }
        return u;
    }

    private static IrNode singleChild(IrBGP b) {
        if (b == null) {
            return null;
        }
        List<IrNode> ls = b.getLines();
        if (ls == null || ls.size() != 1) {
            return null;
        }
        return ls.get(0);
    }

    private static IrBGP applyInsideExists(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            IrFilter f;
            IrNode body;
            IrNode n;
            IrNode m = n = iterator.next();
            if (n instanceof IrUnion) {
                m = FuseUnionOfNpsBranchesTransform.tryFuseUnion((IrUnion)n);
            } else if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                m = new IrGraph(g.getGraph(), FuseUnionOfNpsBranchesTransform.applyInsideExists(g.getWhere(), r), g.isNewScope());
            } else if (n instanceof IrOptional) {
                IrOptional o = (IrOptional)n;
                IrOptional no2 = new IrOptional(FuseUnionOfNpsBranchesTransform.applyInsideExists(o.getWhere(), r), o.isNewScope());
                no2.setNewScope(o.isNewScope());
                m = no2;
            } else if (n instanceof IrMinus) {
                IrMinus mi = (IrMinus)n;
                m = new IrMinus(FuseUnionOfNpsBranchesTransform.applyInsideExists(mi.getWhere(), r), mi.isNewScope());
            } else if (n instanceof IrService) {
                IrService s = (IrService)n;
                m = new IrService(s.getServiceRefText(), s.isSilent(), FuseUnionOfNpsBranchesTransform.applyInsideExists(s.getWhere(), r), s.isNewScope());
            } else if (!(n instanceof IrSubSelect) && n instanceof IrFilter && (body = (f = (IrFilter)n).getBody()) instanceof IrExists) {
                IrExists ex = (IrExists)body;
                IrFilter nf = new IrFilter(new IrExists(FuseUnionOfNpsBranchesTransform.applyInsideExists(ex.getWhere(), r), ex.isNewScope()), f.isNewScope());
                m = nf;
            }
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static void addMembers(String npsPath, List<String> out) {
        int start = npsPath.indexOf(40);
        int end = npsPath.lastIndexOf(41);
        if (start < 0 || end < 0 || end <= start) {
            return;
        }
        String inner = npsPath.substring(start + 1, end);
        for (String tok : inner.split("\\|")) {
            String t = tok.trim();
            if (t.isEmpty()) continue;
            out.add(t);
        }
    }

    private static Set<String> collectAnonNamesFromPathTriple(IrPathTriple pt) {
        Set<Var> pvs;
        HashSet<String> out = new HashSet<String>();
        if (pt == null) {
            return out;
        }
        Var s = pt.getSubject();
        Var o = pt.getObject();
        if (FuseUnionOfNpsBranchesTransform.isAnonPathVar(s) || FuseUnionOfNpsBranchesTransform.isAnonPathInverseVar(s)) {
            out.add(s.getName());
        }
        if (FuseUnionOfNpsBranchesTransform.isAnonPathVar(o) || FuseUnionOfNpsBranchesTransform.isAnonPathInverseVar(o)) {
            out.add(o.getName());
        }
        if ((pvs = pt.getPathVars()) != null) {
            for (Var v : pvs) {
                if (v == null || v.hasValue() || v.getName() == null || !v.getName().startsWith("_anon_path_") && !v.getName().startsWith("_anon_path_inverse_")) continue;
                out.add(v.getName());
            }
        }
        return out;
    }

    private static boolean branchesShareSpecificAnon(List<Set<String>> anonPerBranch) {
        if (anonPerBranch == null || anonPerBranch.size() < 2) {
            return false;
        }
        HashSet<String> inter = null;
        for (Set<String> s : anonPerBranch) {
            if (s == null || s.isEmpty()) {
                return false;
            }
            if (inter == null) {
                inter = new HashSet<String>(s);
                continue;
            }
            inter.retainAll(s);
            if (!inter.isEmpty()) continue;
            return false;
        }
        return !inter.isEmpty();
    }
}

