/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import java.math.BigDecimal;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;

public class DecimalCast
extends CastFunction {
    @Override
    protected Literal convert(ValueFactory valueFactory, Value value) throws ValueExprEvaluationException {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            CoreDatatype.XSD datatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
            if (datatype != null && datatype.isNumericDatatype()) {
                try {
                    BigDecimal decimalValue = literal.decimalValue();
                    return valueFactory.createLiteral(decimalValue.toPlainString(), (CoreDatatype)CoreDatatype.XSD.DECIMAL);
                }
                catch (NumberFormatException e) {
                    throw this.typeError(literal, e);
                }
            }
            if (datatype == CoreDatatype.XSD.BOOLEAN) {
                try {
                    return valueFactory.createLiteral(literal.booleanValue() ? "1.0" : "0.0", (CoreDatatype)CoreDatatype.XSD.DECIMAL);
                }
                catch (IllegalArgumentException e) {
                    throw this.typeError(literal, e);
                }
            }
        }
        throw this.typeError(value, null);
    }

    @Override
    protected CoreDatatype.XSD getCoreXsdDatatype() {
        return CoreDatatype.XSD.DECIMAL;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidDecimal(lexicalValue);
    }
}

