/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.wal;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;

public final class ValueStoreWalConfig {
    public static final String DEFAULT_DIRECTORY_NAME = "value-store-wal";
    private final Path walDirectory;
    private final Path snapshotsDirectory;
    private final String storeUuid;
    private final long maxSegmentBytes;
    private final int queueCapacity;
    private final int batchBufferBytes;
    private final SyncPolicy syncPolicy;
    private final Duration syncInterval;
    private final Duration idlePollInterval;
    private final boolean syncBootstrapOnOpen;
    private final boolean recoverValueStoreOnOpen;

    private ValueStoreWalConfig(Builder builder) {
        this.walDirectory = builder.walDirectory;
        this.snapshotsDirectory = builder.snapshotsDirectory;
        this.storeUuid = builder.storeUuid;
        this.maxSegmentBytes = builder.maxSegmentBytes;
        this.queueCapacity = builder.queueCapacity;
        this.batchBufferBytes = builder.batchBufferBytes;
        this.syncPolicy = builder.syncPolicy;
        this.syncInterval = builder.syncInterval;
        this.idlePollInterval = builder.idlePollInterval;
        this.syncBootstrapOnOpen = builder.syncBootstrapOnOpen;
        this.recoverValueStoreOnOpen = builder.recoverValueStoreOnOpen;
    }

    public Path walDirectory() {
        return this.walDirectory;
    }

    public Path snapshotsDirectory() {
        return this.snapshotsDirectory;
    }

    public String storeUuid() {
        return this.storeUuid;
    }

    public long maxSegmentBytes() {
        return this.maxSegmentBytes;
    }

    public int queueCapacity() {
        return this.queueCapacity;
    }

    public int batchBufferBytes() {
        return this.batchBufferBytes;
    }

    public SyncPolicy syncPolicy() {
        return this.syncPolicy;
    }

    public Duration syncInterval() {
        return this.syncInterval;
    }

    public Duration idlePollInterval() {
        return this.idlePollInterval;
    }

    public boolean syncBootstrapOnOpen() {
        return this.syncBootstrapOnOpen;
    }

    public boolean recoverValueStoreOnOpen() {
        return this.recoverValueStoreOnOpen;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Path walDirectory;
        private Path snapshotsDirectory;
        private String storeUuid;
        private long maxSegmentBytes = 0x8000000L;
        private int queueCapacity = 16384;
        private int batchBufferBytes = 131072;
        private SyncPolicy syncPolicy = SyncPolicy.INTERVAL;
        private Duration syncInterval = Duration.ofSeconds(1L);
        private Duration idlePollInterval = Duration.ofMillis(100L);
        private boolean syncBootstrapOnOpen = false;
        private boolean recoverValueStoreOnOpen = false;

        private Builder() {
        }

        public Builder walDirectory(Path walDirectory) {
            this.walDirectory = Objects.requireNonNull(walDirectory, "walDirectory");
            if (this.snapshotsDirectory == null) {
                this.snapshotsDirectory = walDirectory.resolve("snapshots");
            }
            return this;
        }

        public Builder snapshotsDirectory(Path snapshotsDirectory) {
            this.snapshotsDirectory = Objects.requireNonNull(snapshotsDirectory, "snapshotsDirectory");
            return this;
        }

        public Builder storeUuid(String storeUuid) {
            this.storeUuid = Objects.requireNonNull(storeUuid, "storeUuid");
            return this;
        }

        public Builder maxSegmentBytes(long maxSegmentBytes) {
            this.maxSegmentBytes = maxSegmentBytes;
            return this;
        }

        public Builder queueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
            return this;
        }

        public Builder batchBufferBytes(int batchBufferBytes) {
            this.batchBufferBytes = batchBufferBytes;
            return this;
        }

        public Builder syncPolicy(SyncPolicy syncPolicy) {
            this.syncPolicy = Objects.requireNonNull(syncPolicy, "syncPolicy");
            return this;
        }

        public Builder syncInterval(Duration syncInterval) {
            this.syncInterval = Objects.requireNonNull(syncInterval, "syncInterval");
            return this;
        }

        public Builder idlePollInterval(Duration idlePollInterval) {
            this.idlePollInterval = Objects.requireNonNull(idlePollInterval, "idlePollInterval");
            return this;
        }

        public Builder syncBootstrapOnOpen(boolean syncBootstrapOnOpen) {
            this.syncBootstrapOnOpen = syncBootstrapOnOpen;
            return this;
        }

        public Builder recoverValueStoreOnOpen(boolean recoverValueStoreOnOpen) {
            this.recoverValueStoreOnOpen = recoverValueStoreOnOpen;
            return this;
        }

        public ValueStoreWalConfig build() {
            if (this.walDirectory == null) {
                throw new IllegalStateException("walDirectory must be set");
            }
            if (this.snapshotsDirectory == null) {
                this.snapshotsDirectory = this.walDirectory.resolve("snapshots");
            }
            if (this.storeUuid == null || this.storeUuid.isEmpty()) {
                throw new IllegalStateException("storeUuid must be set");
            }
            if (this.maxSegmentBytes <= 0L) {
                throw new IllegalStateException("maxSegmentBytes must be positive");
            }
            if (this.queueCapacity <= 0) {
                throw new IllegalStateException("queueCapacity must be positive");
            }
            if (this.batchBufferBytes <= 4096) {
                throw new IllegalStateException("batchBufferBytes must be > 4KB");
            }
            return new ValueStoreWalConfig(this);
        }
    }

    public static enum SyncPolicy {
        ALWAYS,
        INTERVAL,
        COMMIT;

    }
}

