/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TripleRef;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;

public class EvaluationStatistics {
    private static final String uniqueIdPrefix = UUID.randomUUID().toString().replace("-", "");
    private static final AtomicLong uniqueIdSuffix = new AtomicLong();
    private static final String[] RANDOMIZE_LENGTH = new String[10];
    private CardinalityCalculator calculator;

    public double getCardinality(TupleExpr expr) {
        if (this.calculator == null) {
            this.calculator = this.createCardinalityCalculator();
            assert (this.calculator != null);
        }
        if (expr instanceof AbstractQueryModelNode && ((AbstractQueryModelNode)((Object)expr)).isCardinalitySet()) {
            return ((AbstractQueryModelNode)((Object)expr)).getCardinality();
        }
        expr.visit(this.calculator);
        return this.calculator.getCardinality();
    }

    protected CardinalityCalculator createCardinalityCalculator() {
        return new CardinalityCalculator();
    }

    public boolean supportsJoinEstimation() {
        return false;
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= 9; ++i) {
            EvaluationStatistics.RANDOMIZE_LENGTH[i] = sb.toString();
            sb.append(i);
        }
    }

    protected static class CardinalityCalculator
    extends AbstractQueryModelVisitor<RuntimeException> {
        private static final double VAR_CARDINALITY = 10.0;
        private static final double UNBOUND_SERVICE_CARDINALITY = 100000.0;
        protected double cardinality;

        protected CardinalityCalculator() {
        }

        public double getCardinality() {
            return this.cardinality;
        }

        @Override
        public void meet(EmptySet node) {
            this.cardinality = 0.0;
        }

        @Override
        public void meet(SingletonSet node) {
            this.cardinality = 1.0;
        }

        @Override
        public void meet(BindingSetAssignment node) {
            this.cardinality = this.getCardinalityInternal(node);
        }

        @Override
        public void meet(ZeroLengthPath node) {
            Var subjVar = node.getSubjectVar();
            Var objVar = node.getObjectVar();
            this.cardinality = subjVar != null && subjVar.hasValue() || objVar != null && objVar.hasValue() ? 1.0 : this.getSubjectCardinality(subjVar) * this.getObjectCardinality(objVar) * this.getContextCardinality(node.getContextVar());
        }

        @Override
        public void meet(ArbitraryLengthPath node) {
            long suffix = uniqueIdSuffix.getAndIncrement();
            Var pathVar = Var.of("_anon_path_" + uniqueIdPrefix + suffix + RANDOMIZE_LENGTH[(int)Math.abs(suffix % (long)RANDOMIZE_LENGTH.length)], true);
            this.cardinality = 2.0 * this.getCardinalityInternal(new StatementPattern(node.getSubjectVar().clone(), pathVar, node.getObjectVar().clone(), node.getContextVar() != null ? node.getContextVar().clone() : null));
        }

        @Override
        public void meet(Service node) {
            if (!node.getServiceRef().hasValue()) {
                this.cardinality = 100000.0;
            } else {
                ServiceNodeAnalyzer serviceAnalyzer = new ServiceNodeAnalyzer();
                node.visitChildren(serviceAnalyzer);
                int count = serviceAnalyzer.getStatementCount();
                this.cardinality = count == 1 && node.getServiceVars().size() > 1 ? (double)(100 + node.getServiceVars().size()) : 1.0 + (double)node.getServiceVars().size() * 0.1;
            }
        }

        @Override
        public void meet(StatementPattern sp) {
            this.cardinality = this.getCardinalityInternal(sp);
        }

        @Override
        public void meet(TripleRef tripleRef) {
            this.cardinality = this.getCardinalityInternal(tripleRef);
        }

        private double getCardinalityInternal(StatementPattern node) {
            if (!node.isCardinalitySet()) {
                node.setCardinality(this.getCardinality(node));
            }
            return node.getCardinality();
        }

        private double getCardinalityInternal(TripleRef node) {
            if (!node.isCardinalitySet()) {
                node.setCardinality(this.getCardinality(node));
            }
            return node.getCardinality();
        }

        private double getCardinalityInternal(BindingSetAssignment node) {
            if (!node.isCardinalitySet()) {
                node.setCardinality(this.getCardinality(node));
            }
            return node.getCardinality();
        }

        protected double getCardinality(StatementPattern sp) {
            return this.getSubjectCardinality(sp) * this.getPredicateCardinality(sp) * this.getObjectCardinality(sp) * this.getContextCardinality(sp);
        }

        protected double getCardinality(BindingSetAssignment bindingSetAssignment) {
            return 1.0;
        }

        protected double getCardinality(TripleRef tripleRef) {
            return this.getSubjectCardinality(tripleRef.getSubjectVar()) * this.getPredicateCardinality(tripleRef.getPredicateVar()) * this.getObjectCardinality(tripleRef.getObjectVar());
        }

        protected double getSubjectCardinality(StatementPattern sp) {
            return this.getSubjectCardinality(sp.getSubjectVar());
        }

        protected double getSubjectCardinality(Var var) {
            return this.getCardinality(10.0, var);
        }

        protected double getPredicateCardinality(StatementPattern sp) {
            return this.getPredicateCardinality(sp.getPredicateVar());
        }

        protected double getPredicateCardinality(Var var) {
            return this.getCardinality(10.0, var);
        }

        protected double getObjectCardinality(StatementPattern sp) {
            return this.getObjectCardinality(sp.getObjectVar());
        }

        protected double getObjectCardinality(Var var) {
            return this.getCardinality(10.0, var);
        }

        protected double getContextCardinality(StatementPattern sp) {
            return this.getContextCardinality(sp.getContextVar());
        }

        protected double getContextCardinality(Var var) {
            return this.getCardinality(10.0, var);
        }

        protected double getCardinality(double varCardinality, Var var) {
            return var == null || var.hasValue() ? 1.0 : varCardinality;
        }

        protected double getCardinality(double varCardinality, Collection<Var> vars) {
            int constantVarCount = this.countConstantVars(vars);
            double unboundVarFactor = vars.size() - constantVarCount;
            return Math.pow(varCardinality, unboundVarFactor);
        }

        protected int countConstantVars(Iterable<Var> vars) {
            int constantVarCount = 0;
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                ++constantVarCount;
            }
            return constantVarCount;
        }

        @Override
        public void meet(Join node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        public void meet(LeftJoin node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        protected void meetBinaryTupleOperator(BinaryTupleOperator node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality += leftArgCost;
        }

        @Override
        protected void meetUnaryTupleOperator(UnaryTupleOperator node) {
            node.getArg().visit(this);
        }

        @Override
        public void meet(QueryRoot node) {
            node.getArg().visit(this);
        }

        @Override
        protected void meetNode(QueryModelNode node) {
            throw new IllegalArgumentException("Unhandled node type: " + String.valueOf(node.getClass()));
        }
    }

    private static class ServiceNodeAnalyzer
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        private int count = 0;

        private ServiceNodeAnalyzer() {
            super(true);
        }

        public int getStatementCount() {
            return this.count;
        }

        @Override
        public void meet(StatementPattern node) throws RuntimeException {
            ++this.count;
        }
    }
}

