/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.multiselection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMultiTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.MultiTextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension5;

abstract class AbstractMultiSelectionHandler
extends AbstractHandler {
    private static final String ANCHOR_REGION_KEY = "org.eclipse.ui.internal.texteditor.multiselection.AbstractMultiSelectionHandler.anchorRegion";
    private ExecutionEvent event;
    private ITextEditor textEditor;
    private IDocument document;
    private ITextViewerExtension5 sourceViewer;

    AbstractMultiSelectionHandler() {
    }

    public abstract void execute() throws ExecutionException;

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        if (this.initFrom(executionEvent)) {
            this.execute();
        }
        return null;
    }

    public ExecutionEvent getEvent() {
        return this.event;
    }

    protected boolean isMultiSelectionActive() {
        IRegion[] regions = this.getSelectedRegions();
        return regions != null && regions.length > 1;
    }

    protected boolean nothingSelected() {
        IRegion[] regions = this.getSelectedRegions();
        return regions == null || regions.length == 0 || regions.length == 1 && regions[0].getLength() == 0;
    }

    protected IRegion[] getSelectedRegions() {
        ISelection selection = this.textEditor.getSelectionProvider().getSelection();
        if (!(selection instanceof IMultiTextSelection)) {
            return null;
        }
        return ((IMultiTextSelection)selection).getRegions();
    }

    protected IRegion offsetAsCaretRegion(int offset) {
        return this.createRegionIfValid(offset, 0);
    }

    protected void selectRegion(IRegion region) {
        this.selectRegions(new IRegion[]{region});
    }

    protected void selectRegions(IRegion[] regions) {
        this.setBlockSelectionMode(false);
        MultiTextSelection newSelection = new MultiTextSelection(this.document, regions);
        this.textEditor.getSelectionProvider().setSelection((ISelection)newSelection);
    }

    protected void selectIdentifierUnderCaret() {
        int offset = this.getCaretOffset();
        Region identifierRegion = this.getIdentifierUnderCaretRegion(offset);
        if (identifierRegion != null) {
            this.selectRegion((IRegion)identifierRegion);
            this.setAnchorRegion((IRegion)identifierRegion);
        }
    }

    protected void selectCaretPosition() {
        IRegion caretRegion = this.offsetAsCaretRegion(this.getCaretOffset());
        this.selectRegion(caretRegion);
        this.setAnchorRegion(caretRegion);
    }

    protected boolean allRegionsHaveSameText() {
        return this.allRegionsHaveSameText(this.getSelectedRegions());
    }

    protected boolean allRegionsEmpty() {
        IRegion[] selectedRegions = this.getSelectedRegions();
        if (selectedRegions == null) {
            return true;
        }
        return this.isEmpty(selectedRegions[0]) && this.allRegionsHaveSameText(selectedRegions);
    }

    protected boolean isEmpty(IRegion region) {
        return region == null || region.getLength() == 0;
    }

    protected IRegion getAnchorRegion() {
        return (IRegion)this.getWidget().getData(ANCHOR_REGION_KEY);
    }

    protected void setAnchorRegion(IRegion selection) {
        if (selection == null) {
            this.getWidget().setData(ANCHOR_REGION_KEY, null);
        } else {
            this.getWidget().setData(ANCHOR_REGION_KEY, (Object)selection);
        }
    }

    private void initAnchorRegion() {
        IRegion[] regions = this.getSelectedRegions();
        if (!(regions == null || regions.length != 1 && this.contains(regions, this.getAnchorRegion()))) {
            this.setAnchorRegion(regions[0]);
        }
    }

    private boolean contains(IRegion[] regions, IRegion region) {
        return Arrays.asList(regions).contains(region);
    }

    private boolean allRegionsHaveSameText(IRegion[] regions) {
        if (regions == null || regions.length == 1) {
            return true;
        }
        try {
            return this.allRegionsHaveText(regions, this.regionAsString(regions[0]));
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    private boolean allRegionsHaveText(IRegion[] regions, String text) throws BadLocationException {
        IRegion[] iRegionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            IRegion iRegion = iRegionArray[n2];
            if (!text.equals(this.regionAsString(iRegion))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected IRegion[] addRegion(IRegion[] regions, IRegion newRegion) {
        if (newRegion != null) {
            IRegion[] newRegions = Arrays.copyOf(regions, regions.length + 1);
            newRegions[newRegions.length - 1] = newRegion;
            return newRegions;
        }
        return regions;
    }

    protected IRegion[] removeLastRegionButOne(IRegion[] regions) {
        if (regions == null || regions.length == 0) {
            return null;
        }
        if (regions.length == 1) {
            return regions;
        }
        return Arrays.copyOf(regions, regions.length - 1);
    }

    protected IRegion[] removeFirstRegionButOne(IRegion[] regions) {
        if (regions == null || regions.length == 0) {
            return null;
        }
        if (regions.length == 1) {
            return regions;
        }
        return Arrays.copyOfRange(regions, 1, regions.length);
    }

    protected int getCaretOffset() {
        IRegion[] regions = this.getSelectedRegions();
        if (regions == null) {
            return -1;
        }
        return regions[0].getOffset() + regions[0].getLength();
    }

    protected void setCaretOffset(int caretOffset) {
        this.selectRegion(this.offsetAsCaretRegion(caretOffset));
    }

    protected IRegion findNextMatch(IRegion region) throws ExecutionException {
        try {
            if (region.getLength() == 0) {
                return this.offsetAsCaretRegion(this.offsetInNextLine(region.getOffset()));
            }
            String searchString = this.getTextOfRegion(region);
            String fullText = this.getFullText();
            int matchPos = fullText.indexOf(searchString, this.offsetAfter(region));
            return this.createRegionIfValid(matchPos, region.getLength());
        }
        catch (BadLocationException e) {
            throw new ExecutionException("Internal error in findNextMatch", (Throwable)e);
        }
    }

    protected IRegion findPreviousMatch(IRegion region) throws ExecutionException {
        try {
            if (region.getLength() == 0) {
                return this.offsetAsCaretRegion(this.offsetInPreviousLine(region.getOffset()));
            }
            String searchString = this.getTextOfRegion(region);
            String fullText = this.getFullText();
            int matchPos = fullText.lastIndexOf(searchString, region.getOffset() - 1);
            return this.createRegionIfValid(matchPos, region.getLength());
        }
        catch (BadLocationException e) {
            throw new ExecutionException("Internal error in findPreviousMatch", (Throwable)e);
        }
    }

    protected IRegion createRegionIfValid(int offset, int length) {
        if (offset < 0 || offset > this.document.getLength()) {
            return null;
        }
        return new Region(offset, Math.min(length, this.document.getLength() - offset));
    }

    protected IRegion[] findAllMatches(IRegion region) throws ExecutionException {
        try {
            String searchString = this.getTextOfRegion(region);
            String fullText = this.getFullText();
            List<IRegion> regions = this.findAllMatches(fullText, searchString);
            return this.toArray(regions);
        }
        catch (BadLocationException e) {
            throw new ExecutionException("Internal error in findAllMatches", (Throwable)e);
        }
    }

    private List<IRegion> findAllMatches(String fullText, String searchString) {
        ArrayList<IRegion> regions = new ArrayList<IRegion>();
        int length = searchString.length();
        int matchPos = 0;
        while ((matchPos = fullText.indexOf(searchString, matchPos)) >= 0) {
            regions.add((IRegion)new Region(matchPos, length));
            matchPos += length;
        }
        return regions;
    }

    protected int offsetInNextLine(int offset) throws BadLocationException {
        return this.moveOffsetByLines(offset, 1);
    }

    protected int offsetInPreviousLine(int offset) throws BadLocationException {
        return this.moveOffsetByLines(offset, -1);
    }

    private int moveOffsetByLines(int offset, int lineDelta) throws BadLocationException {
        int newOffset;
        int newLineNo = this.document.getLineOfOffset(offset) + lineDelta;
        if (newLineNo < 0 || newLineNo >= this.document.getNumberOfLines()) {
            return -1;
        }
        if (this.sourceViewer == null) {
            newOffset = this.moveWidgetOffsetByLines(offset, lineDelta);
        } else {
            int widgetOffset = this.sourceViewer.modelOffset2WidgetOffset(offset);
            int newWidgetOffset = this.moveWidgetOffsetByLines(widgetOffset, lineDelta);
            newOffset = this.sourceViewer.widgetOffset2ModelOffset(newWidgetOffset);
        }
        if (newOffset == -1) {
            return this.endOfLineOffset(newLineNo);
        }
        return newOffset;
    }

    private int moveWidgetOffsetByLines(int widgetOffset, int lineDelta) {
        Point location = this.getWidget().getLocationAtOffset(widgetOffset);
        Point newLocation = new Point(location.x, location.y + lineDelta * this.getWidget().getLineHeight(widgetOffset));
        return this.getWidget().getOffsetAtPoint(newLocation);
    }

    private int endOfLineOffset(int lineNo) throws BadLocationException {
        return this.document.getLineOffset(lineNo) + this.document.getLineInformation(lineNo).getLength();
    }

    private boolean initFrom(ExecutionEvent executionEvent) {
        this.event = executionEvent;
        this.initTextEditor();
        if (this.textEditor == null) {
            return false;
        }
        this.initDocument();
        this.initSourceViewer();
        this.initAnchorRegion();
        return true;
    }

    private void initTextEditor() {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)this.event);
        this.textEditor = (ITextEditor)Adapters.adapt((Object)editor, ITextEditor.class);
    }

    private void initDocument() {
        this.document = this.textEditor.getDocumentProvider().getDocument(this.textEditor.getEditorInput());
    }

    private void initSourceViewer() {
        ITextViewer textViewer = (ITextViewer)this.textEditor.getAdapter(ITextViewer.class);
        this.sourceViewer = (ITextViewerExtension5)Adapters.adapt((Object)textViewer, ITextViewerExtension5.class);
    }

    private IRegion[] toArray(List<IRegion> regions) {
        return regions.toArray(new IRegion[regions.size()]);
    }

    private int offsetAfter(IRegion region) {
        return region.getOffset() + region.getLength();
    }

    private String getTextOfRegion(IRegion region) throws BadLocationException {
        return this.document.get(region.getOffset(), region.getLength());
    }

    private String getFullText() {
        return this.document.get();
    }

    private String regionAsString(IRegion region) throws BadLocationException {
        return this.document.get(region.getOffset(), region.getLength());
    }

    private Region getIdentifierUnderCaretRegion(int offset) {
        try {
            int startOffset = this.findStartOfIdentifier(offset);
            int endOffset = this.findEndOfIdentifier(startOffset);
            Region identifierRegion = new Region(startOffset, endOffset - startOffset);
            return identifierRegion;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private int findStartOfIdentifier(int offset) throws BadLocationException {
        int i = offset - 1;
        while (i >= 0) {
            if (!this.isJavaIdentifierCharAtPos(i)) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    private int findEndOfIdentifier(int offset) throws BadLocationException {
        int i = offset;
        while (i <= this.document.getLength()) {
            if (i == this.document.getLength() || !this.isJavaIdentifierCharAtPos(i)) {
                return i;
            }
            ++i;
        }
        return offset;
    }

    private boolean isJavaIdentifierCharAtPos(int i) throws BadLocationException {
        return Character.isJavaIdentifierStart(this.document.getChar(i)) || Character.isJavaIdentifierPart(this.document.getChar(i));
    }

    private StyledText getWidget() {
        return (StyledText)this.textEditor.getAdapter(Control.class);
    }

    private void setBlockSelectionMode(boolean blockSelectionMode) {
        if (!(this.textEditor instanceof ITextEditorExtension5)) {
            return;
        }
        ITextEditorExtension5 ext = (ITextEditorExtension5)((Object)this.textEditor);
        ext.setBlockSelectionMode(blockSelectionMode);
    }

    protected boolean selectionIsAboveAnchorRegion() {
        IRegion[] selectedRegions = this.getSelectedRegions();
        if (selectedRegions == null || selectedRegions.length == 1) {
            return false;
        }
        return this.isLastRegion(this.getAnchorRegion(), selectedRegions);
    }

    protected boolean selectionIsBelowAnchorRegion() {
        IRegion[] selectedRegions = this.getSelectedRegions();
        if (selectedRegions == null || selectedRegions.length == 1) {
            return false;
        }
        return this.isFirstRegion(this.getAnchorRegion(), selectedRegions);
    }

    private boolean isLastRegion(IRegion region, IRegion[] regions) {
        if (region == null || regions == null || regions.length == 0) {
            return false;
        }
        return region.equals(regions[regions.length - 1]);
    }

    private boolean isFirstRegion(IRegion region, IRegion[] regions) {
        if (region == null || regions == null || regions.length == 0) {
            return false;
        }
        return region.equals(regions[0]);
    }
}

