/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource.undostates;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.ContainerUndoState;

public class FolderUndoState
extends ContainerUndoState {
    public FolderUndoState(IFolder folder) {
        super((IContainer)folder);
    }

    public FolderUndoState(IFolder folder, URI linkLocation) {
        super((IContainer)folder);
        this.name = folder.getName();
        this.location = linkLocation;
    }

    @Override
    public IResource createResourceHandle() {
        IWorkspaceRoot workspaceRoot = this.getWorkspace().getRoot();
        IPath folderPath = this.parent.getFullPath().append(this.name);
        return workspaceRoot.getFolder(folderPath);
    }

    @Override
    public void createExistentResourceFromHandle(IResource resource, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((boolean)(resource instanceof IFolder));
        if (resource.exists()) {
            return;
        }
        IFolder folderHandle = (IFolder)resource;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.FolderDescription_NewFolderProgress, (int)200);
        try {
            if (this.location != null) {
                folderHandle.createLink(this.location, 16, (IProgressMonitor)subMonitor.split(100));
            } else {
                folderHandle.create(false, true, (IProgressMonitor)subMonitor.split(100));
            }
            this.createChildResources((IContainer)folderHandle, (IProgressMonitor)subMonitor.split(100));
        }
        finally {
            subMonitor.done();
        }
    }
}

