/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rcptt.core.builder.IQ7ProblemReporter;
import org.eclipse.rcptt.core.internal.builder.Q7Builder;
import org.eclipse.rcptt.core.internal.builder.Q7Problem;

public class Q7ProblemCollector
implements IQ7ProblemReporter {
    Map<IFile, List<Q7Problem>> problems = new HashMap<IFile, List<Q7Problem>>();

    @Override
    public synchronized void reportProblem(IFile element, IQ7ProblemReporter.ProblemType type, String message, int line, int offset, int length, int sourceId) {
        Q7Problem pr = new Q7Problem(message, line, offset, type.getValue(), length, sourceId);
        List<Q7Problem> list = this.problems.get(element);
        if (list == null) {
            list = new ArrayList<Q7Problem>();
            this.problems.put(element, list);
        }
        if (!list.contains(pr)) {
            list.add(pr);
        }
    }

    public synchronized void flushProblems(SubProgressMonitor monitor) {
        monitor.beginTask("Flush problems", this.problems.size());
        for (IFile element : this.problems.keySet()) {
            List<Q7Problem> list = this.problems.get(element);
            for (Q7Problem q7Problem : list) {
                Q7Builder.addMarker(element, q7Problem.getMessage(), q7Problem.getLine(), q7Problem.getSeverity(), q7Problem.getOffset(), q7Problem.getLength(), q7Problem.getSourceId());
            }
        }
        monitor.done();
    }
}

