/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.zephyr;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.eclipse.rcptt.internal.zephyr.ZephyrRestClient;

public final class ZephyrCycle {
    private static final String URL_GET_CYCLES = "%s/rest/zapi/latest/cycle?projectId=%s&versionId=%s";

    public static Map<String, Long> getAllCycles(ZephyrRestClient restClient, long projectId, long versionId) {
        HashMap<String, Long> cycles;
        block16: {
            cycles = new HashMap<String, Long>();
            String url = String.format(URL_GET_CYCLES, restClient.getUrl(), projectId, versionId);
            try {
                Throwable throwable = null;
                Object var8_8 = null;
                try (CloseableHttpResponse response = restClient.get(url);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode >= 200 && statusCode < 300) {
                        HttpEntity entity = response.getEntity();
                        String string = null;
                        try {
                            string = EntityUtils.toString((HttpEntity)entity);
                        }
                        catch (IOException | ParseException e) {
                            throw new IllegalArgumentException(String.format("Bad response entity upon receipt of cycles <%s>", url), e);
                        }
                        JsonObject projObj = new JsonParser().parse(string).getAsJsonObject();
                        int i = 0;
                        while (i < projObj.size()) {
                            Set keys = projObj.keySet();
                            for (String key : keys) {
                                if (key.trim().equals("recordsCount")) continue;
                                JsonObject cycleObject = projObj.get(key).getAsJsonObject();
                                String cycleName = cycleObject.get("name").getAsString();
                                long id = Long.parseLong(key);
                                cycles.put(cycleName, id);
                            }
                            ++i;
                        }
                        break block16;
                    }
                    throw new IllegalArgumentException(String.format("Unexpected response status <%s> upon receipt of cycles <%s>", statusCode, url));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return cycles;
    }

    public static Long getCycleIdByName(ZephyrRestClient restClient, long projectId, long versionId, String cycleName) {
        Map<String, Long> cycles = ZephyrCycle.getAllCycles(restClient, projectId, versionId);
        Long cycleId = cycles.get(cycleName);
        if (cycleId == null) {
            throw new IllegalArgumentException(String.format("Cycle <%s> not found among <%s>", cycleName, String.join((CharSequence)", ", cycles.keySet())));
        }
        return cycleId;
    }
}

