/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;

public class ReadManager {
    private static final int CACHE_SIZE = 15;
    private static final ExecutorService READER_SERVICE = ReadManager.createExecutor(Math.max(0, Math.min(15, Runtime.getRuntime().availableProcessors() - 2)));
    private final Queue<ICompilationUnit> unitsToRead;
    private final Map<ICompilationUnit, Future<char[]>> cache = new ConcurrentHashMap<ICompilationUnit, Future<char[]>>();

    private static ExecutorService createExecutor(int threadCount) {
        if (threadCount <= 0) {
            return null;
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threadCount, threadCount, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread t = new Thread(r, "Compiler Source File Reader");
            t.setDaemon(true);
            return t;
        });
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public ReadManager(ICompilationUnit[] files, int length) {
        this.unitsToRead = new ArrayDeque<ICompilationUnit>(length);
        if (READER_SERVICE == null) {
            return;
        }
        int l = 0;
        while (l < length) {
            ICompilationUnit unit = files[l];
            this.unitsToRead.offer(unit);
            ++l;
        }
        while (this.queueNextReadAhead()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getContents(ICompilationUnit unit) throws Error {
        Future<char[]> future;
        if (READER_SERVICE == null) {
            return this.getWithoutExecutor(unit);
        }
        ReadManager readManager = this;
        synchronized (readManager) {
            future = this.cache.remove(unit);
            if (future == null) {
                this.unitsToRead.remove(unit);
            }
        }
        if (future == null) {
            return this.getWithoutFuture(unit);
        }
        this.queueNextReadAhead();
        try {
            return this.getWithFuture(future);
        }
        catch (InterruptedException ignored) {
            return this.getWhileInterrupted(unit);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof Error) {
                Error err = (Error)throwable;
                throw err;
            }
            Throwable throwable2 = e.getCause();
            if (throwable2 instanceof RuntimeException) {
                RuntimeException ex = (RuntimeException)throwable2;
                throw ex;
            }
            throw new RuntimeException(e);
        }
    }

    private char[] getWithFuture(Future<char[]> future) throws InterruptedException, ExecutionException {
        return future.get();
    }

    private char[] getWithoutExecutor(ICompilationUnit unit) {
        return unit.getContents();
    }

    private char[] getWithoutFuture(ICompilationUnit unit) {
        return unit.getContents();
    }

    private char[] getWhileInterrupted(ICompilationUnit unit) {
        return unit.getContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueNextReadAhead() {
        if (this.cache.size() >= 15) {
            return false;
        }
        ReadManager readManager = this;
        synchronized (readManager) {
            ICompilationUnit nextUnit;
            block5: {
                nextUnit = this.unitsToRead.poll();
                if (nextUnit != null) break block5;
                return false;
            }
            Future<char[]> future = READER_SERVICE.submit(() -> this.readAhead(nextUnit));
            this.cache.put(nextUnit, future);
            return true;
        }
    }

    private char[] readAhead(ICompilationUnit unit) {
        this.queueNextReadAhead();
        return unit.getContents();
    }

    public void shutdown() {
        this.unitsToRead.clear();
        this.cache.clear();
    }
}

