/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contextlaunching;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.TerminateToggleValue;
import org.eclipse.debug.internal.ui.contextlaunching.ContextMessages;
import org.eclipse.debug.internal.ui.contextlaunching.LaunchingResourceManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationSelectionDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutSelectionDialog;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public final class ContextRunner {
    private static ContextRunner fgInstance = null;
    private final LaunchingResourceManager fLRM = DebugUIPlugin.getDefault().getLaunchingResourceManager();

    public static ContextRunner getDefault() {
        if (fgInstance == null) {
            fgInstance = new ContextRunner();
        }
        return fgInstance;
    }

    @Deprecated
    public void launch(ILaunchGroup group) {
        this.launch(group, false);
    }

    public void launch(ILaunchGroup group, boolean isShift) {
        IStructuredSelection selection = SelectedResourceManager.getDefault().getCurrentSelection();
        IResource resource = SelectedResourceManager.getDefault().getSelectedResource();
        this.selectAndLaunch(resource, group, selection, isShift);
    }

    @Deprecated
    protected boolean launchLast(ILaunchGroup group) {
        return this.launchLast(group, false);
    }

    protected boolean launchLast(ILaunchGroup group, boolean isShift) {
        ILaunchConfiguration config = null;
        if (group != null && (config = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getFilteredLastLaunch(group.getIdentifier())) != null) {
            this.launch(config, group.getMode(), isShift);
            return true;
        }
        return false;
    }

    @Deprecated
    protected void selectAndLaunch(IResource resource, ILaunchGroup group, IStructuredSelection selection) {
        this.selectAndLaunch(resource, group, selection, false);
    }

    protected void selectAndLaunch(IResource resource, ILaunchGroup group, IStructuredSelection selection, boolean isShift) {
        if (group != null) {
            LaunchConfigurationManager lcm = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
            String mode = group.getMode();
            List<LaunchShortcutExtension> shortcuts = this.fLRM.getShortcutsForSelection(selection, mode);
            IResource overrideResource = this.fLRM.getLaunchableResource(shortcuts, selection);
            if (overrideResource != null) {
                resource = overrideResource;
            }
            shortcuts = this.fLRM.pruneShortcuts(shortcuts, resource, mode);
            ILaunchConfiguration config = lcm.isSharedConfig(resource);
            if (config != null) {
                this.launch(config, mode, isShift);
                return;
            }
            List<ILaunchConfiguration> configs = this.fLRM.getParticipatingLaunchConfigurations(selection, resource, shortcuts, mode);
            int csize = configs.size();
            if (csize == 1) {
                this.launch(configs.get(0), mode, isShift);
            } else if (csize < 1) {
                int esize = shortcuts.size();
                if (esize == 1) {
                    this.launchShortcut(selection, shortcuts.get(0), mode, isShift);
                } else if (esize > 1) {
                    this.showShortcutSelectionDialog(resource, shortcuts, mode, selection, isShift);
                } else if (esize < 1) {
                    if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.LaunchLastIfNotLaunchable")) {
                        if (!this.launchLast(group, isShift)) {
                            MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)ContextMessages.ContextRunner_0, (String)ContextMessages.ContextRunner_7);
                        }
                    } else if (resource != null) {
                        IProject project = resource.getProject();
                        if (project != null && !project.equals((Object)resource)) {
                            this.selectAndLaunch((IResource)project, group, (IStructuredSelection)new StructuredSelection((Object)project), isShift);
                        } else {
                            String msg = ContextMessages.ContextRunner_7;
                            if (!resource.isAccessible()) {
                                msg = MessageFormat.format(ContextMessages.ContextRunner_13, resource.getName());
                            }
                            MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)ContextMessages.ContextRunner_0, (String)msg);
                        }
                    } else if (!this.launchLast(group, isShift)) {
                        MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)ContextMessages.ContextRunner_0, (String)ContextMessages.ContextRunner_7);
                    }
                }
            } else if (csize > 1) {
                config = lcm.getMRUConfiguration(configs, group, resource);
                if (config != null) {
                    this.launch(config, mode, isShift);
                } else {
                    this.showConfigurationSelectionDialog(configs, mode, isShift);
                }
            }
        }
    }

    private void launch(ILaunchConfiguration configuration, String mode, boolean isShift) {
        if (this.validateMode(configuration, mode)) {
            DebugUITools.launch(configuration, mode, isShift);
        }
    }

    private void launchShortcut(IStructuredSelection selection, LaunchShortcutExtension shortcut, String mode, boolean isShift) {
        Object o = selection.getFirstElement();
        if (o instanceof IEditorPart) {
            DebugUITools.storeLaunchToggleTerminate(o, isShift);
            shortcut.launch((IEditorPart)o, mode);
            DebugUITools.removeLaunchToggleTerminate(o);
        } else {
            DebugUITools.storeLaunchToggleTerminate(selection, new TerminateToggleValue(isShift, shortcut));
            shortcut.launch((ISelection)selection, mode);
            DebugUITools.removeLaunchToggleTerminate(selection);
        }
    }

    private boolean validateMode(ILaunchConfiguration configuration, String mode) {
        try {
            if (configuration.getModes().isEmpty() && !configuration.supportsMode(mode)) {
                ILaunchMode launchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(mode);
                if (launchMode == null) {
                    DebugUIPlugin.logErrorMessage("Unsupported launch mode: " + mode);
                } else {
                    String label = launchMode.getLabel();
                    String modeLabel = DebugUIPlugin.removeAccelerators(label);
                    MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)MessageFormat.format(ContextMessages.ContextRunner_1, modeLabel), (String)MessageFormat.format(ContextMessages.ContextRunner_3, configuration.getName(), modeLabel.toLowerCase()));
                }
                return false;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e.getStatus());
            return false;
        }
        return true;
    }

    @Deprecated(forRemoval=true, since="2023-12")
    protected void showConfigurationSelectionDialog(List<ILaunchConfiguration> configurations, String mode) {
        this.showConfigurationSelectionDialog(configurations, mode, false);
    }

    protected void showConfigurationSelectionDialog(List<ILaunchConfiguration> configurations, String mode, boolean isShift) {
        LaunchConfigurationSelectionDialog lsd = new LaunchConfigurationSelectionDialog(DebugUIPlugin.getShell(), configurations);
        if (lsd.open() == 0) {
            ILaunchConfiguration config = (ILaunchConfiguration)lsd.getResult()[0];
            this.launch(config, mode, isShift);
        }
    }

    @Deprecated(forRemoval=true, since="2023-12")
    protected void showShortcutSelectionDialog(IResource resource, List<LaunchShortcutExtension> shortcuts, String mode, IStructuredSelection selection) {
        this.showShortcutSelectionDialog(resource, shortcuts, mode, selection, false);
    }

    protected void showShortcutSelectionDialog(IResource resource, List<LaunchShortcutExtension> shortcuts, String mode, IStructuredSelection selection, boolean isShift) {
        LaunchShortcutExtension method;
        Object[] result;
        LaunchShortcutSelectionDialog dialog = new LaunchShortcutSelectionDialog(shortcuts, resource, mode);
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && (method = (LaunchShortcutExtension)result[0]) != null) {
            this.launchShortcut(selection, method, mode, isShift);
        }
    }
}

