/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.dialogs.filteredtree;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public abstract class BasicUIJob
extends Job {
    private final Display cachedDisplay;

    public BasicUIJob(String name, Display display) {
        super(name);
        this.cachedDisplay = display;
    }

    public final IStatus run(IProgressMonitor monitor) {
        Display asyncDisplay;
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Display display = asyncDisplay = this.cachedDisplay == null ? this.getDisplay() : this.cachedDisplay;
        if (asyncDisplay == null || asyncDisplay.isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        asyncDisplay.asyncExec(() -> {
            IStatus result = null;
            try {
                this.setThread(Thread.currentThread());
                result = monitor.isCanceled() ? Status.CANCEL_STATUS : this.runInUIThread(monitor);
            }
            catch (Throwable throwable) {
                this.done(result);
                throw throwable;
            }
            this.done(result);
        });
        return Job.ASYNC_FINISH;
    }

    public abstract IStatus runInUIThread(IProgressMonitor var1);

    public Display getDisplay() {
        return this.cachedDisplay != null ? this.cachedDisplay : Display.getCurrent();
    }
}

