/*
 * Copyright (c) 2014, 2015 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.oomph.setup;

/**
 * @author Eike Stepper
 */
public final class EAnnotationConstants
{
  public static final String ANNOTATION_NO_EXPAND = "http://www.eclipse.org/oomph/setup/NoExpand";

  public static final String ANNOTATION_REDIRECT = "http://www.eclipse.org/oomph/setup/Redirect";

  public static final String ANNOTATION_VALID_TRIGGERS = "http://www.eclipse.org/oomph/setup/ValidTriggers";

  public static final String KEY_TRIGGERS = "triggers";

  public static final String ANNOTATION_ENABLEMENT = "http://www.eclipse.org/oomph/setup/Enablement";

  public static final String KEY_VARIABLE_NAME = "variableName";

  public static final String KEY_REPOSITORY = "repository";

  public static final String KEY_INSTALLABLE_UNITS = "installableUnits";

  public static final String ANNOTATION_VARIABLE = "http://www.eclipse.org/oomph/setup/Variable";

  public static final String KEY_EXPLICIT_TYPE = "explicitType";

  public static final String KEY_EXPLICIT_LABEL = "explicitLabel";

  public static final String KEY_EXPLICIT_DESCRIPTION = "explicitDescription";

  public static final String ANNOTATION_RULE_VARIABLE = "http://www.eclipse.org/oomph/setup/RuleVariable";

  public static final String KEY_FILTER = "filter";

  public static final String KEY_TYPE = "type";

  public static final String KEY_NAME = "name";

  public static final String KEY_LABEL = "label";

  public static final String KEY_DESCRIPTION = "description";

  public static final String KEY_DEFAULT_VALUE = "defaultValue";

  public static final String KEY_VALUE = "value";

  public static final String KEY_STORAGE_URI = "storageURI";

  public static final String NESTED_ANNOTATION_CHOICE = "Choice";

  private EAnnotationConstants()
  {
  }
}
