/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLine;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StatusLineManager
extends ContributionManager
implements IStatusLineManager {
    public static final String BEGIN_GROUP = "BEGIN_GROUP";
    public static final String MIDDLE_GROUP = "MIDDLE_GROUP";
    public static final String END_GROUP = "END_GROUP";
    private Composite statusLine = null;

    public StatusLineManager() {
        this.add(new GroupMarker(BEGIN_GROUP));
        this.add(new GroupMarker(MIDDLE_GROUP));
        this.add(new GroupMarker(END_GROUP));
    }

    public Control createControl(Composite parent) {
        return this.createControl(parent, 0);
    }

    public Control createControl(Composite parent, int style) {
        if (!this.statusLineExist() && parent != null) {
            this.statusLine = new StatusLine(parent, style);
            this.update(false);
        }
        return this.statusLine;
    }

    public void dispose() {
        IContributionItem[] items;
        if (this.statusLineExist()) {
            this.statusLine.dispose();
        }
        this.statusLine = null;
        IContributionItem[] iContributionItemArray = items = this.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            item.dispose();
            ++n2;
        }
    }

    public Control getControl() {
        return this.statusLine;
    }

    protected IProgressMonitor getProgressMonitorDelegate() {
        return (IProgressMonitor)this.getControl();
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        final IProgressMonitor progressDelegate = this.statusLineExist() ? this.getProgressMonitorDelegate() : new NullProgressMonitor();
        return new IProgressMonitor(){
            private volatile Exception taskStarted;

            public void beginTask(String name, int totalWork) {
                if (this.taskStarted != null) {
                    IllegalStateException e = new IllegalStateException("beginTask should only be called once per instance. At least call done() before further invocations", this.taskStarted);
                    Policy.getLog().log((IStatus)Status.warning((String)e.getLocalizedMessage(), (Throwable)e));
                    this.done();
                }
                this.taskStarted = new IllegalStateException("beginTask(" + name + ", " + totalWork + ") was called here previously");
                progressDelegate.beginTask(name, totalWork);
            }

            public void done() {
                if (this.taskStarted == null) {
                    return;
                }
                this.taskStarted = null;
                progressDelegate.done();
            }

            public void internalWorked(double work) {
                progressDelegate.internalWorked(work);
            }

            public boolean isCanceled() {
                return progressDelegate.isCanceled();
            }

            public void setCanceled(boolean value) {
                if (StatusLineManager.this.statusLineExist()) {
                    progressDelegate.setCanceled(value);
                }
            }

            public void setTaskName(String name) {
                progressDelegate.setTaskName(name);
            }

            public void subTask(String name) {
                progressDelegate.subTask(name);
            }

            public void worked(int work) {
                if (this.taskStarted == null) {
                    IllegalStateException e = new IllegalStateException("call to beginTask() missing");
                    Policy.getLog().log((IStatus)Status.warning((String)e.getLocalizedMessage(), (Throwable)e));
                }
                progressDelegate.worked(work);
            }

            public void clearBlocked() {
            }

            public void setBlocked(IStatus reason) {
            }
        };
    }

    @Override
    public boolean isCancelEnabled() {
        return this.statusLineExist() && ((StatusLine)this.statusLine).isCancelEnabled();
    }

    @Override
    public void setCancelEnabled(boolean enabled) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setCancelEnabled(enabled);
        }
    }

    @Override
    public void setErrorMessage(String message) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setErrorMessage(message);
        }
    }

    @Override
    public void setErrorMessage(Image image, String message) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setErrorMessage(image, message);
        }
    }

    @Override
    public void setMessage(String message) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setMessage(message);
        }
    }

    @Override
    public void setMessage(Image image, String message) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setMessage(image, message);
        }
    }

    private boolean statusLineExist() {
        return this.statusLine != null && !this.statusLine.isDisposed();
    }

    @Override
    public void update(boolean force) {
        if ((this.isDirty() || force) && this.statusLineExist()) {
            IContributionItem[] items;
            Control[] ws;
            this.statusLine.setRedraw(false);
            Control[] controlArray = ws = this.statusLine.getChildren();
            int n = ws.length;
            int n2 = 0;
            while (n2 < n) {
                Control w = controlArray[n2];
                Object data = w.getData();
                if (data instanceof IContributionItem) {
                    w.dispose();
                }
                ++n2;
            }
            int oldChildCount = this.statusLine.getChildren().length;
            IContributionItem[] iContributionItemArray = items = this.getItems();
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                IContributionItem ci = iContributionItemArray[n4];
                if (ci.isVisible()) {
                    ci.fill(this.statusLine);
                    Control[] newChildren = this.statusLine.getChildren();
                    int j = oldChildCount;
                    while (j < newChildren.length) {
                        newChildren[j].setData((Object)ci);
                        ++j;
                    }
                    oldChildCount = newChildren.length;
                }
                ++n4;
            }
            this.setDirty(false);
            this.statusLine.requestLayout();
            this.statusLine.setRedraw(true);
        }
    }
}

