/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.win32.OS;

public class Pattern
extends Resource {
    private int initialZoom;
    private Runnable bitmapDestructor;
    private final Image image;
    private float baseX1;
    private float baseY1;
    private float baseX2;
    private float baseY2;
    private Color color1;
    private Color color2;
    private int alpha1;
    private int alpha2;
    private final Map<Integer, Long> zoomLevelToHandle = new HashMap<Integer, Long>();

    public Pattern(Device device, Image image) {
        super(device);
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.device.checkGDIP();
        this.image = image;
        this.initialZoom = DPIUtil.getDeviceZoom();
        this.setImageHandle(image, this.initialZoom);
        this.init();
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, Color color2) {
        this(device, x1, y1, x2, y2, color1, 255, color2, 255);
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, int alpha1, Color color2, int alpha2) {
        super(device);
        this.baseX1 = x1;
        this.baseX2 = x2;
        this.baseY1 = y1;
        this.baseY2 = y2;
        this.color1 = color1;
        this.color2 = color2;
        this.alpha1 = alpha1;
        this.alpha2 = alpha2;
        this.image = null;
        this.initialZoom = DPIUtil.getDeviceZoom();
        this.initializeSize(this.initialZoom);
    }

    long getHandle(int zoom) {
        if (!this.zoomLevelToHandle.containsKey(zoom)) {
            if (this.isImagePattern()) {
                this.setImageHandle(this.image, zoom);
            } else {
                this.initializeSize(zoom);
            }
        }
        return this.zoomLevelToHandle.get(zoom);
    }

    private void initializeSize(int zoom) {
        long handle;
        float x1 = DPIUtil.scaleUp(this.baseX1, zoom);
        float y1 = DPIUtil.scaleUp(this.baseY1, zoom);
        float x2 = DPIUtil.scaleUp(this.baseX2, zoom);
        float y2 = DPIUtil.scaleUp(this.baseY2, zoom);
        if (this.color1 == null) {
            SWT.error(4);
        }
        if (this.color1.isDisposed()) {
            SWT.error(5);
        }
        if (this.color2 == null) {
            SWT.error(4);
        }
        if (this.color2.isDisposed()) {
            SWT.error(5);
        }
        this.device.checkGDIP();
        int colorRef1 = this.color1.handle;
        int foreColor = (this.alpha1 & 0xFF) << 24 | colorRef1 >> 16 & 0xFF | colorRef1 & 0xFF00 | (colorRef1 & 0xFF) << 16;
        if (x1 == x2 && y1 == y2) {
            handle = Gdip.SolidBrush_new(foreColor);
            if (handle == 0L) {
                SWT.error(2);
            }
        } else {
            int colorRef2 = this.color2.handle;
            int backColor = (this.alpha2 & 0xFF) << 24 | colorRef2 >> 16 & 0xFF | colorRef2 & 0xFF00 | (colorRef2 & 0xFF) << 16;
            PointF p1 = new PointF();
            p1.X = x1;
            p1.Y = y1;
            PointF p2 = new PointF();
            p2.X = x2;
            p2.Y = y2;
            handle = Gdip.LinearGradientBrush_new(p1, p2, foreColor, backColor);
            if (handle == 0L) {
                SWT.error(2);
            }
            if (this.alpha1 != 255 || this.alpha2 != 255) {
                int a = (int)((float)(this.alpha1 & 0xFF) * 0.5f + (float)(this.alpha2 & 0xFF) * 0.5f);
                int r = (int)((float)((colorRef1 & 0xFF) >> 0) * 0.5f + (float)((colorRef2 & 0xFF) >> 0) * 0.5f);
                int g = (int)((float)((colorRef1 & 0xFF00) >> 8) * 0.5f + (float)((colorRef2 & 0xFF00) >> 8) * 0.5f);
                int b = (int)((float)((colorRef1 & 0xFF0000) >> 16) * 0.5f + (float)((colorRef2 & 0xFF0000) >> 16) * 0.5f);
                int midColor = a << 24 | r << 16 | g << 8 | b;
                Gdip.LinearGradientBrush_SetInterpolationColors(handle, new int[]{foreColor, midColor, backColor}, new float[]{0.0f, 0.5f, 1.0f}, 3);
            }
        }
        this.zoomLevelToHandle.put(zoom, handle);
        this.init();
    }

    void setImageHandle(Image image, int zoom) {
        long[] gdipImage = image.createGdipImage(zoom);
        long img = gdipImage[0];
        int width = Gdip.Image_GetWidth(img);
        int height = Gdip.Image_GetHeight(img);
        long handle = Gdip.TextureBrush_new(img, 0, 0.0f, 0.0f, width, height);
        this.bitmapDestructor = () -> {
            Gdip.Bitmap_delete(img);
            if (gdipImage[1] != 0L) {
                long hHeap = OS.GetProcessHeap();
                OS.HeapFree(hHeap, 0, gdipImage[1]);
            }
        };
        if (handle == 0L) {
            this.bitmapDestructor.run();
            SWT.error(2);
        } else {
            this.zoomLevelToHandle.put(zoom, handle);
        }
    }

    @Override
    void destroy() {
        for (long handle : this.zoomLevelToHandle.values()) {
            int type = Gdip.Brush_GetType(handle);
            switch (type) {
                case 0: {
                    Gdip.SolidBrush_delete(handle);
                    break;
                }
                case 1: {
                    Gdip.HatchBrush_delete(handle);
                    break;
                }
                case 4: {
                    Gdip.LinearGradientBrush_delete(handle);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_delete(handle);
                }
            }
        }
        this.zoomLevelToHandle.clear();
        if (this.bitmapDestructor != null) {
            this.bitmapDestructor.run();
            this.bitmapDestructor = null;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.zoomLevelToHandle.isEmpty();
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {" + String.valueOf(this.zoomLevelToHandle) + "}";
    }

    private boolean isImagePattern() {
        return this.image != null;
    }
}

