/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.notifications;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.notifications.internal.AnimationUtil;
import org.eclipse.jface.notifications.internal.CommonImages;
import org.eclipse.jface.notifications.internal.Messages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractNotificationPopup
extends Window {
    static final int TITLE_HEIGHT = 24;
    private static final String LABEL_NOTIFICATION = Messages.AbstractNotificationPopup_Label;
    private static final String LABEL_JOB_CLOSE = Messages.AbstractNotificationPopup_CloseJobTitle;
    private static final int MAX_WIDTH = 400;
    private static final int MIN_HEIGHT = 100;
    private static final long DEFAULT_DELAY_CLOSE = 8000L;
    private static final int PADDING_EDGE = 5;
    private long delayClose = 8000L;
    protected LocalResourceManager resources;
    private final Display display;
    private Shell shell;
    private final Job closeJob = new Job(LABEL_JOB_CLOSE){

        protected IStatus run(IProgressMonitor monitor) {
            if (!AbstractNotificationPopup.this.display.isDisposed()) {
                AbstractNotificationPopup.this.display.asyncExec(() -> {
                    Shell shell = AbstractNotificationPopup.this.getShell();
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    if (AbstractNotificationPopup.this.isMouseOver(shell)) {
                        AbstractNotificationPopup.this.scheduleAutoClose();
                        return;
                    }
                    AbstractNotificationPopup.this.closeFade();
                });
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };
    private AnimationUtil.FadeJob fadeJob;
    private boolean fadingEnabled;
    private MouseListener windowActivationHelper;

    public AbstractNotificationPopup(Display display) {
        this(display, 16396);
    }

    public AbstractNotificationPopup(Display display, int style) {
        super(null);
        this.setShellStyle(style);
        this.display = display;
        this.resources = new LocalResourceManager(JFaceResources.getResources());
        this.closeJob.setSystem(true);
    }

    protected void setParentShell(Shell newParentShell) {
        super.setParentShell(newParentShell);
        this.windowActivationHelper = this.createWindowActivationHelper(newParentShell);
    }

    protected MouseListener createWindowActivationHelper(final Shell parentShell) {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (parentShell != null) {
                    parentShell.setActive();
                    parentShell.moveAbove(null);
                }
            }
        };
    }

    public boolean isFadingEnabled() {
        return this.fadingEnabled;
    }

    public void setFadingEnabled(boolean fadingEnabled) {
        this.fadingEnabled = fadingEnabled;
    }

    public void create() {
        super.create();
    }

    public int open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
        }
        this.constrainShellSize();
        if (this.isFadingEnabled()) {
            this.shell.setAlpha(0);
        }
        this.shell.setVisible(true);
        this.fadeJob = AnimationUtil.fadeIn(this.shell, (shell, alpha) -> {
            if (shell.isDisposed()) {
                return;
            }
            if (alpha == 255) {
                this.scheduleAutoClose();
            }
        });
        return 0;
    }

    public boolean close() {
        this.resources.dispose();
        return super.close();
    }

    public long getDelayClose() {
        return this.delayClose;
    }

    public void setDelayClose(long delayClose) {
        this.delayClose = delayClose;
    }

    public void closeFade() {
        if (this.fadeJob != null) {
            this.fadeJob.cancelAndWait(false);
        }
        this.fadeJob = AnimationUtil.fadeOut(this.getShell(), (shell, alpha) -> {
            if (!shell.isDisposed()) {
                if (alpha == 0) {
                    shell.close();
                } else if (this.isMouseOver(shell)) {
                    if (this.fadeJob != null) {
                        this.fadeJob.cancelAndWait(false);
                    }
                    this.fadeJob = AnimationUtil.fastFadeIn(shell, (shell1, alpha1) -> {
                        if (shell1.isDisposed()) {
                            return;
                        }
                        if (alpha1 == 255) {
                            this.scheduleAutoClose();
                        }
                    });
                }
            }
        });
    }

    protected String getPopupShellTitle() {
        String productName = AbstractNotificationPopup.getProductName();
        if (productName != null) {
            return String.valueOf(productName) + " " + LABEL_NOTIFICATION;
        }
        return LABEL_NOTIFICATION;
    }

    protected Image getPopupShellImage(int maximumHeight) {
        return null;
    }

    protected void createContentArea(Composite parent) {
    }

    protected void createTitleArea(Composite parent) {
        ((GridData)parent.getLayoutData()).heightHint = 24;
        Label titleImageLabel = new Label(parent, 0);
        titleImageLabel.setImage(this.getPopupShellImage(24));
        Label titleTextLabel = new Label(parent, 0);
        titleTextLabel.setText(this.getPopupShellTitle());
        titleTextLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        titleTextLabel.setForeground(this.getTitleForeground());
        titleTextLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        titleTextLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        this.createCloseButton(parent);
        this.addWindowActivationHelper((Control)titleTextLabel);
    }

    void createCloseButton(Composite parent) {
        final Label button = new Label(parent, 0);
        button.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CLOSE));
        button.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                button.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CLOSE_HOVER));
            }

            public void mouseExit(MouseEvent e) {
                button.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CLOSE));
            }
        });
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                AbstractNotificationPopup.this.close();
                AbstractNotificationPopup.this.setReturnCode(1);
            }
        });
    }

    protected Color getTitleForeground() {
        return this.display.getSystemColor(17);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.shell = newShell;
    }

    protected void scheduleAutoClose() {
        if (this.delayClose > 0L) {
            this.closeJob.schedule(this.delayClose);
        }
    }

    protected void addWindowActivationHelper(Control control) {
        if (this.windowActivationHelper != null) {
            control.addMouseListener(this.windowActivationHelper);
        }
    }

    protected Control createContents(Composite parent) {
        ((GridLayout)parent.getLayout()).marginWidth = 1;
        ((GridLayout)parent.getLayout()).marginHeight = 1;
        Composite outerCircle = new Composite(parent, 524288);
        outerCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        outerCircle.setLayout((Layout)layout);
        Composite titleCircle = new Composite(outerCircle, 524288);
        titleCircle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        layout = new GridLayout(4, false);
        layout.marginWidth = 3;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 3;
        titleCircle.setLayout((Layout)layout);
        this.createTitleArea(titleCircle);
        Composite outerContentCircle = new Composite(outerCircle, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        outerContentCircle.setLayout((Layout)layout);
        outerContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite middleContentCircle = new Composite(outerContentCircle, 524288);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 1;
        middleContentCircle.setLayout((Layout)layout);
        middleContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite innerContent = new Composite(middleContentCircle, 524288);
        innerContent.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        innerContent.setLayout((Layout)layout);
        innerContent.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.createContentArea(innerContent);
        this.addWindowActivationHelper((Control)innerContent);
        return outerCircle;
    }

    protected void initializeBounds() {
        Rectangle clArea = this.getPrimaryClientArea();
        Point initialSize = this.shell.computeSize(-1, -1);
        int height = Math.max(initialSize.y, 100);
        int width = Math.min(initialSize.x, 400);
        Point size = new Point(width, height);
        this.shell.setLocation(clArea.width + clArea.x - size.x - 5, clArea.height + clArea.y - size.y - 5);
        this.shell.setSize(size);
    }

    private static String getProductName() {
        String productName;
        IProduct product = Platform.getProduct();
        if (product != null && (productName = product.getName()) != null) {
            String LABEL_SDK = "SDK";
            if (productName.endsWith(LABEL_SDK)) {
                productName = productName.substring(0, productName.length() - LABEL_SDK.length()).trim();
            }
            return productName;
        }
        return null;
    }

    private boolean isMouseOver(Shell shell) {
        if (this.display.isDisposed()) {
            return false;
        }
        return shell.getBounds().contains(this.display.getCursorLocation());
    }

    private Rectangle getPrimaryClientArea() {
        Shell parentShell = this.getParentShell();
        if (parentShell != null) {
            Rectangle bounds = parentShell.getBounds();
            Rectangle trim = parentShell.computeTrim(0, 0, 0, 0);
            return new Rectangle(bounds.x - trim.x, bounds.y - trim.y, bounds.width - trim.width, bounds.height - trim.height);
        }
        Monitor primaryMonitor = this.shell.getDisplay().getPrimaryMonitor();
        return primaryMonitor != null ? primaryMonitor.getClientArea() : this.shell.getDisplay().getClientArea();
    }
}

