/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool
extends ThreadPoolExecutor {
    private static final int THREAD_COUNT = Runtime.getRuntime().availableProcessors() * 4;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    };
    private final Object lock = new Object();
    private int executingTasks;

    public ThreadPool() {
        super(THREAD_COUNT, THREAD_COUNT, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable command) {
        Object object = this.lock;
        synchronized (object) {
            ++this.executingTasks;
        }
        super.execute(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterExecute(Runnable command, Throwable t) {
        Object object = this.lock;
        synchronized (object) {
            if (--this.executingTasks == 0) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitFinished() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.executingTasks != 0) {
                this.lock.wait();
            }
        }
    }
}

