/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.core.ExternalFoldersManager;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.ITargletContainerDescriptor;
import org.eclipse.oomph.targlets.core.TargletContainerEvent;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;
import org.eclipse.oomph.targlets.internal.core.Messages;
import org.eclipse.oomph.targlets.internal.core.TargletContainerListenerRegistry;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.pde.TargetPlatformListener;
import org.eclipse.oomph.util.pde.TargetPlatformRunnable;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkspaceIUImporter {
    public static final WorkspaceIUImporter INSTANCE = new WorkspaceIUImporter();
    public static final Object WORKSPACE_IU_IMPORT_FAMILY = new Object();
    private final TargetPlatformListener listener = new TargetPlatformListener(){

        public void targetDefinitionActivated(ITargetDefinition oldTargetDefinition, ITargetDefinition newTargetDefinition) throws Exception {
            if (newTargetDefinition != null) {
                ImportProjectsJob job = new ImportProjectsJob();
                job.schedule();
            }
        }
    };

    private WorkspaceIUImporter() {
    }

    public void updateWorkspace(final IProgressMonitor monitor) throws CoreException {
        TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<Object>(){

            public Object run(ITargetPlatformService service) throws CoreException {
                ITargetLocation[] targetLocations;
                HashSet<WorkspaceIUInfo> workspaceIUInfos = new HashSet<WorkspaceIUInfo>();
                ArrayList<Pair> targletContainerInfos = new ArrayList<Pair>();
                ITargetDefinition targetDefinition = TargetPlatformUtil.getActiveTargetDefinition((ITargetPlatformService)service);
                if (targetDefinition != null && (targetLocations = targetDefinition.getTargetLocations()) != null) {
                    ITargetLocation[] iTargetLocationArray = targetLocations;
                    int n = targetLocations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITargletContainer container;
                        ITargletContainerDescriptor descriptor;
                        ITargetLocation location = iTargetLocationArray[n2];
                        if (location instanceof ITargletContainer && (descriptor = (container = (ITargletContainer)location).getDescriptor()) != null && descriptor.getUpdateProblem() == null) {
                            targletContainerInfos.add(Pair.create((Object)container, (Object)descriptor));
                            Collection<WorkspaceIUInfo> workingProjects = descriptor.getWorkingProjects();
                            if (workingProjects != null) {
                                workspaceIUInfos.addAll(workingProjects);
                            }
                        }
                        ++n2;
                    }
                }
                Map importResults = workspaceIUInfos.isEmpty() ? new HashMap() : WorkspaceIUImporter.this.updateWorkspace(workspaceIUInfos, monitor);
                for (Pair pair : targletContainerInfos) {
                    ITargletContainer container = (ITargletContainer)pair.getElement1();
                    ITargletContainerDescriptor descriptor = (ITargletContainerDescriptor)pair.getElement2();
                    HashMap<WorkspaceIUInfo, ResourcesUtil.ImportResult> containerImportResults = new HashMap<WorkspaceIUInfo, ResourcesUtil.ImportResult>();
                    Collection<WorkspaceIUInfo> workingProjects = descriptor.getWorkingProjects();
                    if (workingProjects != null) {
                        containerImportResults.putAll(importResults);
                        containerImportResults.keySet().retainAll(workingProjects);
                    }
                    TargletContainerEvent.WorkspaceUpdateFinishedEvent event = new TargletContainerEvent.WorkspaceUpdateFinishedEvent(container, descriptor, containerImportResults);
                    TargletContainerListenerRegistry.INSTANCE.notifyListeners(event, monitor);
                }
                return null;
            }
        });
    }

    private Map<WorkspaceIUInfo, ResourcesUtil.ImportResult> updateWorkspace(final Set<WorkspaceIUInfo> workspaceIUInfos, IProgressMonitor monitor) throws CoreException {
        final HashMap<WorkspaceIUInfo, ResourcesUtil.ImportResult> importResults = new HashMap<WorkspaceIUInfo, ResourcesUtil.ImportResult>();
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ExternalFoldersManager externalFoldersManager = ExternalFoldersManager.getExternalFoldersManager();
                IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getExternalModels();
                int n = iPluginModelBaseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginModelBase pluginModelBase = iPluginModelBaseArray[n2];
                    String installLocation = pluginModelBase.getInstallLocation();
                    if (installLocation != null && new File(installLocation).isDirectory()) {
                        externalFoldersManager.createLinkFolder((IPath)new Path(installLocation), false, null);
                    }
                    ++n2;
                }
                for (WorkspaceIUInfo info : workspaceIUInfos) {
                    ResourcesUtil.ImportResult result = info.importIntoWorkspace(monitor);
                    importResults.put(info, result);
                }
            }
        }, monitor);
        return importResults;
    }

    void start() {
        TargetPlatformUtil.addListener((TargetPlatformListener)this.listener);
    }

    void stop() {
        TargetPlatformUtil.removeListener((TargetPlatformListener)this.listener);
    }

    private static final class ImportProjectsJob
    extends Job {
        private ImportProjectsJob() {
            super(Messages.WorkspaceIUImporter_Imports_job);
        }

        public boolean belongsTo(Object family) {
            return family == WORKSPACE_IU_IMPORT_FAMILY;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                INSTANCE.updateWorkspace(monitor);
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                return TargletsCorePlugin.INSTANCE.getStatus(ex);
            }
        }
    }
}

