/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import com.ibm.icu.lang.UCharacter;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.qvt.oml.util.ISessionData;
import org.eclipse.ocl.types.OCLStandardLibrary;

public class StringOperations
extends AbstractContextualOperations {
    static final String LENGTH_NAME = "length";
    static final String SUBSTRING_BEFORE_NAME = "substringBefore";
    static final String SUBSTRING_AFTER_NAME = "substringAfter";
    static final String FIRST_TO_UPPER_NAME = "firstToUpper";
    static final String LAST_TO_UPPER_NAME = "lastToUpper";
    static final String NORMALIZE_SPACE_NAME = "normalizeSpace";
    static final String REPLACE_NAME = "replace";
    static final String MATCH_NAME = "match";
    static final String FIND_NAME = "find";
    static final String RFIND_NAME = "rfind";
    static final String IS_QUOTED_NAME = "isQuoted";
    static final String QUOTIFY_NAME = "quotify";
    static final String UNQUOTIFY_NAME = "unquotify";
    static final String MATCH_BOOLEAN_NAME = "matchBoolean";
    static final String MATCH_INTEGER_NAME = "matchInteger";
    static final String MATCH_FLOAT_NAME = "matchFloat";
    static final String MATCH_IDENTIFIER_NAME = "matchIdentifier";
    static final String AS_BOOLEAN_NAME = "asBoolean";
    static final String AS_INTEGER_NAME = "asInteger";
    static final String AS_FLOAT_NAME = "asFloat";
    static final String START_STR_COUNTER_NAME = "startStrCounter";
    static final String GET_STR_COUNTER_NAME = "getStrCounter";
    static final String INCR_STR_COUNTER_NAME = "incrStrCounter";
    static final String RESTART_ALL_STR_COUNTER_NAME = "restartAllStrCounter";
    static final String ADD_SUFFIX_NUMBER_NAME = "addSuffixNumber";
    static final CallHandler LENGTH = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            return ((String)source).length();
        }
    };
    static final CallHandler SUBSTRING_BEFORE = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return CallHandlerAdapter.getInvalidResult(evalEnv);
            }
            String self = (String)source;
            String arg = (String)leftVal;
            int pos = self.indexOf(arg);
            if (pos < 0) {
                return null;
            }
            return self.substring(0, pos);
        }
    };
    static final CallHandler SUBSTRING_AFTER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return CallHandlerAdapter.getInvalidResult(evalEnv);
            }
            String self = (String)source;
            String arg = (String)leftVal;
            int pos = self.indexOf(arg);
            if (pos < 0) {
                return null;
            }
            return self.substring(pos + arg.length());
        }
    };
    static final CallHandler FIRST_TO_UPPER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            String self = (String)source;
            if (self.length() == 0) {
                return self;
            }
            StringBuilder buf = new StringBuilder(self);
            buf.setCharAt(0, Character.toUpperCase(self.charAt(0)));
            return buf.toString();
        }
    };
    static final CallHandler LAST_TO_UPPER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            String self = (String)source;
            if (self.length() == 0) {
                return self;
            }
            StringBuilder buf = new StringBuilder(self);
            int lastPos = self.length() - 1;
            buf.setCharAt(lastPos, Character.toUpperCase(self.charAt(lastPos)));
            return buf.toString();
        }
    };
    static final CallHandler NORMALIZE = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            String self = (String)source;
            self = self.trim();
            StringBuilder buf = new StringBuilder(self.length());
            boolean isWhiteArea = false;
            int i = 0;
            while (i < self.length()) {
                char c = self.charAt(i);
                if (UCharacter.isWhitespace((int)c)) {
                    if (!isWhiteArea) {
                        isWhiteArea = true;
                        buf.append(c);
                    }
                } else {
                    isWhiteArea = false;
                    buf.append(c);
                }
                ++i;
            }
            return buf.toString();
        }
    };
    static final CallHandler REPLACE = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            String self = (String)source;
            Object arg0 = args[0];
            if (arg0 == null && arg0 == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return self;
            }
            Object arg1 = args[1];
            if (arg1 == null && arg1 == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return CallHandlerAdapter.getInvalidResult(evalEnv);
            }
            return self.replace((String)arg0, (String)arg1);
        }
    };
    static final CallHandler MATCH = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            String self = (String)source;
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return false;
            }
            return Pattern.matches((String)leftVal, self);
        }
    };
    static final CallHandler FIND = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            String self = (String)source;
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return -1;
            }
            return self.indexOf((String)leftVal) + 1;
        }
    };
    static final CallHandler RFIND = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            String self = (String)source;
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return -1;
            }
            return self.lastIndexOf((String)leftVal) + 1;
        }
    };
    static final CallHandler IS_QUOTED = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return false;
            }
            String quoteStr = (String)leftVal;
            String self = (String)source;
            return self.length() >= quoteStr.length() * 2 && self.startsWith(quoteStr) && self.endsWith(quoteStr);
        }
    };
    static final CallHandler QUOTIFY = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return source;
            }
            String quoteStr = (String)leftVal;
            String self = (String)source;
            return String.valueOf(quoteStr) + self + quoteStr;
        }
    };
    static final CallHandler UNQUOTIFY = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!Boolean.TRUE.equals(IS_QUOTED.invoke(module, source, args, evalEnv))) {
                return source;
            }
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return false;
            }
            String quoteStr = (String)leftVal;
            String self = (String)source;
            return self.substring(quoteStr.length(), self.length() - quoteStr.length());
        }
    };
    static final CallHandler MATCH_BOOLEAN = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return false;
            }
            Boolean arg = (Boolean)leftVal;
            Object self = AS_BOOLEAN.invoke(module, source, args, evalEnv);
            return arg.equals(self);
        }
    };
    static final CallHandler MATCH_INTEGER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return false;
            }
            Integer arg = (Integer)leftVal;
            Object self = AS_INTEGER.invoke(module, source, args, evalEnv);
            return arg.equals(self);
        }
    };
    static final CallHandler MATCH_FLOAT = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return false;
            }
            Number arg = (Number)leftVal;
            Object self = AS_FLOAT.invoke(module, source, args, evalEnv);
            if (self != null) {
                if (arg.doubleValue() == ((Number)self).doubleValue()) {
                    return true;
                }
                return false;
            }
            return false;
        }
    };
    static final CallHandler MATCH_IDENTIFIER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return false;
            }
            String self = (String)source;
            int i = 0;
            while (i < self.length()) {
                char c = self.charAt(i);
                if (i == 0 && !UCharacter.isLetter((int)c) || !UCharacter.isLetterOrDigit((int)c)) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            return Boolean.TRUE;
        }
    };
    static final CallHandler AS_BOOLEAN = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            String self = (String)source;
            if (self.equals("1") || self.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (self.equals("0") || self.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            return null;
        }
    };
    static final CallHandler AS_INTEGER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            String self = (String)source;
            Integer result = null;
            try {
                result = Integer.valueOf(self);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return result;
        }
    };
    static final CallHandler AS_FLOAT = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            String self = (String)source;
            Double result = null;
            try {
                result = Double.valueOf(self);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return result;
        }
    };
    static final CallHandler START_STR_COUNTER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return false;
            }
            String counterName = (String)leftVal;
            StringCounter.getInstance(evalEnv).start(counterName);
            return null;
        }
    };
    static final CallHandler GET_STR_COUNTER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return false;
            }
            String counterName = (String)leftVal;
            return StringCounter.getInstance(evalEnv).value(counterName);
        }
    };
    static final CallHandler INCR_STR_COUNTER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                return false;
            }
            String counterName = (String)leftVal;
            return StringCounter.getInstance(evalEnv).increment(counterName);
        }
    };
    static final CallHandler RESTART_ALL_STR_COUNTER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            StringCounter.getInstance(evalEnv).restartAll();
            return null;
        }
    };
    static final CallHandler ADD_SUFFIX_NUMBER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            String self = (String)source;
            StringCounter counters = StringCounter.getInstance(evalEnv);
            Integer currentValue = counters.value(self);
            if (currentValue == null) {
                counters.start(self);
                return self;
            }
            counters.increment(self);
            return String.valueOf(self) + currentValue.toString();
        }
    };

    public StringOperations(AbstractQVTStdlib library) {
        super(library, (EClassifier)library.getEnvironment().getOCLStandardLibrary().getString());
    }

    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        OCLStandardLibrary<EClassifier> oclStdlib = this.getStdlib().getOCLStdLib();
        return new AbstractContextualOperations.OperationProvider[]{(AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(ADD_SUFFIX_NUMBER, ADD_SUFFIX_NUMBER_NAME, (EClassifier)oclStdlib.getString(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_BOOLEAN, AS_BOOLEAN_NAME, (EClassifier)oclStdlib.getBoolean(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_FLOAT, AS_FLOAT_NAME, (EClassifier)oclStdlib.getReal(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_INTEGER, AS_INTEGER_NAME, (EClassifier)oclStdlib.getInteger(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(FIND, FIND_NAME, new String[]{MATCH_NAME}, (EClassifier)oclStdlib.getInteger(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(FIRST_TO_UPPER, FIRST_TO_UPPER_NAME, (EClassifier)oclStdlib.getString(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(UNSUPPORTED_OPER, "format", new String[]{"value"}, (EClassifier)oclStdlib.getString(), this.getStdlib().getObject()), this.createStaticOperationProvider(GET_STR_COUNTER, GET_STR_COUNTER_NAME, new String[]{"s"}, (EClassifier)oclStdlib.getInteger(), (EClassifier)oclStdlib.getString()), this.createStaticOperationProvider(INCR_STR_COUNTER, INCR_STR_COUNTER_NAME, new String[]{"s"}, (EClassifier)oclStdlib.getInteger(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(IS_QUOTED, IS_QUOTED_NAME, new String[]{"s"}, (EClassifier)oclStdlib.getBoolean(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(LAST_TO_UPPER, LAST_TO_UPPER_NAME, (EClassifier)oclStdlib.getString(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(LENGTH, LENGTH_NAME, (EClassifier)oclStdlib.getInteger(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(MATCH, MATCH_NAME, new String[]{"matchPattern"}, (EClassifier)oclStdlib.getBoolean(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(MATCH_BOOLEAN, MATCH_BOOLEAN_NAME, new String[]{"b"}, (EClassifier)oclStdlib.getBoolean(), (EClassifier)oclStdlib.getBoolean()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(MATCH_FLOAT, MATCH_FLOAT_NAME, new String[]{"r"}, (EClassifier)oclStdlib.getBoolean(), (EClassifier)oclStdlib.getReal()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(MATCH_IDENTIFIER, MATCH_IDENTIFIER_NAME, new String[]{"s"}, (EClassifier)oclStdlib.getBoolean(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(MATCH_INTEGER, MATCH_INTEGER_NAME, new String[]{"s"}, (EClassifier)oclStdlib.getBoolean(), (EClassifier)oclStdlib.getInteger()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(NORMALIZE, NORMALIZE_SPACE_NAME, (EClassifier)oclStdlib.getString(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(REPLACE, REPLACE_NAME, new String[]{"m1", "m2"}, (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString()), this.createStaticOperationProvider(RESTART_ALL_STR_COUNTER, RESTART_ALL_STR_COUNTER_NAME, null, (EClassifier)oclStdlib.getOclVoid(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(RFIND, RFIND_NAME, new String[]{MATCH_NAME}, (EClassifier)oclStdlib.getInteger(), (EClassifier)oclStdlib.getString()), this.createStaticOperationProvider(START_STR_COUNTER, START_STR_COUNTER_NAME, new String[]{"s"}, (EClassifier)oclStdlib.getOclVoid(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(SUBSTRING_AFTER, SUBSTRING_AFTER_NAME, new String[]{MATCH_NAME}, (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(SUBSTRING_BEFORE, SUBSTRING_BEFORE_NAME, new String[]{MATCH_NAME}, (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(QUOTIFY, QUOTIFY_NAME, new String[]{"s"}, (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(UNQUOTIFY, UNQUOTIFY_NAME, new String[]{"s"}, (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString())};
    }

    private static class CounterValue {
        int value;

        CounterValue() {
            this.reset();
        }

        int increment() {
            return ++this.value;
        }

        void reset() {
            this.value = 0;
        }
    }

    private static class StringCounter {
        static final ISessionData.SimpleEntry<StringCounter> DATA_KEY = new ISessionData.SimpleEntry();
        HashMap<String, CounterValue> counters = new HashMap();

        private StringCounter() {
        }

        static StringCounter getInstance(QvtOperationalEvaluationEnv env) {
            env.getThisOfType(QvtOperationalStdLibrary.INSTANCE.getStdLibModule());
            StringCounter counters = env.getContext().getSessionData().getValue(DATA_KEY);
            if (counters == null) {
                counters = new StringCounter();
                env.getContext().getSessionData().setValue(DATA_KEY, counters);
            }
            return counters;
        }

        void restartAll() {
            for (CounterValue nextCounter : this.counters.values()) {
                nextCounter.reset();
            }
        }

        CounterValue get(String key, boolean onDemandCreate) {
            CounterValue value = this.counters.get(key);
            if (value == null && onDemandCreate) {
                value = new CounterValue();
                this.counters.put(key, value);
            }
            return value;
        }

        void start(String key) {
            this.get(key, true).reset();
        }

        int increment(String key) {
            return this.get(key, true).increment();
        }

        Integer value(String key) {
            CounterValue counterValue = this.get(key, false);
            if (counterValue != null) {
                return counterValue.value;
            }
            return null;
        }
    }
}

