/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.InternalTransformationExecutor;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.expressions.Constructor;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui.NodeCoverageModel;
import org.eclipse.ocl.ecore.OCLExpression;

public class TransformationCoverageModel {
    private URI uri;
    private Map<NodeCoverageModel, NodeCoverageModel> nodes = new HashMap<NodeCoverageModel, NodeCoverageModel>();
    private Module module;
    private IProject project;
    private IFile file;
    private RangeSet<Integer> touchedRanges;
    private RangeSet<Integer> untouchedRanges;

    public TransformationCoverageModel() {
    }

    public TransformationCoverageModel(URI uri) {
        this.setURI(uri);
    }

    public void setURI(URI aUri) {
        this.uri = aUri;
    }

    public URI getURI() {
        return this.uri;
    }

    private Set<NodeCoverageModel> getNodes(boolean touched, Class<?> c) {
        HashSet<NodeCoverageModel> desiredNodes = new HashSet<NodeCoverageModel>();
        for (NodeCoverageModel n : this.nodes.values()) {
            if (!c.isInstance(n.getNode()) || n.getTouched() != touched) continue;
            desiredNodes.add(n);
        }
        return desiredNodes;
    }

    private Set<NodeCoverageModel> getMappingNodes(boolean touched) {
        return this.getNodes(touched, MappingOperation.class);
    }

    public Set<NodeCoverageModel> getUntouchedMappingNodes() {
        return this.getMappingNodes(false);
    }

    public Set<NodeCoverageModel> getTouchedMappingNodes() {
        return this.getMappingNodes(true);
    }

    private Set<NodeCoverageModel> getHelperNodes(boolean touched) {
        return this.getNodes(touched, Helper.class);
    }

    public Set<NodeCoverageModel> getUntouchedHelperNodes() {
        return this.getHelperNodes(false);
    }

    public Set<NodeCoverageModel> getTouchedHelperNodes() {
        return this.getHelperNodes(true);
    }

    private Set<NodeCoverageModel> getConstructorNodes(boolean touched) {
        return this.getNodes(touched, Constructor.class);
    }

    public Set<NodeCoverageModel> getUntouchedConstructorNodes() {
        return this.getConstructorNodes(false);
    }

    public Set<NodeCoverageModel> getTouchedConstructorNodes() {
        return this.getConstructorNodes(true);
    }

    private Set<NodeCoverageModel> getExpressionNodes(boolean touched) {
        return this.getNodes(touched, OCLExpression.class);
    }

    public Set<NodeCoverageModel> getUntouchedExpressionNodes() {
        return this.getExpressionNodes(false);
    }

    public Set<NodeCoverageModel> getTouchedExpressionNodes() {
        return this.getExpressionNodes(true);
    }

    public RangeSet<Integer> getTouchedRanges() {
        if (this.touchedRanges == null) {
            this.touchedRanges = TreeRangeSet.create();
            for (NodeCoverageModel nodeModel : this.getTouchedExpressionNodes()) {
                this.touchedRanges.add(Range.closed((Comparable)Integer.valueOf(nodeModel.getStart()), (Comparable)Integer.valueOf(nodeModel.getEnd() + 1)));
            }
            for (Range untouchedRange : this.getUntouchedRanges().asRanges()) {
                this.touchedRanges.remove(untouchedRange);
            }
        }
        return this.touchedRanges;
    }

    public RangeSet<Integer> getUntouchedRanges() {
        if (this.untouchedRanges == null) {
            this.untouchedRanges = TreeRangeSet.create();
            for (NodeCoverageModel nodeModel : this.getUntouchedExpressionNodes()) {
                this.untouchedRanges.add(Range.closed((Comparable)Integer.valueOf(nodeModel.getStart()), (Comparable)Integer.valueOf(nodeModel.getEnd() + 1)));
            }
        }
        return this.untouchedRanges;
    }

    public IFile getFile() {
        if (this.file == null) {
            this.file = URIUtils.getFile((URI)this.getURI());
        }
        return this.file;
    }

    public IProject getProject() {
        if (this.project == null) {
            this.project = this.getFile().getProject();
        }
        return this.project;
    }

    public Module getModule() {
        if (this.module == null) {
            CompiledUnit unit;
            InternalTransformationExecutor executor = new InternalTransformationExecutor(this.getURI());
            executor.loadTransformation((IProgressMonitor)new NullProgressMonitor());
            this.module = executor.getTransformation();
            if (this.module == null && (unit = executor.getUnit()) != null) {
                for (Module m : unit.getModules()) {
                    if (!(m instanceof Library)) continue;
                    this.module = m;
                }
            }
        }
        return this.module;
    }

    public boolean containsNode(NodeCoverageModel n) {
        return this.nodes.containsKey(n);
    }

    public NodeCoverageModel getNode(NodeCoverageModel n) {
        return this.nodes.get(n);
    }

    public void addNode(NodeCoverageModel nodeModel) {
        this.nodes.put(nodeModel, nodeModel);
    }

    public Set<NodeCoverageModel> getUntouchedNodes() {
        HashSet<NodeCoverageModel> untouched = new HashSet<NodeCoverageModel>();
        untouched.addAll(this.getUntouchedMappingNodes());
        untouched.addAll(this.getUntouchedHelperNodes());
        untouched.addAll(this.getUntouchedConstructorNodes());
        untouched.addAll(this.getUntouchedExpressionNodes());
        return untouched;
    }

    public Set<NodeCoverageModel> getTouchedNodes() {
        HashSet<NodeCoverageModel> touched = new HashSet<NodeCoverageModel>();
        touched.addAll(this.getTouchedMappingNodes());
        touched.addAll(this.getTouchedHelperNodes());
        touched.addAll(this.getTouchedConstructorNodes());
        touched.addAll(this.getTouchedExpressionNodes());
        return touched;
    }
}

