/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.TypeUtil;

public class ModelOperations
extends AbstractContextualOperations {
    public static final String CREATE_EMPTY_MODEL_NAME = "createEmptyModel";
    public static final String COPY_NAME = "copy";
    public static final String OBJECTS_NAME = "objects";
    public static final String ROOT_OBJECTS_NAME = "rootObjects";
    public static final String OBJECTS_OF_TYPE_NAME = "objectsOfType";
    public static final String REMOVE_ELEMENT_NAME = "removeElement";
    private static final CallHandler OBJECTS = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelInstance)) {
                throw new IllegalArgumentException();
            }
            LinkedHashSet<Object> instances = new LinkedHashSet<Object>();
            ModelInstance model = (ModelInstance)source;
            ModelParameterExtent modelParam = model.getExtent();
            instances.addAll(modelParam.getAllObjects());
            return instances;
        }
    };
    private static final CallHandler ROOT_OBJECTS = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelInstance)) {
                throw new IllegalArgumentException();
            }
            LinkedHashSet<EObject> instances = new LinkedHashSet<EObject>();
            ModelInstance model = (ModelInstance)source;
            ModelParameterExtent modelParam = model.getExtent();
            instances.addAll(modelParam.getRootObjects());
            return instances;
        }
    };
    private static final CallHandler OBJECTS_OF_TYPE = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelInstance)) {
                throw new IllegalArgumentException();
            }
            LinkedHashSet<Object> instances = new LinkedHashSet<Object>();
            ModelInstance model = (ModelInstance)source;
            ModelParameterExtent modelParam = model.getExtent();
            List<Object> objects = modelParam.getAllObjects();
            for (Object obj : objects) {
                if (!AbstractQVTStdlib.clsFilter.matches(obj, args[0])) continue;
                instances.add(obj);
            }
            return instances;
        }
    };
    private static final CallHandler REMOVE_ELEMENT = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelInstance)) {
                throw new IllegalArgumentException();
            }
            ModelInstance model = (ModelInstance)source;
            ModelParameterExtent modelParam = model.getExtent();
            Object elementObject = args[0];
            if (elementObject instanceof EObject) {
                modelParam.removeElement((EObject)elementObject);
            }
            return null;
        }
    };
    private static final CallHandler COPY = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelInstance)) {
                throw new IllegalArgumentException();
            }
            ModelInstance model = (ModelInstance)source;
            ModelInstance modelCopy = model.copy();
            evalEnv.addModelExtent(modelCopy.getExtent());
            return modelCopy;
        }
    };
    private static final CallHandler CREATE_EMPTY_MODEL = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelType)) {
                throw new IllegalArgumentException();
            }
            ModelType modelType = (ModelType)source;
            EObject modelObj = modelType.getEPackage().getEFactoryInstance().create((EClass)modelType);
            if (!$assertionsDisabled && !(modelObj instanceof ModelInstance)) {
                throw new AssertionError((Object)"model must implement ModelInstance interface");
            }
            return modelObj;
        }
    };

    public ModelOperations(AbstractQVTStdlib library) {
        super(library, (EClassifier)library.getModelClass());
    }

    public EOperation defineGenericObjectsOfType(EcoreEnvironment env, EClassifier actualType) {
        return (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(OBJECTS_OF_TYPE, OBJECTS_OF_TYPE_NAME, (EClassifier)TypeUtil.resolveSetType((Environment)env, (Object)actualType), (EClassifier)env.getOCLStandardLibrary().getOclType()).define(env);
    }

    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        OCLStandardLibrary oclStdLibrary = this.getStdlib().getEnvironment().getOCLStandardLibrary();
        EClassifier setOfElements = (EClassifier)TypeUtil.resolveSetType((Environment)this.getStdlib().getEnvironment(), (Object)this.getStdlib().getElementType());
        EClassifier setOfT = (EClassifier)TypeUtil.resolveSetType((Environment)this.getStdlib().getEnvironment(), (Object)((EClassifier)oclStdLibrary.getT()));
        return new AbstractContextualOperations.OperationProvider[]{(AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "asTransformation", new String[]{"model"}, (EClassifier)this.getStdlib().getTransformationClass(), new EClassifier[]{this.getStdlib().getModelClass()}), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(COPY, COPY_NAME, (EClassifier)this.getStdlib().getModelClass(), new EClassifier[0]), this.createOwnedStaticOperationProvider(CREATE_EMPTY_MODEL, CREATE_EMPTY_MODEL_NAME, null, (EClassifier)this.getStdlib().getModelClass(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(OBJECTS, OBJECTS_NAME, setOfElements, new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(OBJECTS_OF_TYPE, OBJECTS_OF_TYPE_NAME, new String[]{"type"}, setOfT, (EClassifier)oclStdLibrary.getOclType()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(REMOVE_ELEMENT, REMOVE_ELEMENT_NAME, new String[]{"element"}, (EClassifier)oclStdLibrary.getOclVoid(), this.getStdlib().getElementType()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(ROOT_OBJECTS, ROOT_OBJECTS_NAME, setOfElements, new EClassifier[0])};
    }
}

