/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class WorkspaceUtils {
    private WorkspaceUtils() {
    }

    public static IFile getIFile(String fileUnderWorkspace) {
        Path location = new Path(fileUnderWorkspace);
        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)location);
        return ifile;
    }

    public static IFile getWorkspaceFile(String name) {
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(name));
            return file;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IFile getWorkspaceFile(URI uri) {
        IFile wsfile;
        String uriPath = uri.isFile() ? uri.toFileString() : (uri.isPlatform() ? uri.toPlatformString(true) : uri.toString());
        IFile ifile = WorkspaceUtils.getWorkspaceFile(uriPath);
        if ((ifile == null || !ifile.exists()) && uri.isFile() && (wsfile = WorkspaceUtils.getIFile(uriPath)) != null && wsfile.exists()) {
            return wsfile;
        }
        return ifile;
    }

    public static IContainer getIContainer(String folderUnderWorkspace) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path location = new Path(folderUnderWorkspace);
        IContainer cont = workspace.getRoot().getContainerForLocation((IPath)location);
        return cont;
    }
}

