/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.DebugUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class QVTODebugUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.m2m.qvt.oml.debug.ui";
    public static final String DEBUG_EDITOR_ID = "org.eclipse.m2m.qvt.oml.editor.ui.QvtEditor";
    private static QVTODebugUIPlugin plugin;

    public QVTODebugUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static QVTODebugUIPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        QVTODebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        QVTODebugUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 100001, "Unexpected exception caught", e));
    }

    public static IStatus createStatus(int severity, String message) {
        return new Status(severity, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createErrorStatus(String message) {
        return QVTODebugUIPlugin.createStatus(4, message);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return QVTODebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = QVTODebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void statusDialog(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                QVTODebugUIPlugin.statusDialog(DebugUIMessages.StatusDialog_Error, status);
                break;
            }
            case 2: {
                QVTODebugUIPlugin.statusDialog(DebugUIMessages.StatusDialog_Warning, status);
                break;
            }
            case 1: {
                QVTODebugUIPlugin.statusDialog(DebugUIMessages.StatusDialog_Information, status);
            }
        }
    }

    public static void statusDialog(String title, IStatus status) {
        Shell shell = QVTODebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            switch (status.getSeverity()) {
                case 4: {
                    ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)status);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)shell, (String)title, (String)status.getMessage());
                    break;
                }
                case 1: {
                    MessageDialog.openInformation((Shell)shell, (String)title, (String)status.getMessage());
                }
            }
        }
    }

    public static final Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry imageRegistry = super.createImageRegistry();
        imageRegistry.put("localVariable", this.imageDescriptor("localvar_obj.gif"));
        imageRegistry.put("thisVariable", this.imageDescriptor("thisvar_obj.gif"));
        imageRegistry.put("predefinedVariable", this.imageDescriptor("predefvar_obj.gif"));
        imageRegistry.put("modelParameter", this.imageDescriptor("modelpar_obj.gif"));
        imageRegistry.put("attribute", this.imageDescriptor("attribute_obj.gif"));
        imageRegistry.put("reference", this.imageDescriptor("reference_obj.gif"));
        imageRegistry.put("collectionElement", this.imageDescriptor("index_element_obj.gif"));
        imageRegistry.put("intermediateProperty", this.overlayImage("intermprop_ovr.gif", imageRegistry.get("attribute"), 3));
        imageRegistry.put("conditionalBreakpointEnabled", this.overlayImage("conditional_ovr.gif", DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT"), 0));
        imageRegistry.put("conditionalBreakpointDisabled", this.overlayImage("conditional_ovr_disabled.gif", DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT_DISABLED"), 0));
        return imageRegistry;
    }

    private ImageDescriptor imageDescriptor(String imagePath) {
        return QVTODebugUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + imagePath));
    }

    private final ImageDescriptor overlayImage(String overImagePath, Image base, int quadrant) {
        ImageDescriptor decorator = this.imageDescriptor(overImagePath);
        return new DecorationOverlayIcon(base, decorator, quadrant);
    }
}

