/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TransformationControls;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.ChooserDialogAdapter;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IChooser;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.ResourceDestinationChooser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class OptionalFileGroup {
    private final Button myCheckBox;
    private final Text myTextControl;
    private String myText = "";
    private final Button myBrowse;
    private final ResourceDestinationChooser myChooser;
    private List<IModifyListener> myModifyListeners = new ArrayList<IModifyListener>();

    public OptionalFileGroup(final Composite parent, String name) {
        this.myCheckBox = TransformationControls.createCheckBox(parent, name);
        this.myCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionalFileGroup.this.setUseFileFlag(OptionalFileGroup.this.getUseFileFlag());
                OptionalFileGroup.this.fireModifiedEvent();
            }
        });
        this.myTextControl = TransformationControls.createText(parent, 1);
        this.myTextControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OptionalFileGroup.this.myText = OptionalFileGroup.this.myTextControl.getText();
                OptionalFileGroup.this.fireModifiedEvent();
            }
        });
        this.myBrowse = TransformationControls.createButton(parent, Messages.BrowseButtonLabel);
        this.myChooser = new ResourceDestinationChooser();
        this.myBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URI uri;
                ChooserDialogAdapter dialog = new ChooserDialogAdapter(parent.getShell(), (IChooser)OptionalFileGroup.this.myChooser);
                if (OptionalFileGroup.this.myTextControl.getCharCount() > 0 && (uri = URI.createURI((String)OptionalFileGroup.this.myTextControl.getText())) != null) {
                    dialog.getChooser().setInitialSelection(uri.toString());
                }
                if (dialog.open() == 0) {
                    IPath path = OptionalFileGroup.this.myChooser.getPath();
                    if (path != null) {
                        OptionalFileGroup.this.setText(URI.createPlatformResourceURI((String)path.toOSString().toString(), (boolean)false).toString());
                    } else {
                        OptionalFileGroup.this.setText("");
                    }
                }
            }
        });
        this.setUseFileFlag(false);
    }

    public void addModifyListener(IModifyListener listener) {
        this.myModifyListeners.add(listener);
    }

    public void removeModifyListener(IModifyListener listener) {
        this.myModifyListeners.remove(listener);
    }

    private void fireModifiedEvent() {
        for (IModifyListener listener : this.myModifyListeners) {
            try {
                listener.modified();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getUseFileFlag() {
        return this.myCheckBox.getSelection();
    }

    public String getText() {
        return this.myText;
    }

    public void setUseFileFlag(boolean flag) {
        this.myCheckBox.setSelection(flag);
        this.myBrowse.setEnabled(this.getUseFileFlag());
        this.myTextControl.setEnabled(this.getUseFileFlag());
        this.myTextControl.setText(this.myText);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.myText = text;
        this.myTextControl.setText(this.myText);
        this.myTextControl.setSelection(this.myTextControl.getCharCount());
    }

    public void update(String baseName, String extension) {
        this.myChooser.initNewName(baseName, extension);
    }

    public static interface IModifyListener {
        public void modified();
    }
}

