/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

public class QvtMessage {
    public static final int SEVERITY_ERROR = 2;
    public static final int SEVERITY_WARNING = 1;
    private final int myLineNum;
    private final int mySeverity;
    private final String myMessage;
    private final TextPositionsImpl myPos;

    public QvtMessage(String message, int severity, int offset, int length, int lineNum) {
        this.myMessage = message;
        this.mySeverity = severity;
        this.myPos = new TextPositionsImpl(offset, length);
        this.myLineNum = lineNum;
    }

    public QvtMessage(String message, int offset, int length) {
        this(message, 2, offset, length, -1);
    }

    public QvtMessage(String message) {
        this(message, 0, 0);
    }

    public int getOffset() {
        return this.myPos.getOffset();
    }

    public int getLength() {
        return this.myPos.getLength();
    }

    public String getMessage() {
        return this.myMessage;
    }

    public int getSeverity() {
        return this.mySeverity;
    }

    public int getLineNum() {
        return this.myLineNum;
    }

    public String toString() {
        return String.valueOf(this.getLineNum() > 0 ? "Line " + this.getLineNum() + ':' : this.myPos.toString()) + " " + this.myMessage;
    }

    public boolean equals(Object o) {
        if (!(o instanceof QvtMessage)) {
            return false;
        }
        QvtMessage other = (QvtMessage)o;
        if (this.mySeverity != other.mySeverity) {
            return false;
        }
        if (this.myMessage == null ? other.myMessage != null : !this.myMessage.equals(other.myMessage)) {
            return false;
        }
        return !(this.myPos == null ? other.myPos != null : !this.myPos.equals(other.myPos));
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 37 + this.mySeverity;
        if (this.myMessage != null) {
            hash = hash * 37 + this.myMessage.hashCode();
        }
        if (this.myPos != null) {
            hash = hash * 37 + this.myPos.hashCode();
        }
        return hash;
    }

    private class TextPositionsImpl {
        private final int myOffset;
        private final int myLength;

        public TextPositionsImpl(int offset, int length) {
            this.myOffset = offset;
            this.myLength = length;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public int getLength() {
            return this.myLength;
        }

        public String toString() {
            return "[" + this.myOffset + ":" + (this.myOffset + this.myLength) + "]";
        }

        public boolean equals(Object o) {
            if (!(o instanceof TextPositionsImpl)) {
                return false;
            }
            TextPositionsImpl other = (TextPositionsImpl)o;
            return this.myOffset == other.myOffset && this.myLength == other.myLength;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 37 + this.myOffset;
            hash = hash * 37 + this.myLength;
            return hash;
        }
    }
}

