/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.app;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.app.AbstractRequestProcessor;
import org.eclipse.m2m.qvt.oml.debug.core.app.SocketUtil;
import org.eclipse.m2m.qvt.oml.debug.core.app.VMEventDispatcher;
import org.eclipse.m2m.qvt.oml.debug.core.app.VMProvider;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTOVirtualMachineShell;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMConnectRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMConnectResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMStartRequest;

class VMRequestProcessor
extends AbstractRequestProcessor {
    private IQVTOVirtualMachineShell fVM;
    private VMProvider fVMProvider;
    private VMEventDispatcher fEventDispatcher;

    public VMRequestProcessor(Socket requestSocket, VMProvider vmProvider) throws IOException {
        super(requestSocket);
        if (vmProvider == null) {
            throw new IllegalArgumentException();
        }
        this.fVMProvider = vmProvider;
    }

    protected void postTerminate() {
        super.postTerminate();
        if (this.fEventDispatcher != null) {
            this.fEventDispatcher.joinTermination(1000L);
        }
    }

    protected VMResponse processRequest(VMRequest request) throws CoreException {
        try {
            if (request instanceof VMConnectRequest) {
                return this.connect((VMConnectRequest)request);
            }
            if (request instanceof VMStartRequest) {
                this.fVM = this.fVMProvider.getVM();
                return this.fVM.sendRequest(request);
            }
            if (this.fVM != null) {
                return this.fVM.sendRequest(request);
            }
        }
        catch (IOException e) {
            QVTODebugCore.getDefault();
            throw new CoreException(QVTODebugCore.createStatus(4, e.getMessage(), e));
        }
        return VMResponse.createERROR();
    }

    private VMResponse connect(VMConnectRequest connectRequest) {
        int eventPort = SocketUtil.findFreePort();
        if (eventPort != -1) {
            this.fEventDispatcher = new VMEventDispatcher(this.fVMProvider, eventPort, new VMEventDispatcher.TerminationListener(){

                public void terminated() {
                    VMRequestProcessor.this.terminate();
                }
            });
            this.fEventDispatcher.start();
            return new VMConnectResponse(eventPort);
        }
        return VMResponse.createERROR();
    }
}

