/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.ast.env.IVirtualOperationTable;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ThisInstanceResolver;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VirtualTable
implements IVirtualOperationTable {
    private List<EOperation> fOperations;
    private Map<Module, List<EOperation>> fModule2OperationsMap;

    protected VirtualTable() {
    }

    protected abstract EOperation getOwningOperation();

    public void addOperation(EOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException();
        }
        if (this.fOperations == null) {
            this.fOperations = new LinkedList<EOperation>();
        }
        if (!this.fOperations.contains(operation)) {
            this.fOperations.add(operation);
        }
    }

    public void addOperationInModule(EOperation operation, Module exposeToCallerFrom) {
        List<EOperation> operations;
        if (operation == null) {
            throw new IllegalArgumentException();
        }
        if (this.fModule2OperationsMap == null) {
            this.fModule2OperationsMap = new HashMap<Module, List<EOperation>>();
        }
        if ((operations = this.fModule2OperationsMap.get(exposeToCallerFrom)) == null) {
            operations = new LinkedList<EOperation>();
            this.fModule2OperationsMap.put(exposeToCallerFrom, operations);
        }
        if (!operations.contains(operation)) {
            operations.add(operation);
        }
    }

    @Override
    public EOperation lookupActualOperation(EClassifier actualContextType, Environment env, InternalEvaluationEnv evalEnv) {
        return this.lookupActualOperation(actualContextType, env, null, evalEnv);
    }

    @Override
    public EOperation lookupActualOperation(EClassifier actualContextType, Environment env, Module scope, InternalEvaluationEnv evalEnv) {
        if (actualContextType == null || env == null) {
            throw new IllegalArgumentException();
        }
        EOperation formalOperation = this.getOwningOperation();
        if (formalOperation == null) {
            return null;
        }
        if (env.getUMLReflection().getOwningClassifier((Object)formalOperation) == actualContextType) {
            return formalOperation;
        }
        if (scope == null) {
            for (EOperation nextOperation : this.getModuleScopeOperations(scope)) {
                if (env.getUMLReflection().getOwningClassifier((Object)nextOperation) != actualContextType || !this.isOperationInScope(nextOperation, evalEnv)) continue;
                return nextOperation;
            }
        }
        for (EOperation nextOperation : this.getOperations()) {
            if (env.getUMLReflection().getOwningClassifier((Object)nextOperation) != actualContextType || !this.isOperationInScope(nextOperation, evalEnv)) continue;
            return nextOperation;
        }
        if (actualContextType instanceof EClass) {
            for (EClass superClass : ((EClass)actualContextType).getESuperTypes()) {
                EOperation superOperation = this.lookupActualOperation((EClassifier)superClass, env, scope, evalEnv);
                if (superOperation == null) continue;
                return superOperation;
            }
        }
        return null;
    }

    public void merge(VirtualTable another) {
        for (EOperation nextOperation : another.getOperations()) {
            this.addOperation(nextOperation);
        }
        if (another.fModule2OperationsMap != null) {
            for (Module nextModule : another.fModule2OperationsMap.keySet()) {
                List<EOperation> operations = another.fModule2OperationsMap.get(nextModule);
                if (operations == null) continue;
                for (EOperation nextOperation : operations) {
                    this.addOperationInModule(nextOperation, nextModule);
                }
            }
        }
    }

    private List<EOperation> getModuleScopeOperations(Module module) {
        if (module == null || this.fModule2OperationsMap == null || !this.fModule2OperationsMap.containsKey(module)) {
            return Collections.emptyList();
        }
        return this.fModule2OperationsMap.get(module);
    }

    public Collection<EOperation> getOperations() {
        return this.fOperations != null ? this.fOperations : Collections.emptySet();
    }

    private boolean isOperationInScope(EOperation operation, InternalEvaluationEnv evalEnv) {
        if (evalEnv != null && operation != null) {
            Module module = QvtOperationalParserUtil.getOwningModule(operation);
            if (module != null) {
                ThisInstanceResolver thisResolver = evalEnv.getThisResolver();
                return thisResolver != null && thisResolver.getThisInstanceOf(module) != null;
            }
            return true;
        }
        return false;
    }
}

