/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.builder;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2m.internal.qvt.oml.QvtEngine;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.builder.QvtBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.common.io.FileUtil;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseFile;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilationResult;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;

public class QvtBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "org.eclipse.m2m.qvt.oml.QvtBuilder";
    private static final List<BuildListener> ourListeners = new Vector<BuildListener>();
    private QvtBuilderConfig myConfig;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            this.incrementalBuild(monitor);
        }
        QvtBuilder.fireBuildEvent();
        return this.getConfig().getProjectDependencies(true);
    }

    private void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.rebuildAll(monitor);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.getProject().accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 1) {
                    if ("qvto".equals(proxy.requestFullPath().getFileExtension())) {
                        proxy.requestResource().deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                    }
                    return false;
                }
                return true;
            }
        }, 2);
    }

    void deleteContainersToLevel(IContainer from, IContainer level, IProgressMonitor monitor) throws CoreException {
        if (!from.exists()) {
            return;
        }
        if (from.getParent() == level) {
            return;
        }
        if (from.getParent() != null && from.getParent().getParent() == level) {
            if (from.exists()) {
                from.delete(true, monitor);
            }
        } else {
            IContainer parent = from.getParent();
            if (parent.members().length == (from.exists() ? 1 : 0)) {
                this.deleteContainersToLevel(parent, level, monitor);
            }
        }
    }

    private void incrementalBuild(IProgressMonitor monitor) throws CoreException {
        boolean needsRebuild = this.hasQVTModification(this.getProject());
        if (!needsRebuild) {
            IProject[] referencedProjects = this.getConfig().getProjectDependencies(true);
            int i = 0;
            while (i < referencedProjects.length) {
                IProject refProject = referencedProjects[i];
                boolean bl = needsRebuild = !refProject.isAccessible() || this.hasQVTModification(refProject);
                if (needsRebuild) break;
                ++i;
            }
        }
        if (needsRebuild) {
            this.rebuildAll(monitor);
        }
    }

    private boolean hasQVTModification(final IProject project) throws CoreException {
        IResourceDelta delta = this.getDelta(project);
        final boolean[] rebuild = new boolean[1];
        if (delta != null) {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if ((delta.getFlags() & 0x1000) != 0 && 2 == delta.getResource().getType()) {
                        IContainer srcContainer = QvtBuilderConfig.getConfig(project).getSourceContainer();
                        if (delta.getMovedFromPath().equals((Object)srcContainer.getFullPath())) {
                            try {
                                QvtBuilderConfig config = QvtBuilderConfig.getConfig(project);
                                config.setSourceContainer((IContainer)((IFolder)delta.getResource()));
                                config.save();
                            }
                            catch (CoreException e) {
                                QvtPlugin.log(e.getStatus());
                            }
                        }
                    }
                    if (delta.getResource().getType() == 1) {
                        IPath projectRelativePath = delta.getResource().getProjectRelativePath();
                        if (".project".equals(projectRelativePath.toString()) || "plugin.xml".equals(projectRelativePath.toString()) || "META-INF/MANIFEST.MF".equals(projectRelativePath.toString())) {
                            rebuild[0] = true;
                            return false;
                        }
                        if ("qvto".equals(projectRelativePath.getFileExtension())) {
                            rebuild[0] = true;
                            return false;
                        }
                        IFile mappingsFile = MetamodelURIMappingHelper.getMappingFileHandle((IProject)project);
                        if (mappingsFile != null && mappingsFile.exists() && projectRelativePath.equals((Object)mappingsFile.getProjectRelativePath())) {
                            rebuild[0] = true;
                            return false;
                        }
                        String fileNameExt = delta.getResource().getProjectRelativePath().getFileExtension();
                        if ("ecore".equals(fileNameExt)) {
                            rebuild[0] = true;
                            return false;
                        }
                    }
                    return true;
                }
            });
        }
        return rebuild[0];
    }

    private void rebuildAll(IProgressMonitor monitor) throws CoreException {
        QvtCompilationResult[] modules;
        IFile[] files = this.collectFiles();
        try {
            modules = QvtEngine.getInstance((IResource)this.getProject()).compile(files, null);
            QvtEngine.getInstance((IResource)this.getProject()).getCompiler();
        }
        catch (Exception e) {
            throw new CoreException(QvtPlugin.createErrorStatus(e));
        }
        ArrayList<CompiledModule> cleanModules = new ArrayList<CompiledModule>();
        int i = 0;
        while (i < modules.length) {
            CompiledModule module = modules[i].getModule();
            QvtMessage[] messages = module.getMessages();
            EclipseFile source = (EclipseFile)module.getSource();
            IFile curFile = source.getFile();
            curFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            if (module.getErrors().length == 0) {
                cleanModules.add(module);
            }
            int j = 0;
            while (j < messages.length) {
                QvtMessage e = messages[j];
                this.createQvtMarker(curFile, e);
                ++j;
            }
            ++i;
        }
    }

    private void createQvtMarker(IFile curFile, QvtMessage e) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("charStart", e.getOffset());
        attributes.put("charEnd", e.getOffset() + e.getLength());
        attributes.put("message", e.getMessage());
        attributes.put("severity", e.getSeverity());
        if (e.getLineNum() >= 0) {
            attributes.put("lineNumber", e.getLineNum());
        }
        try {
            IMarker marker = curFile.createMarker("org.eclipse.m2m.qvt.oml.qvtProblem");
            marker.setAttributes(attributes);
        }
        catch (CoreException e1) {
            Logger.getLogger().log(Logger.WARNING, "QvtBuilder: failed to create marker", e1);
        }
    }

    private QvtBuilderConfig getConfig() throws CoreException {
        if (this.myConfig == null) {
            this.myConfig = QvtBuilderConfig.getConfig(this.getProject());
        }
        return this.myConfig;
    }

    private IFile[] collectFiles() throws CoreException {
        final ArrayList result = new ArrayList();
        this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        IContainer srcContainer = null;
        try {
            srcContainer = QvtBuilderConfig.getConfig(this.getProject()).getSourceContainer();
        }
        catch (CoreException e) {
            QvtPlugin.log(e.getStatus());
        }
        if (srcContainer == null || !srcContainer.exists()) {
            return new IFile[0];
        }
        srcContainer.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 1) {
                    if (!"qvto".equals(proxy.requestFullPath().getFileExtension())) {
                        return false;
                    }
                    IFile file = (IFile)proxy.requestResource();
                    result.add(file);
                    return false;
                }
                return true;
            }
        }, 2);
        return result.toArray(new IFile[result.size()]);
    }

    public static String getFileContents(IFile file) {
        try {
            return FileUtil.getStreamContents((InputStream)file.getContents(), (String)file.getCharset());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void addBuildListener(BuildListener l) {
        ourListeners.add(l);
    }

    public static void removeBuildListener(BuildListener l) {
        ourListeners.remove(l);
    }

    private static void fireBuildEvent() {
        for (BuildListener l : ourListeners) {
            l.buildPerformed();
        }
    }

    public static interface BuildListener {
        public void buildPerformed();
    }
}

