/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.types.VoidType;

public class QvtOperationalTypesUtil {
    public static final String TYPE_NAME_SEPARATOR = "::";
    private static final String UNKNOWN_TYPE_NAME = "unknown";

    public static String getTypeFullName(EClassifier type) {
        if (type == null) {
            return UNKNOWN_TYPE_NAME;
        }
        String fullName = QvtOperationalTypesUtil.getTypeName(type);
        EObject parent = type.eContainer();
        while (parent != null) {
            if (parent instanceof ENamedElement) {
                fullName = String.valueOf(((ENamedElement)parent).getName()) + TYPE_NAME_SEPARATOR + fullName;
            }
            parent = parent.eContainer();
        }
        return fullName;
    }

    public static final String getTypeName(EClassifier type) {
        if (type instanceof CollectionType) {
            return QvtOperationalTypesUtil.getCollectionTypeName((CollectionType)type);
        }
        return type.getName();
    }

    public static final String getCollectionTypeName(CollectionType collectionType) {
        StringBuffer sbName = new StringBuffer();
        switch (collectionType.getKind()) {
            case SET_LITERAL: {
                sbName.append("Set");
                break;
            }
            case ORDERED_SET_LITERAL: {
                sbName.append("OrderedSet");
                break;
            }
            case BAG_LITERAL: {
                sbName.append("Bag");
                break;
            }
            case SEQUENCE_LITERAL: {
                sbName.append("Sequence");
                break;
            }
            default: {
                sbName.append("Collection");
            }
        }
        sbName.append('(');
        EClassifier elementType = (EClassifier)collectionType.getElementType();
        String elementTypeName = elementType == null ? UNKNOWN_TYPE_NAME : (elementType instanceof VoidType ? "T" : QvtOperationalTypesUtil.getTypeName(elementType));
        sbName.append(elementTypeName);
        sbName.append(')');
        return sbName.toString();
    }
}

