/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.runtime.util;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerFacade;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.Messages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtoTransformationValidator {
    public static final int QVTO_ROOT_DIAGNOSTIC = 1;
    public static final int QVTO_CHILD_DIAGNOSTIC = 2;

    private QvtoTransformationValidator() {
    }

    public static Diagnostic validateQvtoScript(URI uriTransf, IProgressMonitor monitor, Map<String, String> options) {
        try {
            QvtCompilerOptions compilerOptions = new QvtCompilerOptions();
            compilerOptions.setGenerateCompletionData(false);
            CompiledModule compiledModule = QvtCompilerFacade.getCompiledModule((URI)uriTransf, (QvtCompilerOptions)compilerOptions, (IProgressMonitor)monitor).getCompiledModule();
            return QvtoTransformationValidator.fillCompilationDiagnostic(compiledModule, uriTransf);
        }
        catch (MdaException e) {
            return new BasicDiagnostic(4, uriTransf.toString(), 1, e.getMessage(), new Object[0]);
        }
    }

    private static Diagnostic fillCompilationDiagnostic(CompiledModule compiledModule, URI uri) {
        BasicDiagnostic result = new BasicDiagnostic(1, uri.toString(), 1, NLS.bind((String)Messages.moduleDiagnosticChain, (Object)uri.toString()), new Object[0]);
        QvtMessage[] qvtMessageArray = compiledModule.getMessages();
        int n = qvtMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            QvtMessage msg = qvtMessageArray[n2];
            result.add(QvtoTransformationValidator.createDiagnostic(msg, uri));
            ++n2;
        }
        return result;
    }

    private static Diagnostic createDiagnostic(QvtMessage msg, URI uri) {
        return new BasicDiagnostic(msg.getSeverity() == 2 ? 4 : 2, uri.toString(), 2, msg.getMessage(), new Object[0]);
    }
}

