/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.ArrayList;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.ColorManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.IQvtColorConstants;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.NonRuleBasedDamagerRepairer;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtAnnotationHover;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDocumentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDoubleClickStrategy;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtIndentAutoEditStrategy;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtReconciler;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtReconcilingStrategy;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtScanner;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionProcessor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.QvtTextHover;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtHyperlinkDetector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.QvtQuickOutlineFactoryRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class QvtConfiguration
extends SourceViewerConfiguration {
    private QvtDoubleClickStrategy doubleClickStrategy;
    private QvtScanner scanner;
    private ColorManager myColorManager;
    private ContentAssistant myContentAssistant;
    private QvtEditor myEditor;
    private static final int ASSIST_AUTO_ACTIVATION_DELAY = 200;
    private static final int RECONCILER_DELAY = 500;

    public QvtConfiguration(QvtEditor editor, ColorManager colorManager) {
        this.myColorManager = colorManager;
        this.myEditor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__qvt_comment", "__qvt_string"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new QvtDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected QvtScanner getQvtScanner() {
        if (this.scanner == null) {
            this.scanner = new QvtScanner(this.myColorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.myColorManager.getColor(IQvtColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning("__qvt_partitioning");
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getQvtScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.myColorManager.getColor(IQvtColorConstants.QVT_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__qvt_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__qvt_comment");
        ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.myColorManager.getColor(IQvtColorConstants.STRING)));
        reconciler.setDamager((IPresentationDamager)ndr, "__qvt_string");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__qvt_string");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.myContentAssistant = new ContentAssistant();
        QvtCompletionProcessor processor = new QvtCompletionProcessor(this.myEditor, sourceViewer, this.myContentAssistant);
        this.myContentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        this.myContentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__qvt_string");
        this.myContentAssistant.setDocumentPartitioning("__qvt_partitioning");
        this.myContentAssistant.enableAutoInsert(true);
        this.myContentAssistant.enableAutoActivation(true);
        this.myContentAssistant.setAutoActivationDelay(200);
        this.myContentAssistant.setProposalPopupOrientation(10);
        this.myContentAssistant.setContextInformationPopupOrientation(20);
        this.myContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        this.myContentAssistant.setProposalSelectorBackground(this.myColorManager.getColor(IQvtColorConstants.PROPOSAL_BACKGROUND));
        return this.myContentAssistant;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        QvtReconcilingStrategy strategy = new QvtReconcilingStrategy(this.myEditor);
        QvtReconciler reconciler = new QvtReconciler((ITextEditor)this.myEditor, strategy, false);
        reconciler.setDelay(500);
        this.myEditor.setReconciler(reconciler);
        return reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new QvtIndentAutoEditStrategy()};
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new QvtAnnotationHover();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new QvtTextHover((QvtDocumentProvider)this.myEditor.getDocumentProvider());
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        ArrayList<QvtHyperlinkDetector> detectors = new ArrayList<QvtHyperlinkDetector>();
        detectors.add(new QvtHyperlinkDetector(this.myEditor));
        return detectors.toArray(new IHyperlinkDetector[detectors.size()]);
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.eclipse.m2m.qvt.oml.editor.ui.show.outline"));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        IInformationProvider provider = QvtQuickOutlineFactoryRegistry.getQvtQuickOutlineFactory().newInformationProvider();
        presenter.setInformationProvider(provider, "__dftl_partition_content_type");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(final ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return QvtQuickOutlineFactoryRegistry.getQvtQuickOutlineFactory().newInformationControl(parent, shellStyle, treeStyle, commandId, QvtConfiguration.this.myEditor, sourceViewer);
            }
        };
    }
}

