/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.m2m.internal.qvt.oml.QvtEngine;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.builder.QvtBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseFile;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilationResult;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Messages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDocumentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.ui.part.FileEditorInput;

public class QvtCompilerFacade {
    private static QvtCompilerFacade ourInstance;

    private QvtCompilerFacade() {
    }

    public QvtCompilationResult compile(QvtEditor editor, IDocument document, QvtCompilerOptions options, IProgressMonitor monitor) {
        if (!this.checkEditor(editor)) {
            return null;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.QvtCompilerFacade_compilingDoc, 4);
        QvtCompilationResult result = null;
        try {
            monitor.subTask(Messages.QvtCompilerFacade_acquiringDoc);
            IFile file = ((FileEditorInput)editor.getEditorInput()).getFile();
            QvtDocumentProvider documentProvider = (QvtDocumentProvider)editor.getDocumentProvider();
            final String contents = document.get();
            final long timeStamp = System.currentTimeMillis();
            monitor.worked(1);
            try {
                EclipseFile source = new EclipseFile(file){

                    public InputStream getContents() {
                        try {
                            return new ByteArrayInputStream(contents.getBytes(this.getCharset()));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public String getCharset() throws IOException {
                        return "UTF-8";
                    }

                    public long getTimeStamp() {
                        return timeStamp;
                    }
                };
                QvtEngine engine = QvtEngine.getInstance((IResource)file);
                result = engine.compile((CFile)source, options, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                if (result != null) {
                    documentProvider.setMappingModule(result.getModule());
                }
            }
            catch (MdaException e) {
                documentProvider.setMappingModule(result != null ? result.getModule() : null);
                Logger.getLogger().log(Logger.SEVERE, "Error during compiling document", e);
            }
            if (options.isReportErrors() && options.isShowAnnotations()) {
                this.reportProblems(result, editor.getAnnotationModel());
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private void reportProblems(QvtCompilationResult compilationResult, IAnnotationModel model) {
        if (compilationResult == null || model == null || model.getAnnotationIterator() == null) {
            return;
        }
        ArrayList<Annotation> annotationsToRemove = new ArrayList<Annotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation annotation = (Annotation)iter.next();
            if (!"org.eclipse.m2m.qvt.oml.error".equals(annotation.getType()) && !"org.eclipse.m2m.qvt.oml.warning".equals(annotation.getType())) continue;
            annotationsToRemove.add(annotation);
        }
        HashMap<Annotation, Position> annotationsToAdd = new HashMap<Annotation, Position>();
        QvtMessage[] qvtMessageArray = compilationResult.getMessages();
        int n = qvtMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            QvtMessage qvtMessage = qvtMessageArray[n2];
            if (this.checkProblem(qvtMessage)) {
                annotationsToAdd.put(this.createProblemAnnotation(qvtMessage), this.createProblemPosition(qvtMessage));
            }
            ++n2;
        }
        if (model instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)model;
            iAnnotationModelExtension.replaceAnnotations(annotationsToRemove.toArray(new Annotation[annotationsToRemove.size()]), annotationsToAdd);
        } else {
            for (Annotation annotation : annotationsToRemove) {
                model.removeAnnotation(annotation);
            }
            for (Map.Entry entry : annotationsToAdd.entrySet()) {
                model.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
        }
    }

    private boolean checkProblem(QvtMessage problem) {
        return problem != null && problem.getOffset() >= 0 && problem.getLength() >= 0;
    }

    private Annotation createProblemAnnotation(QvtMessage problem) {
        return new Annotation(this.getAnnotationType(problem.getSeverity()), true, problem.getMessage());
    }

    private String getAnnotationType(int severity) {
        switch (severity) {
            case 2: {
                return "org.eclipse.m2m.qvt.oml.error";
            }
            case 1: {
                return "org.eclipse.m2m.qvt.oml.warning";
            }
        }
        throw new IllegalArgumentException();
    }

    private Position createProblemPosition(QvtMessage problem) {
        return new Position(problem.getOffset(), problem.getLength());
    }

    public static QvtCompilerFacade getInstance() {
        if (ourInstance == null) {
            ourInstance = new QvtCompilerFacade();
        }
        return ourInstance;
    }

    private boolean checkEditor(QvtEditor editor) {
        return editor != null && editor.getEditorInput() instanceof FileEditorInput && editor.getDocumentProvider() != null;
    }

    static boolean isEditingInQvtSourceContainer(QvtEditor editor) {
        if (editor.getEditorInput() == null) {
            return false;
        }
        IFile file = ((FileEditorInput)editor.getEditorInput()).getFile();
        if (file != null && file.exists()) {
            try {
                IContainer srcContainer = QvtBuilderConfig.getConfig((IProject)file.getProject()).getSourceContainer();
                if (srcContainer.exists()) {
                    IPath editedPath = file.getFullPath();
                    IPath srcPath = srcContainer.getFullPath();
                    return srcPath.isPrefixOf(editedPath);
                }
            }
            catch (CoreException e) {
                QvtPlugin.log((Throwable)e);
            }
        }
        return false;
    }
}

