/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.AltExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.AssertExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.AssignExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.BlockExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ConfigProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExtendedVisitor;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeIterateExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeLoopExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.LocalProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.LogExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.ObjectExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.Property;
import org.eclipse.m2m.internal.qvt.oml.expressions.Rename;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveInExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ReturnExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.SwitchExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.VariableInitExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.WhileExp;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.Visitable;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalAstWalker
implements ExtendedVisitor<Object, EObject, CallOperationAction, SendSignalAction, Constraint> {
    private final NodeProcessor myNodeProcessor;
    private final Set<Visitable> myProcessed;

    public QvtOperationalAstWalker(NodeProcessor processor) {
        this.myNodeProcessor = processor;
        this.myProcessed = new HashSet<Visitable>();
    }

    @Override
    public Object visitAssignExp(AssignExp assignExp) {
        this.doProcess((Visitable)assignExp.getLeft(), (Visitable)assignExp);
        for (OCLExpression exp : assignExp.getValue()) {
            this.doProcess((Visitable)exp, (Visitable)assignExp);
        }
        return null;
    }

    @Override
    public Object visitConfigProperty(ConfigProperty configProperty) {
        return null;
    }

    @Override
    public Object visitHelper(Helper helper) {
        this.visitImperativeOperation(helper);
        return null;
    }

    @Override
    public Object visitImperativeOperation(ImperativeOperation imperativeOperation) {
        this.doProcess(imperativeOperation.getBody(), imperativeOperation);
        return null;
    }

    @Override
    public Object visitLibrary(Library library) {
        return null;
    }

    @Override
    public Object visitLocalProperty(LocalProperty localProperty) {
        this.doProcess((Visitable)localProperty.getExpression(), localProperty);
        return null;
    }

    @Override
    public Object visitReturnExp(ReturnExp returnExp) {
        if (returnExp.getValue() != null) {
            this.doProcess((Visitable)returnExp.getValue(), (Visitable)returnExp);
        }
        return null;
    }

    @Override
    public Object visitMappingBody(MappingBody mappingBody) {
        for (OCLExpression exp : mappingBody.getInitSection()) {
            this.doProcess((Visitable)exp, mappingBody);
        }
        for (OCLExpression exp : mappingBody.getContent()) {
            this.doProcess((Visitable)exp, mappingBody);
        }
        for (OCLExpression exp : mappingBody.getEndSection()) {
            this.doProcess((Visitable)exp, mappingBody);
        }
        return null;
    }

    @Override
    public Object visitMappingCallExp(MappingCallExp mappingCallExp) {
        this.visitOperationCallExp(mappingCallExp);
        return null;
    }

    @Override
    public Object visitMappingOperation(MappingOperation mappingOperation) {
        this.visitImperativeOperation(mappingOperation);
        for (OCLExpression exp : mappingOperation.getWhen()) {
            this.doProcess((Visitable)exp, mappingOperation);
        }
        return null;
    }

    @Override
    public Object visitModule(Module module) {
        this.myNodeProcessor.process(module, null);
        for (Rename rename : module.getOwnedRenaming()) {
            this.doProcess(rename, module);
        }
        for (EOperation op : new ArrayList<EOperation>(QvtOperationalParserUtil.getOwnedOperations(module))) {
            this.doProcess((ImperativeOperation)op, module);
        }
        for (EStructuralFeature prop : module.getEStructuralFeatures()) {
            Property propAST = null;
            propAST = prop instanceof Property ? (Property)prop : QvtOperationalParserUtil.getLocalPropertyAST(prop);
            if (propAST == null) continue;
            this.doProcess(propAST, module);
        }
        return null;
    }

    @Override
    public Object visitModuleImport(ModuleImport moduleImport) {
        return null;
    }

    @Override
    public Object visitObjectExp(ObjectExp objectExp) {
        if (objectExp.getBody() != null) {
            EList<OCLExpression<EClassifier>> contents = objectExp.getBody().getContent();
            for (OCLExpression exp : contents) {
                this.doProcess((Visitable)exp, (Visitable)objectExp);
            }
        }
        return null;
    }

    @Override
    public Object visitOperationBody(OperationBody operationBody) {
        for (OCLExpression exp : operationBody.getContent()) {
            this.doProcess((Visitable)exp, operationBody);
        }
        return null;
    }

    @Override
    public Object visitProperty(Property property) {
        return null;
    }

    @Override
    public Object visitRename(Rename rename) {
        return null;
    }

    @Override
    public Object visitVarParameter(VarParameter varParameter) {
        return null;
    }

    @Override
    public Object visitVariableInitExp(VariableInitExp variableInitExp) {
        this.doProcess((Visitable)variableInitExp.getValue(), (Visitable)variableInitExp);
        return null;
    }

    @Override
    public Object visitBlockExp(BlockExp blockExp) {
        for (OCLExpression exp : blockExp.getBody()) {
            this.doProcess((Visitable)exp, (Visitable)blockExp);
        }
        return null;
    }

    @Override
    public Object visitWhileExp(WhileExp whileExp) {
        this.doProcess((Visitable)whileExp.getBody(), (Visitable)whileExp);
        if (whileExp.getCondition() != null) {
            this.doProcess((Visitable)whileExp.getCondition(), (Visitable)whileExp);
        }
        if (whileExp.getResult() != null) {
            this.doProcess((Visitable)whileExp.getResult(), (Visitable)whileExp);
        }
        if (whileExp.getResultVar() != null) {
            this.doProcess((Visitable)whileExp.getResult(), (Visitable)whileExp);
        }
        return null;
    }

    public Object visitAssociationClassCallExp(AssociationClassCallExp<EClassifier, EStructuralFeature> callExp) {
        for (OCLExpression exp : callExp.getQualifier()) {
            this.doProcess((Visitable)exp, (Visitable)callExp);
        }
        this.doProcess((Visitable)callExp.getSource(), (Visitable)callExp);
        return null;
    }

    public Object visitBooleanLiteralExp(BooleanLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitCollectionItem(CollectionItem<EClassifier> item) {
        this.doProcess((Visitable)item.getItem(), (Visitable)item);
        return null;
    }

    public Object visitCollectionLiteralExp(CollectionLiteralExp<EClassifier> literalExp) {
        for (CollectionLiteralPart part : literalExp.getPart()) {
            this.doProcess((Visitable)part, (Visitable)literalExp);
        }
        return null;
    }

    public Object visitCollectionRange(CollectionRange<EClassifier> range) {
        this.doProcess((Visitable)range.getFirst(), (Visitable)range);
        this.doProcess((Visitable)range.getLast(), (Visitable)range);
        return null;
    }

    public Object visitConstraint(Constraint constraint) {
        this.doProcess((Visitable)constraint.getSpecification().getBodyExpression(), (Visitable)constraint.getSpecification());
        return null;
    }

    public Object visitEnumLiteralExp(EnumLiteralExp<EClassifier, EEnumLiteral> literalExp) {
        return null;
    }

    public Object visitExpressionInOCL(ExpressionInOCL<EClassifier, EParameter> expression) {
        return null;
    }

    public Object visitIfExp(IfExp<EClassifier> ifExp) {
        this.doProcess((Visitable)ifExp.getCondition(), (Visitable)ifExp);
        this.doProcess((Visitable)ifExp.getThenExpression(), (Visitable)ifExp);
        this.doProcess((Visitable)ifExp.getElseExpression(), (Visitable)ifExp);
        return null;
    }

    public Object visitIntegerLiteralExp(IntegerLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitInvalidLiteralExp(InvalidLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitIterateExp(IterateExp<EClassifier, EParameter> callExp) {
        this.doProcess((Visitable)callExp.getResult(), (Visitable)callExp);
        this.doProcess((Visitable)callExp.getBody(), (Visitable)callExp);
        return null;
    }

    public Object visitIteratorExp(IteratorExp<EClassifier, EParameter> callExp) {
        if (callExp.getSource() != null) {
            this.doProcess((Visitable)callExp.getSource(), (Visitable)callExp);
        }
        this.doProcess((Visitable)callExp.getBody(), (Visitable)callExp);
        return null;
    }

    public Object visitLetExp(LetExp<EClassifier, EParameter> letExp) {
        this.doProcess((Visitable)letExp.getVariable(), (Visitable)letExp);
        this.doProcess((Visitable)letExp.getIn(), (Visitable)letExp);
        return null;
    }

    public Object visitMessageExp(MessageExp<EClassifier, CallOperationAction, SendSignalAction> messageExp) {
        this.doProcess((Visitable)messageExp.getTarget(), (Visitable)messageExp);
        return null;
    }

    public Object visitNullLiteralExp(NullLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitOperationCallExp(OperationCallExp<EClassifier, EOperation> callExp) {
        OCLExpression source = callExp.getSource();
        if (source != null) {
            this.doProcess((Visitable)source, (Visitable)callExp);
        }
        for (OCLExpression exp : callExp.getArgument()) {
            this.doProcess((Visitable)exp, (Visitable)callExp);
        }
        EOperation referredOperation = (EOperation)callExp.getReferredOperation();
        boolean cfr_ignored_0 = referredOperation instanceof Visitable;
        return null;
    }

    public Object visitPropertyCallExp(PropertyCallExp<EClassifier, EStructuralFeature> callExp) {
        return null;
    }

    public Object visitRealLiteralExp(RealLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitStateExp(StateExp<EClassifier, EObject> stateExp) {
        return null;
    }

    public Object visitStringLiteralExp(StringLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitTupleLiteralExp(TupleLiteralExp<EClassifier, EStructuralFeature> literalExp) {
        return null;
    }

    public Object visitTupleLiteralPart(TupleLiteralPart<EClassifier, EStructuralFeature> part) {
        return null;
    }

    public Object visitTypeExp(TypeExp<EClassifier> typeExp) {
        return null;
    }

    public Object visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<EClassifier> literalExp) {
        return null;
    }

    public Object visitUnspecifiedValueExp(UnspecifiedValueExp<EClassifier> unspecExp) {
        return null;
    }

    public Object visitVariable(Variable<EClassifier, EParameter> variable) {
        return null;
    }

    public Object visitVariableExp(VariableExp<EClassifier, EParameter> variableExp) {
        Variable referredVariable = variableExp.getReferredVariable();
        if (referredVariable instanceof Visitable) {
            this.doProcess((Visitable)referredVariable, (Visitable)variableExp);
        }
        return null;
    }

    @Override
    public Object visitResolveExp(ResolveExp resolveExp) {
        this.doProcess((Visitable)resolveExp.getCondition(), (Visitable)resolveExp);
        return null;
    }

    @Override
    public Object visitResolveInExp(ResolveInExp resolveInExp) {
        for (MappingOperation mappingOperation : resolveInExp.getInMappings()) {
            this.doProcess(mappingOperation, (Visitable)resolveInExp);
        }
        return this.visitResolveExp(resolveInExp);
    }

    @Override
    public Object visitModelType(ModelType modelType) {
        for (OCLExpression exp : modelType.getAdditionalCondition()) {
            this.doProcess((Visitable)exp, modelType);
        }
        return null;
    }

    @Override
    public Object visitLogExp(LogExp logExp) {
        for (OCLExpression arg : logExp.getArgument()) {
            this.doProcess((Visitable)arg, (Visitable)logExp);
        }
        if (logExp.getCondition() != null) {
            this.doProcess((Visitable)logExp.getCondition(), (Visitable)logExp);
        }
        return null;
    }

    @Override
    public Object visitAssertExp(AssertExp assertExp) {
        if (assertExp.getAssertion() != null) {
            this.doProcess((Visitable)assertExp.getAssertion(), (Visitable)assertExp);
        }
        if (assertExp.getLog() != null) {
            this.doProcess((Visitable)assertExp.getLog(), (Visitable)assertExp);
        }
        return null;
    }

    private void doProcess(Visitable e, Visitable parent) {
        if (e != null && !this.myProcessed.contains(e)) {
            this.myNodeProcessor.process(e, parent);
            this.myProcessed.add(e);
            e.accept((Visitor)this);
        }
    }

    @Override
    public Object visitSwitchAltExp(AltExp switchAltExp) {
        this.doProcess((Visitable)switchAltExp.getCondition(), (Visitable)switchAltExp);
        this.doProcess((Visitable)switchAltExp.getBody(), (Visitable)switchAltExp);
        return null;
    }

    @Override
    public Object visitSwitchExp(SwitchExp switchExp) {
        EList<AltExp> alternativePart = switchExp.getAlternativePart();
        if (alternativePart != null) {
            for (AltExp altExp : alternativePart) {
                this.doProcess((Visitable)altExp, (Visitable)switchExp);
            }
        }
        this.doProcess((Visitable)switchExp.getElsePart(), (Visitable)switchExp);
        return null;
    }

    @Override
    public Object visitImperativeLoopExp(ImperativeLoopExp imperativeLoopExp) {
        if (imperativeLoopExp.getSource() != null) {
            this.doProcess((Visitable)imperativeLoopExp.getSource(), (Visitable)imperativeLoopExp);
        }
        this.doProcess((Visitable)imperativeLoopExp.getCondition(), (Visitable)imperativeLoopExp);
        this.doProcess((Visitable)imperativeLoopExp.getBody(), (Visitable)imperativeLoopExp);
        return null;
    }

    @Override
    public Object visitImperativeIterateExp(ImperativeIterateExp imperativeIterateExp) {
        return this.visitImperativeLoopExp(imperativeIterateExp);
    }

    @Override
    public Object visitContextualProperty(ContextualProperty contextualProperty) {
        this.doProcess((Visitable)contextualProperty.getInitExpression(), contextualProperty);
        return null;
    }

    public static interface NodeProcessor {
        public void process(Visitable var1, Visitable var2) throws StopException;
    }

    public static class StopException
    extends RuntimeException {
        private static final long serialVersionUID = -1386908042373844768L;
        public static final StopException INSTANCE = new StopException();

        private StopException() {
        }
    }
}

