/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibPackage;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.runtime.evaluation.AbstractObjectManager;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.internal.evaluation.EOppositeReferenceImpl;
import org.eclipse.qvtd.runtime.internal.evaluation.ObjectState;

public abstract class AbstractObjectState<@NonNull SS extends SlotState>
implements ObjectState {
    protected final @NonNull AbstractObjectManager<@NonNull SS> objectManager;
    protected final @NonNull Object eObject;
    protected @Nullable Map<@NonNull EStructuralFeature, @NonNull SS> feature2slotState = null;

    public AbstractObjectState(@NonNull AbstractObjectManager<SS> objectManager, @NonNull Object eObject) {
        this.objectManager = objectManager;
        this.eObject = eObject;
    }

    public void assigned(@NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
        @Nullable SS slotState = this.basicGetSlotState(eFeature);
        if (slotState != null) {
            slotState.assigned(this.eObject, eFeature, ecoreValue, isPartial);
        } else {
            slotState = this.updateSlotState(eFeature, ecoreValue, isPartial);
            assert (this.basicGetSlotState(eFeature) == slotState);
        }
    }

    public @Nullable SS basicGetSlotState(@NonNull EStructuralFeature eFeature) {
        return (SS)(this.feature2slotState != null ? (SlotState)this.feature2slotState.get(eFeature) : null);
    }

    protected abstract @NonNull SS createManyToManySlotState(@NonNull EReference var1);

    protected abstract @NonNull SS createOclContainerSlotState(@NonNull EReference var1, @NonNull Object var2);

    protected abstract @NonNull SS createOneToManyAggregatorSlotState(@NonNull EReference var1, @NonNull Object var2);

    protected abstract @NonNull SS createOneToManyElementSlotState(@NonNull EReference var1, @NonNull EReference var2, @NonNull Object var3);

    protected abstract @NonNull SS createOneToOneSlotState(@NonNull EReference var1, @Nullable Object var2);

    protected abstract @NonNull SS createSimpleSlotState(@NonNull EAttribute var1, @Nullable Object var2);

    public @NonNull Iterable<@NonNull SS> getFeatures() {
        return this.feature2slotState != null ? ClassUtil.nullFree(this.feature2slotState.values()) : Collections.emptyList();
    }

    @Override
    public @NonNull Object getObject() {
        return this.eObject;
    }

    public @NonNull AbstractObjectManager<@NonNull SS> getObjectManager() {
        return this.objectManager;
    }

    public @NonNull SS gotSlotState(@NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
        assert (ecoreValue != AbstractObjectManager.NOT_A_VALUE);
        @Nullable SS slotState = this.basicGetSlotState(eFeature);
        if (slotState == null) {
            slotState = this.updateSlotState(eFeature, ecoreValue, false);
        } else if (!slotState.isAssigned() && !eFeature.isMany()) {
            slotState.assigned(this.eObject, eFeature, ecoreValue, false);
        }
        return slotState;
    }

    protected void putSlotState(@NonNull EStructuralFeature eFeature, @NonNull SS slotState) {
        Map<@NonNull EStructuralFeature, @NonNull SS> feature2slotState2 = this.feature2slotState;
        if (feature2slotState2 == null) {
            feature2slotState2 = new HashMap<EStructuralFeature, SS>();
            this.feature2slotState = feature2slotState2;
        }
        feature2slotState2.put(eFeature, slotState);
    }

    public String toString() {
        return this.eObject.toString();
    }

    public @NonNull SS updateSlotState(@NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
        Object eOpposite;
        @Nullable SS slotState = this.basicGetSlotState(eFeature);
        if (slotState != null) {
            if (ecoreValue != AbstractObjectManager.NOT_A_VALUE) {
                slotState.assigned(this.eObject, eFeature, ecoreValue, isPartial);
            }
            return slotState;
        }
        if (eFeature instanceof EAttribute) {
            slotState = this.createSimpleSlotState((EAttribute)eFeature, ecoreValue);
            this.putSlotState(eFeature, slotState);
            return slotState;
        }
        EReference eReference = (EReference)eFeature;
        EReference eOppositeReference = this.objectManager.getEOppositeReference(eReference);
        Object object = eOpposite = ecoreValue != null ? ecoreValue : AbstractObjectManager.NOT_A_VALUE;
        if (eReference == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER) {
            slotState = this.createOclContainerSlotState(eReference, eOpposite);
            this.putSlotState((EStructuralFeature)eReference, slotState);
            return slotState;
        }
        if (eOppositeReference.isMany()) {
            if (eReference.isMany()) {
                slotState = this.createManyToManySlotState(eReference);
                this.putSlotState((EStructuralFeature)eReference, slotState);
                return slotState;
            }
            slotState = this.createOneToManyElementSlotState(eReference, eOppositeReference, eOpposite);
            this.putSlotState((EStructuralFeature)eReference, slotState);
            return slotState;
        }
        if (eReference.isMany()) {
            slotState = this.createOneToManyAggregatorSlotState(eReference, AbstractObjectManager.NOT_A_VALUE);
            this.putSlotState((EStructuralFeature)eReference, slotState);
            if (isPartial) {
                AbstractObjectState<@NonNull SS> elementObjectState = this.objectManager.getObjectState(eOpposite);
                elementObjectState.updateSlotState((EStructuralFeature)eOppositeReference, this.eObject, false);
            } else if (ecoreValue != null && ecoreValue != AbstractObjectManager.NOT_A_VALUE) {
                Iterable ecoreValues = (Iterable)ecoreValue;
                for (EObject element : ecoreValues) {
                    if (element == null) continue;
                    AbstractObjectState<@NonNull SS> elementObjectState = this.objectManager.getObjectState(element);
                    elementObjectState.updateSlotState((EStructuralFeature)eOppositeReference, this.eObject, false);
                }
            }
            return slotState;
        }
        AbstractObjectState<SS> oppositeObjectState = null;
        if (ecoreValue != null && ecoreValue != AbstractObjectManager.NOT_A_VALUE && (slotState = (oppositeObjectState = this.objectManager.getObjectState(ecoreValue)).basicGetSlotState((EStructuralFeature)eOppositeReference)) != null) {
            this.putSlotState((EStructuralFeature)eReference, slotState);
            return slotState;
        }
        if (!(eReference instanceof EOppositeReferenceImpl) || ecoreValue == AbstractObjectManager.NOT_A_VALUE) {
            slotState = this.createOneToOneSlotState(eReference, ecoreValue);
            if (oppositeObjectState != null) {
                oppositeObjectState.putSlotState((EStructuralFeature)eOppositeReference, slotState);
            }
            this.putSlotState((EStructuralFeature)eReference, slotState);
        } else {
            assert (ecoreValue != null);
            assert (oppositeObjectState != null);
            slotState = oppositeObjectState.createOneToOneSlotState(eOppositeReference, this.eObject);
            oppositeObjectState.putSlotState((EStructuralFeature)eOppositeReference, slotState);
            this.putSlotState((EStructuralFeature)eReference, slotState);
        }
        return slotState;
    }
}

