/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AssignmentPartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.GlobalPredicatePartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.LocalPredicatePartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitioningStrategy;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SpeculatedPartitionFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;

public abstract class AbstractPartitioningStrategy
implements PartitioningStrategy {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis;
    protected final @NonNull MappingPartitioner mappingPartitioner;
    protected final @NonNull AbstractTransformationAnalysis transformationAnalysis;
    protected final @NonNull RegionAnalysis regionAnalysis;
    protected final @NonNull List<@NonNull PartitionAnalysis> newPartitionAnalyses = new ArrayList<PartitionAnalysis>();

    protected AbstractPartitioningStrategy(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull MappingPartitioner mappingPartitioner) {
        this.scheduleManager = partitionedTransformationAnalysis.getScheduleManager();
        this.partitionedTransformationAnalysis = partitionedTransformationAnalysis;
        this.mappingPartitioner = mappingPartitioner;
        this.transformationAnalysis = mappingPartitioner.getTransformationAnalysis();
        this.regionAnalysis = mappingPartitioner.getRegionAnalysis();
    }

    protected void check() {
        if (this.newPartitionAnalyses.size() > 1) {
            this.mappingPartitioner.check();
        }
    }

    protected void createAssignmentPartitions() {
        for (NavigableEdge outputEdge : this.mappingPartitioner.getRealizedOutputEdges()) {
            if (this.mappingPartitioner.hasRealizedEdge((Edge)outputEdge)) continue;
            this.newPartitionAnalyses.add(new AssignmentPartitionFactory(this.mappingPartitioner, (Edge)outputEdge).createPartitionAnalysis(this.partitionedTransformationAnalysis));
        }
        for (NavigableEdge edge : this.mappingPartitioner.getRealizedEdges()) {
            if (this.mappingPartitioner.hasRealizedEdge((Edge)edge)) continue;
            this.newPartitionAnalyses.add(new AssignmentPartitionFactory(this.mappingPartitioner, (Edge)edge).createPartitionAnalysis(this.partitionedTransformationAnalysis));
        }
    }

    protected void createSpeculationPartitions() {
        boolean useActivators = this.useActivators();
        if (useActivators) {
            this.regionAnalysis.createLocalSuccess();
        }
        BasicPartitionAnalysis localPredicatePartition = new LocalPredicatePartitionFactory(this.mappingPartitioner, useActivators).createPartitionAnalysis(this.partitionedTransformationAnalysis);
        BasicPartitionAnalysis globalPredicatePartition = new GlobalPredicatePartitionFactory(this.mappingPartitioner).createPartitionAnalysis(this.partitionedTransformationAnalysis);
        BasicPartitionAnalysis speculatedPartition = new SpeculatedPartitionFactory(this.mappingPartitioner).createPartitionAnalysis(this.partitionedTransformationAnalysis);
        this.newPartitionAnalyses.add(localPredicatePartition);
        this.newPartitionAnalyses.add(globalPredicatePartition);
        this.newPartitionAnalyses.add(speculatedPartition);
        if (!useActivators) {
            globalPredicatePartition.addExplicitPredecessor(localPredicatePartition);
            speculatedPartition.addExplicitPredecessor(globalPredicatePartition);
        }
    }

    protected abstract boolean useActivators();
}

