/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.AbstractMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.Correlator;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.RegionMerger;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.impl.NamedMappingRegionImpl;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class EarlyMerger
extends AbstractMerger {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull LinkedHashSet<@NonNull MappingRegion> residualInputRegions;
    protected final @NonNull List<@NonNull MappingRegion> outputRegions = new ArrayList<MappingRegion>();

    public static @NonNull List<@NonNull MappingRegion> merge(@NonNull ScheduleManager scheduleManager, @NonNull Iterable<? extends @NonNull MappingRegion> inputRegions) {
        EarlyMerger earlyMerger = new EarlyMerger(scheduleManager, inputRegions);
        return earlyMerger.merge();
    }

    protected EarlyMerger(@NonNull ScheduleManager scheduleManager, @NonNull Iterable<? extends @NonNull MappingRegion> inputRegions) {
        this.scheduleManager = scheduleManager;
        this.residualInputRegions = Sets.newLinkedHashSet(inputRegions);
    }

    protected @NonNull Iterable<@NonNull Node> getHostNodes(@NonNull MappingRegion region) {
        HashSet<@NonNull Node> hostNodes = new HashSet<Node>();
        for (Node node : QVTscheduleUtil.getHeadNodes((Region)region)) {
            this.getHostNodesAccumulator(hostNodes, node);
        }
        return hostNodes;
    }

    protected void getHostNodesAccumulator(@NonNull Set<@NonNull Node> hostNodes, @NonNull Node node) {
        if (!node.isClass()) {
            return;
        }
        if (node.isNullLiteral()) {
            return;
        }
        if (node.isOperation()) {
            return;
        }
        if (!node.isRequired()) {
            return;
        }
        if (node.isConstant()) {
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                if (!edge.isPredicate()) continue;
                return;
            }
            return;
        }
        if (!node.isPattern()) {
            return;
        }
        if (!hostNodes.add(node)) {
            return;
        }
        for (NavigableEdge edge : node.getNavigableEdges()) {
            if (!edge.isUnconditional()) continue;
            Property property = edge.getProperty();
            if (edge.isNew()) {
                if (!this.isToZeroOrOne((TypedElement)property) || !this.isToZeroOrOne((TypedElement)property.getOpposite())) continue;
                this.getHostNodesAccumulator(hostNodes, edge.getEdgeTarget());
                continue;
            }
            if (!this.isToOne((TypedElement)property) || !this.isToOne((TypedElement)property.getOpposite())) continue;
            this.getHostNodesAccumulator(hostNodes, edge.getEdgeTarget());
        }
    }

    protected boolean isPrimaryCandidate(@NonNull Region mappingRegion) {
        List headNodes = mappingRegion.getHeadNodes();
        if (headNodes.size() != 1) {
            return false;
        }
        return !QVTscheduleUtil.hasPredicates((Region)mappingRegion);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean isSecondaryCandidate(@NonNull Region primaryRegion, @NonNull Region secondaryRegion, @NonNull Set<@NonNull ClassDatum> toOneReachableClasses) {
        @NonNull List secondaryHeadNodes = QVTscheduleUtil.Internal.getHeadNodesList((Region)secondaryRegion);
        if (secondaryHeadNodes.size() != 1) {
            return false;
        }
        Node classNode = (Node)secondaryHeadNodes.get(0);
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)classNode);
        return toOneReachableClasses.contains(classDatum);
    }

    private boolean isToOne(@Nullable TypedElement typedElement) {
        if (typedElement == null) {
            return false;
        }
        if (!typedElement.isIsRequired()) {
            return false;
        }
        Type type = typedElement.getType();
        return !(type instanceof CollectionType);
    }

    private boolean isToZeroOrOne(@Nullable TypedElement typedElement) {
        if (typedElement == null) {
            return false;
        }
        Type type = typedElement.getType();
        return !(type instanceof CollectionType);
    }

    protected @NonNull List<@NonNull MappingRegion> merge() {
        while (!this.residualInputRegions.isEmpty()) {
            Iterable<MappingRegion> secondaryRegions;
            @NonNull MappingRegion candidateRegion = (MappingRegion)this.residualInputRegions.iterator().next();
            MappingRegion mergedRegion = null;
            if (this.isPrimaryCandidate((Region)candidateRegion) && (secondaryRegions = this.selectSecondaryRegions(candidateRegion)) != null) {
                mergedRegion = this.merge(candidateRegion, secondaryRegions);
            }
            if (mergedRegion == null) {
                this.outputRegions.add(candidateRegion);
            } else {
                this.outputRegions.add(mergedRegion);
                this.scheduleManager.writeDebugGraphs((Graphable)mergedRegion, null);
            }
            this.residualInputRegions.remove(candidateRegion);
        }
        return this.outputRegions;
    }

    protected @Nullable MappingRegion merge(@NonNull MappingRegion candidateRegion, @NonNull Iterable<@NonNull MappingRegion> secondaryRegions) {
        MappingRegion primaryRegion = candidateRegion;
        MappingRegion mergedRegion = null;
        for (MappingRegion secondaryRegion : secondaryRegions) {
            EarlyRegionMerger forwardRegionMerger;
            Correlator forwardCorrelator;
            if (!this.residualInputRegions.contains(secondaryRegion)) continue;
            if (EARLY.isActive()) {
                EARLY.println("Correlating: " + secondaryRegion + ", " + primaryRegion);
            }
            if ((forwardCorrelator = Correlator.correlate(forwardRegionMerger = new EarlyRegionMerger(this.scheduleManager, primaryRegion), secondaryRegion, EarlyStrategy.INSTANCE, null)) == null) continue;
            boolean doMerge = false;
            EarlyRegionMerger reverseRegionMerger = new EarlyRegionMerger(this.scheduleManager, secondaryRegion);
            if (!this.isSharedHead((Region)primaryRegion, (Region)secondaryRegion)) {
                doMerge = false;
            } else if (Correlator.correlate(reverseRegionMerger, primaryRegion, EarlyStrategy.INSTANCE, forwardCorrelator) != null) {
                doMerge = true;
            }
            if (!doMerge) continue;
            this.residualInputRegions.remove(mergedRegion);
            this.residualInputRegions.remove(secondaryRegion);
            forwardRegionMerger.addSecondaryRegion(secondaryRegion, forwardCorrelator);
            forwardRegionMerger.prune();
            mergedRegion = forwardRegionMerger.create();
            this.scheduleManager.addMappingRegion(mergedRegion);
            forwardRegionMerger.check(mergedRegion);
            primaryRegion = mergedRegion;
        }
        return mergedRegion;
    }

    protected @Nullable Iterable<@NonNull MappingRegion> selectSecondaryRegions(@NonNull MappingRegion primaryRegion) {
        HashMap<@NonNull ClassDatum, @NonNull Integer> hostClass2count = new HashMap<ClassDatum, Integer>();
        for (Node hostNode : this.getHostNodes(primaryRegion)) {
            ClassDatum hostClassDatum;
            Integer count = (Integer)hostClass2count.get(hostClassDatum = QVTscheduleUtil.getClassDatum((Node)hostNode));
            hostClass2count.put(hostClassDatum, count != null ? count + 1 : 1);
        }
        HashSet<@NonNull MappingRegion> secondaryRegions = new HashSet<MappingRegion>();
        for (Map.Entry entry : hostClass2count.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            ClassDatum primaryClassDatum = (ClassDatum)entry.getKey();
            block2: for (Region region : this.scheduleManager.getOriginalContentsAnalysis().getConsumingRegions(primaryClassDatum)) {
                if (region == primaryRegion) continue;
                for (Node secondaryHeadNode : QVTscheduleUtil.getHeadNodes((Region)region)) {
                    if (QVTscheduleUtil.getClassDatum((Node)secondaryHeadNode) != primaryClassDatum) continue;
                    secondaryRegions.add((MappingRegion)region);
                    continue block2;
                }
            }
        }
        ArrayList<@NonNull MappingRegion> sortedSecondaryRegions = new ArrayList<MappingRegion>(secondaryRegions);
        Collections.sort(sortedSecondaryRegions, NameUtil.NAMEABLE_COMPARATOR);
        return sortedSecondaryRegions;
    }

    public static class EarlyMergedMappingRegion
    extends NamedMappingRegionImpl {
        public EarlyMergedMappingRegion(@NonNull ScheduleManager scheduleManager, @NonNull String name) {
            scheduleManager.addMappingRegion((MappingRegion)this);
            this.setName(name);
            this.setSymbolNameSuffix("_e");
        }
    }

    protected static class EarlyRegionMerger
    extends RegionMerger {
        protected EarlyRegionMerger(@NonNull ScheduleManager scheduleManager, @NonNull MappingRegion primaryRegion) {
            super(scheduleManager, primaryRegion);
        }

        @Override
        protected @NonNull MappingRegion createMergedRegion(@NonNull String mergedName) {
            return new EarlyMergedMappingRegion(this.scheduleManager, mergedName);
        }
    }

    private static class EarlyStrategy
    extends Correlator.AbstractCorrelationStrategy {
        public static @NonNull EarlyStrategy INSTANCE = new EarlyStrategy();

        private EarlyStrategy() {
        }
    }
}

